/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-06-04 07:08:08 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp8s_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1089986 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2906 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3848 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_campaign_emails` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` bigint unsigned DEFAULT NULL,
  `email_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'campaign',
  `subscriber_id` bigint unsigned DEFAULT NULL,
  `email_subject_id` bigint unsigned DEFAULT NULL,
  `email_address` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email_subject` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email_body` longtext COLLATE utf8mb4_unicode_520_ci,
  `email_headers` text COLLATE utf8mb4_unicode_520_ci,
  `is_open` tinyint(1) NOT NULL DEFAULT '0',
  `is_parsed` tinyint(1) NOT NULL DEFAULT '0',
  `click_counter` int DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'draft',
  `note` text COLLATE utf8mb4_unicode_520_ci,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `email_hash` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_cam__cid_idx` (`campaign_id` DESC),
  KEY `wp8s_fc_cam__sid_idx` (`subscriber_id` DESC),
  KEY `wp8s_fc_cam__et_idx` (`email_type`),
  KEY `wp8s_fc_cam__estidx` (`status`),
  KEY `wp8s_fc_cam__emtidx` (`email_hash`),
  KEY `wp8s_fc_cam__scheduled_at` (`scheduled_at`),
  KEY `wp8s_fc_cam__updated_at` (`updated_at`),
  KEY `wp8s_fc_cam_sc_at_status` (`scheduled_at`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_campaign_url_metrics` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url_id` bigint unsigned DEFAULT NULL,
  `campaign_id` bigint unsigned DEFAULT NULL,
  `subscriber_id` bigint unsigned DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'click',
  `ip_address` varchar(30) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `city` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `counter` int unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url_id` (`url_id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_campaigns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'campaign',
  `title` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `available_urls` text COLLATE utf8mb4_unicode_520_ci,
  `slug` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `template_id` bigint unsigned DEFAULT NULL,
  `email_subject` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email_pre_header` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email_body` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `recipients_count` int NOT NULL DEFAULT '0',
  `delay` int DEFAULT '0',
  `utm_status` tinyint(1) DEFAULT '0',
  `utm_source` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `utm_medium` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `utm_campaign` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `utm_term` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `utm_content` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `design_template` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_funnel_metrics` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `funnel_id` bigint unsigned DEFAULT NULL,
  `sequence_id` bigint unsigned DEFAULT NULL,
  `subscriber_id` bigint unsigned DEFAULT NULL,
  `benchmark_value` bigint unsigned DEFAULT '0',
  `benchmark_currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT 'USD',
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'completed',
  `notes` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_fmx__m_idx` (`funnel_id`),
  KEY `wp8s_fc_fmx__ms__idx` (`subscriber_id`),
  KEY `sequence_id` (`sequence_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_funnel_sequences` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `funnel_id` bigint unsigned DEFAULT NULL,
  `parent_id` bigint unsigned DEFAULT '0',
  `action_name` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `condition_type` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'sequence',
  `title` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'draft',
  `conditions` text COLLATE utf8mb4_unicode_520_ci,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  `note` text COLLATE utf8mb4_unicode_520_ci,
  `delay` int unsigned DEFAULT NULL,
  `c_delay` int unsigned DEFAULT NULL,
  `sequence` int unsigned DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_fq__fs_idx` (`status`),
  KEY `wp8s_fc_fq__fid_idx` (`funnel_id`),
  KEY `c_delay` (`c_delay`),
  KEY `sequence` (`sequence`),
  KEY `action_name` (`action_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_funnel_subscribers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `funnel_id` bigint unsigned DEFAULT NULL,
  `starting_sequence_id` bigint unsigned DEFAULT NULL,
  `next_sequence` bigint unsigned DEFAULT NULL,
  `subscriber_id` bigint unsigned DEFAULT NULL,
  `last_sequence_id` bigint unsigned DEFAULT NULL,
  `next_sequence_id` bigint unsigned DEFAULT NULL,
  `last_sequence_status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'pending',
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'active',
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'funnel',
  `last_executed_time` timestamp NULL DEFAULT NULL,
  `next_execution_time` timestamp NULL DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_520_ci,
  `source_trigger_name` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `source_ref_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_fsx__fidx` (`funnel_id`),
  KEY `wp8s_fc_fsx__fsq_idx` (`subscriber_id`),
  KEY `status` (`status`),
  KEY `type` (`type`),
  KEY `next_execution_time` (`next_execution_time`),
  KEY `next_sequence` (`next_sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_funnels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'funnel',
  `title` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `trigger_name` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'draft',
  `conditions` text COLLATE utf8mb4_unicode_520_ci,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_fn__f_idx` (`status`),
  KEY `wp8s_fc_fn__ft_idx` (`trigger_name`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_lists` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` tinytext COLLATE utf8mb4_unicode_520_ci,
  `is_public` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `object_type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_id` bigint DEFAULT NULL,
  `key` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_mt__mt_idx` (`object_type`),
  KEY `wp8s_fc_mt__mto_id_idx` (`object_id`),
  KEY `wp8s_fc_mt__mto_id_key` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_subscriber_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` bigint unsigned NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `object_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'option',
  `key` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_index__s_meta_id_idx` (`subscriber_id`),
  KEY `wp8s_fc_index__s_ot_idx` (`object_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_subscriber_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'open',
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'note',
  `is_private` tinyint DEFAULT '1',
  `title` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_sn__s_id_idx` (`subscriber_id` DESC),
  KEY `wp8s_fc_sn__s_idx` (`status` DESC),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_subscriber_pivot` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` bigint unsigned NOT NULL,
  `object_id` bigint unsigned NOT NULL,
  `object_type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wp8s_fc_srp__sp_id_idx` (`subscriber_id`),
  KEY `wp8s_fc_srp__sp_o_id_idx` (`object_id`),
  KEY `wp8s_fc_srp__sp_t_id_idx` (`object_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_subscribers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `hash` varchar(90) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `contact_owner` bigint unsigned DEFAULT NULL,
  `company_id` bigint unsigned DEFAULT NULL,
  `prefix` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `last_name` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timezone` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_line_1` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_line_2` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `postal_code` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `city` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `state` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(10,8) DEFAULT NULL,
  `total_points` int unsigned NOT NULL DEFAULT '0',
  `life_time_value` int unsigned NOT NULL DEFAULT '0',
  `phone` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'subscribed',
  `contact_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT 'lead',
  `source` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `avatar` varchar(192) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `last_activity` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `wp8s_fc_index__subscriber_user_id_idx` (`user_id`),
  KEY `wp8s_fc_index__subscriber_status_idx` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(192) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` tinytext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fc_url_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `short` (`short`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_ff_scheduled_actions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `form_id` bigint unsigned DEFAULT NULL,
  `origin_id` bigint unsigned DEFAULT NULL,
  `feed_id` bigint unsigned DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT 'submission_action',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  `note` tinytext COLLATE utf8mb4_unicode_520_ci,
  `retry_count` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fluentform_entry_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint unsigned DEFAULT NULL,
  `submission_id` bigint unsigned DEFAULT NULL,
  `field_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sub_field_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `field_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fluentform_form_analytics` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `source_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `platform` char(30) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `browser` char(30) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `count` int DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fluentform_form_meta` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fluentform_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT 'Draft',
  `appearance_settings` text COLLATE utf8mb4_unicode_520_ci,
  `form_fields` longtext COLLATE utf8mb4_unicode_520_ci,
  `has_payment` tinyint(1) NOT NULL DEFAULT '0',
  `type` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `conditions` text COLLATE utf8mb4_unicode_520_ci,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fluentform_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent_source_id` int unsigned DEFAULT NULL,
  `source_type` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `source_id` int unsigned DEFAULT NULL,
  `component` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` char(30) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fluentform_submission_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `response_id` bigint unsigned DEFAULT NULL,
  `form_id` int unsigned DEFAULT NULL,
  `meta_key` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `name` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_fluentform_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int unsigned DEFAULT NULL,
  `serial_number` int unsigned DEFAULT NULL,
  `response` longtext COLLATE utf8mb4_unicode_520_ci,
  `source_url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT 'unread' COMMENT 'possible values: read, unread, trashed',
  `is_favourite` tinyint(1) NOT NULL DEFAULT '0',
  `browser` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `device` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `city` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_status` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_type` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_total` float DEFAULT NULL,
  `total_paid` float DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=4590 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1129 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1088711 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_tutor_earnings` (
  `earning_id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `course_id` bigint DEFAULT NULL,
  `order_id` bigint DEFAULT NULL,
  `order_status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `course_price_total` decimal(16,2) DEFAULT NULL,
  `course_price_grand_total` decimal(16,2) DEFAULT NULL,
  `instructor_amount` decimal(16,2) DEFAULT NULL,
  `instructor_rate` decimal(16,2) DEFAULT NULL,
  `admin_amount` decimal(16,2) DEFAULT NULL,
  `admin_rate` decimal(16,2) DEFAULT NULL,
  `commission_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deduct_fees_amount` decimal(16,2) DEFAULT NULL,
  `deduct_fees_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deduct_fees_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `process_by` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`earning_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_tutor_quiz_attempt_answers` (
  `attempt_answer_id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `quiz_id` bigint DEFAULT NULL,
  `question_id` bigint DEFAULT NULL,
  `quiz_attempt_id` bigint DEFAULT NULL,
  `given_answer` longtext COLLATE utf8mb4_unicode_520_ci,
  `question_mark` decimal(8,2) DEFAULT NULL,
  `achieved_mark` decimal(8,2) DEFAULT NULL,
  `minus_mark` decimal(8,2) DEFAULT NULL,
  `is_correct` tinyint DEFAULT NULL,
  PRIMARY KEY (`attempt_answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_tutor_quiz_attempts` (
  `attempt_id` bigint NOT NULL AUTO_INCREMENT,
  `course_id` bigint DEFAULT NULL,
  `quiz_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `total_questions` int DEFAULT NULL,
  `total_answered_questions` int DEFAULT NULL,
  `total_marks` decimal(9,2) DEFAULT NULL,
  `earned_marks` decimal(9,2) DEFAULT NULL,
  `attempt_info` text COLLATE utf8mb4_unicode_520_ci,
  `attempt_status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attempt_ip` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attempt_started_at` datetime DEFAULT NULL,
  `attempt_ended_at` datetime DEFAULT NULL,
  `is_manually_reviewed` int DEFAULT NULL,
  `manually_reviewed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`attempt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_tutor_quiz_question_answers` (
  `answer_id` bigint NOT NULL AUTO_INCREMENT,
  `belongs_question_id` bigint DEFAULT NULL,
  `belongs_question_type` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `answer_title` text COLLATE utf8mb4_unicode_520_ci,
  `is_correct` tinyint DEFAULT NULL,
  `image_id` bigint DEFAULT NULL,
  `answer_two_gap_match` text COLLATE utf8mb4_unicode_520_ci,
  `answer_view_format` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `answer_settings` text COLLATE utf8mb4_unicode_520_ci,
  `answer_order` int DEFAULT '0',
  PRIMARY KEY (`answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_tutor_quiz_questions` (
  `question_id` bigint NOT NULL AUTO_INCREMENT,
  `quiz_id` bigint DEFAULT NULL,
  `question_title` text COLLATE utf8mb4_unicode_520_ci,
  `question_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `answer_explanation` longtext COLLATE utf8mb4_unicode_520_ci,
  `question_type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `question_mark` decimal(9,2) DEFAULT NULL,
  `question_settings` longtext COLLATE utf8mb4_unicode_520_ci,
  `question_order` int DEFAULT NULL,
  PRIMARY KEY (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_tutor_withdraws` (
  `withdraw_id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `method_data` text COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`withdraw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8s_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp8s_actionscheduler_actions */
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088703", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:27:10", "2024-05-28 11:27:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716895630;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716895630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:27:11", "2024-05-28 11:27:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088704", "action_scheduler/migration_hook", "complete", "2024-05-28 11:28:11", "2024-05-28 11:28:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1716895691;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1716895691;}", "2", "1", "2024-05-28 11:28:12", "2024-05-28 11:28:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088705", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:28:11", "2024-05-28 11:28:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716895691;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716895691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:28:12", "2024-05-28 11:28:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088706", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:29:12", "2024-05-28 11:29:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716895752;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716895752;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:29:18", "2024-05-28 11:29:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088707", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:30:18", "2024-05-28 11:30:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716895818;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716895818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:30:57", "2024-05-28 11:30:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088708", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:31:57", "2024-05-28 11:31:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716895917;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716895917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:32:09", "2024-05-28 11:32:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088709", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:33:09", "2024-05-28 11:33:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716895989;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716895989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:33:22", "2024-05-28 11:33:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088710", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:34:22", "2024-05-28 11:34:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896062;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896062;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:35:50", "2024-05-28 11:35:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088711", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:36:50", "2024-05-28 11:36:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896210;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:37:49", "2024-05-28 11:37:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088712", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:38:49", "2024-05-28 11:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896329;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:39:51", "2024-05-28 11:39:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088713", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:40:51", "2024-05-28 11:40:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896451;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896451;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:41:49", "2024-05-28 11:41:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088714", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:42:49", "2024-05-28 11:42:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896569;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:46:13", "2024-05-28 11:46:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088715", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:47:13", "2024-05-28 11:47:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896833;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:47:15", "2024-05-28 11:47:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088716", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:48:15", "2024-05-28 11:48:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896895;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:48:20", "2024-05-28 11:48:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088717", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:49:20", "2024-05-28 11:49:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716896960;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716896960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:49:37", "2024-05-28 11:49:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088718", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:50:37", "2024-05-28 11:50:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897037;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:50:57", "2024-05-28 11:50:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088719", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:51:57", "2024-05-28 11:51:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897117;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:52:07", "2024-05-28 11:52:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088720", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:53:07", "2024-05-28 11:53:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897187;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897187;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:53:16", "2024-05-28 11:53:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088721", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:54:16", "2024-05-28 11:54:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897256;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897256;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:54:32", "2024-05-28 11:54:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088722", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:55:32", "2024-05-28 11:55:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897332;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:56:34", "2024-05-28 11:56:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088723", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:57:34", "2024-05-28 11:57:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897454;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897454;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 11:58:34", "2024-05-28 11:58:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088724", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 11:59:34", "2024-05-28 11:59:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897574;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 12:00:36", "2024-05-28 12:00:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088725", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 12:01:36", "2024-05-28 12:01:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897696;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 12:02:44", "2024-05-28 12:02:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088726", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 12:03:44", "2024-05-28 12:03:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716897824;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716897824;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 13:04:41", "2024-05-28 13:04:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088727", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 13:05:41", "2024-05-28 13:05:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716901541;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716901541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 13:16:55", "2024-05-28 13:16:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088728", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 13:17:55", "2024-05-28 13:17:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716902275;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716902275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 13:26:31", "2024-05-28 13:26:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088729", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 13:27:31", "2024-05-28 13:27:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716902851;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716902851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 13:42:22", "2024-05-28 13:42:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088730", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 13:43:22", "2024-05-28 13:43:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716903802;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716903802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 14:25:14", "2024-05-28 14:25:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088731", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 14:26:14", "2024-05-28 14:26:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716906374;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716906374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 16:48:35", "2024-05-28 16:48:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088732", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 16:49:35", "2024-05-28 16:49:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716914975;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716914975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 17:14:35", "2024-05-28 17:14:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088733", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 17:15:35", "2024-05-28 17:15:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716916535;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716916535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 17:32:50", "2024-05-28 17:32:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088734", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 17:33:50", "2024-05-28 17:33:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716917630;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716917630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 17:49:32", "2024-05-28 17:49:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088735", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 17:50:32", "2024-05-28 17:50:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716918632;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716918632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 18:26:31", "2024-05-28 18:26:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088736", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 18:27:31", "2024-05-28 18:27:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716920851;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716920851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 18:48:38", "2024-05-28 18:48:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088737", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 18:49:38", "2024-05-28 18:49:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716922178;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716922178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 18:53:41", "2024-05-28 18:53:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088738", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 18:54:41", "2024-05-28 18:54:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716922481;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716922481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 19:42:17", "2024-05-28 19:42:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088739", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 19:43:17", "2024-05-28 19:43:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716925397;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716925397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-28 20:29:11", "2024-05-28 20:29:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088740", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-28 20:30:11", "2024-05-28 20:30:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716928211;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716928211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 03:24:31", "2024-05-29 03:24:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088741", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 03:25:31", "2024-05-29 03:25:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716953131;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716953131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 03:37:43", "2024-05-29 03:37:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088742", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 03:38:43", "2024-05-29 03:38:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716953923;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716953923;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 03:41:17", "2024-05-29 03:41:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088743", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 03:42:17", "2024-05-29 03:42:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716954137;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716954137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 03:54:54", "2024-05-29 03:54:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088744", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 03:55:54", "2024-05-29 03:55:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716954954;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716954954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 04:18:18", "2024-05-29 04:18:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088745", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 04:19:18", "2024-05-29 04:19:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716956358;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716956358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 04:40:47", "2024-05-29 04:40:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088746", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 04:41:47", "2024-05-29 04:41:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716957707;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716957707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 04:45:31", "2024-05-29 04:45:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088747", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 04:46:31", "2024-05-29 04:46:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716957991;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716957991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 05:03:35", "2024-05-29 05:03:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088748", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 05:04:35", "2024-05-29 05:04:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716959075;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716959075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 05:26:22", "2024-05-29 05:26:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088749", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 05:27:22", "2024-05-29 05:27:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716960442;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716960442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 05:49:38", "2024-05-29 05:49:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088750", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 05:50:38", "2024-05-29 05:50:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716961838;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716961838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 06:19:16", "2024-05-29 06:19:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088751", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 06:20:16", "2024-05-29 06:20:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716963616;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716963616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 06:30:49", "2024-05-29 06:30:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088752", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 06:31:49", "2024-05-29 06:31:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716964309;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716964309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 06:51:06", "2024-05-29 06:51:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088753", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 06:52:06", "2024-05-29 06:52:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716965526;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716965526;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 06:59:26", "2024-05-29 06:59:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088754", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:00:26", "2024-05-29 07:00:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716966026;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716966026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 07:08:05", "2024-05-29 07:08:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088755", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:09:05", "2024-05-29 07:09:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716966545;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716966545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 07:16:22", "2024-05-29 07:16:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088756", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:17:22", "2024-05-29 07:17:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716967042;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716967042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 07:24:52", "2024-05-29 07:24:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088757", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:25:52", "2024-05-29 07:25:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716967552;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716967552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 07:32:48", "2024-05-29 07:32:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088758", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:33:48", "2024-05-29 07:33:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716968028;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716968028;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 07:40:38", "2024-05-29 07:40:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088759", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:41:38", "2024-05-29 07:41:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716968498;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716968498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 07:46:02", "2024-05-29 07:46:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088760", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:47:02", "2024-05-29 07:47:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716968822;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716968822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 07:48:03", "2024-05-29 07:48:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088761", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 07:49:03", "2024-05-29 07:49:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716968943;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716968943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:02:55", "2024-05-29 08:02:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088762", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:03:55", "2024-05-29 08:03:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716969835;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716969835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:10:07", "2024-05-29 08:10:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088763", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:11:07", "2024-05-29 08:11:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716970267;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716970267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:16:39", "2024-05-29 08:16:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088764", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:17:39", "2024-05-29 08:17:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716970659;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716970659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:23:09", "2024-05-29 08:23:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088765", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:24:09", "2024-05-29 08:24:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716971049;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716971049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:29:29", "2024-05-29 08:29:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088766", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:30:29", "2024-05-29 08:30:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716971429;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716971429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:35:44", "2024-05-29 08:35:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088767", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:36:44", "2024-05-29 08:36:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716971804;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716971804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:41:54", "2024-05-29 08:41:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088768", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:42:54", "2024-05-29 08:42:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716972174;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716972174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:47:39", "2024-05-29 08:47:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088769", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:48:39", "2024-05-29 08:48:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716972519;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716972519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:53:44", "2024-05-29 08:53:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088770", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 08:54:44", "2024-05-29 08:54:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716972884;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716972884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 08:59:33", "2024-05-29 08:59:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088771", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:00:33", "2024-05-29 09:00:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716973233;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716973233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:02:55", "2024-05-29 09:02:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088772", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:03:55", "2024-05-29 09:03:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716973435;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716973435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:05:12", "2024-05-29 09:05:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088773", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:06:12", "2024-05-29 09:06:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716973572;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716973572;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:17:42", "2024-05-29 09:17:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088774", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:18:43", "2024-05-29 09:18:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716974323;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716974323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:30:29", "2024-05-29 09:30:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088775", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:31:29", "2024-05-29 09:31:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716975089;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716975089;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:36:35", "2024-05-29 09:36:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088776", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:37:35", "2024-05-29 09:37:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716975455;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716975455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:43:50", "2024-05-29 09:43:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088777", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:44:50", "2024-05-29 09:44:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716975890;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716975890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:50:36", "2024-05-29 09:50:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088778", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:51:36", "2024-05-29 09:51:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716976296;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716976296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 09:58:02", "2024-05-29 09:58:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088779", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 09:59:02", "2024-05-29 09:59:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716976742;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716976742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:05:16", "2024-05-29 10:05:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088780", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:06:16", "2024-05-29 10:06:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716977176;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716977176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:12:24", "2024-05-29 10:12:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088781", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:13:24", "2024-05-29 10:13:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716977604;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716977604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:19:35", "2024-05-29 10:19:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088782", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:20:35", "2024-05-29 10:20:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716978035;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716978035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:27:14", "2024-05-29 10:27:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088783", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:28:14", "2024-05-29 10:28:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716978494;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716978494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:34:30", "2024-05-29 10:34:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088784", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:35:30", "2024-05-29 10:35:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716978930;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716978930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:39:47", "2024-05-29 10:39:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088785", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:40:47", "2024-05-29 10:40:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716979247;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716979247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:42:02", "2024-05-29 10:42:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088786", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:43:02", "2024-05-29 10:43:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716979382;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716979382;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:49:41", "2024-05-29 10:49:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088787", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:50:41", "2024-05-29 10:50:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716979841;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716979841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:51:44", "2024-05-29 10:51:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088788", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:52:44", "2024-05-29 10:52:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716979964;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716979964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 10:57:20", "2024-05-29 10:57:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088789", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 10:58:20", "2024-05-29 10:58:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716980300;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716980300;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:05:11", "2024-05-29 11:05:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088790", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:06:11", "2024-05-29 11:06:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716980771;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716980771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:13:21", "2024-05-29 11:13:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088791", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:14:21", "2024-05-29 11:14:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716981261;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716981261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:21:15", "2024-05-29 11:21:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088792", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:22:15", "2024-05-29 11:22:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716981735;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716981735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:29:20", "2024-05-29 11:29:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088793", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:30:20", "2024-05-29 11:30:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716982220;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716982220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:36:07", "2024-05-29 11:36:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088794", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:37:07", "2024-05-29 11:37:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716982627;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716982627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:38:10", "2024-05-29 11:38:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088795", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:39:10", "2024-05-29 11:39:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716982750;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716982750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:44:51", "2024-05-29 11:44:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088796", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:45:51", "2024-05-29 11:45:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716983151;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716983151;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 11:53:16", "2024-05-29 11:53:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088797", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 11:54:16", "2024-05-29 11:54:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716983656;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716983656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 12:02:05", "2024-05-29 12:02:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088798", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 12:03:05", "2024-05-29 12:03:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716984185;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716984185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 12:11:03", "2024-05-29 12:11:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088799", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 12:12:03", "2024-05-29 12:12:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716984723;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716984723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 12:17:47", "2024-05-29 12:17:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088800", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 12:18:47", "2024-05-29 12:18:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716985127;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716985127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 12:32:46", "2024-05-29 12:32:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088801", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 12:33:46", "2024-05-29 12:33:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716986026;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716986026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 13:30:53", "2024-05-29 13:30:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088802", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 13:31:53", "2024-05-29 13:31:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716989513;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716989513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 14:27:19", "2024-05-29 14:27:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088803", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 14:28:19", "2024-05-29 14:28:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716992899;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716992899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 14:56:56", "2024-05-29 14:56:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088804", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 14:57:56", "2024-05-29 14:57:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716994676;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716994676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:07:12", "2024-05-29 15:07:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088805", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:08:12", "2024-05-29 15:08:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716995292;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716995292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:10:49", "2024-05-29 15:10:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088806", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:11:49", "2024-05-29 15:11:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716995509;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716995509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:13:12", "2024-05-29 15:13:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088807", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:14:12", "2024-05-29 15:14:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716995652;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716995652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:14:49", "2024-05-29 15:14:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088808", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:15:49", "2024-05-29 15:15:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716995749;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716995749;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:27:19", "2024-05-29 15:27:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088809", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:28:19", "2024-05-29 15:28:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716996499;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716996499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:30:33", "2024-05-29 15:30:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088810", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:31:33", "2024-05-29 15:31:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716996693;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716996693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:44:14", "2024-05-29 15:44:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088811", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:45:14", "2024-05-29 15:45:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716997514;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716997514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 15:47:30", "2024-05-29 15:47:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088812", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 15:48:30", "2024-05-29 15:48:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716997710;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716997710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 16:00:31", "2024-05-29 16:00:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088813", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 16:01:31", "2024-05-29 16:01:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716998491;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716998491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 16:04:16", "2024-05-29 16:04:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088814", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 16:05:16", "2024-05-29 16:05:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716998716;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716998716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 16:21:55", "2024-05-29 16:21:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088815", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 16:22:55", "2024-05-29 16:22:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1716999775;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1716999775;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 16:34:37", "2024-05-29 16:34:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088816", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 16:35:37", "2024-05-29 16:35:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717000537;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717000537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 16:37:50", "2024-05-29 16:37:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088817", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 16:38:50", "2024-05-29 16:38:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717000730;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717000730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 16:51:19", "2024-05-29 16:51:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088818", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 16:52:19", "2024-05-29 16:52:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717001539;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717001539;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 16:54:33", "2024-05-29 16:54:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088819", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 16:55:33", "2024-05-29 16:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717001733;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717001733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:07:46", "2024-05-29 17:07:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088820", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 17:08:46", "2024-05-29 17:08:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717002526;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717002526;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:10:57", "2024-05-29 17:10:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088821", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 17:11:57", "2024-05-29 17:11:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717002717;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717002717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:24:17", "2024-05-29 17:24:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088822", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 17:25:17", "2024-05-29 17:25:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717003517;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717003517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:27:26", "2024-05-29 17:27:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088823", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 17:28:26", "2024-05-29 17:28:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717003706;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717003706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:40:31", "2024-05-29 17:40:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088824", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 17:41:31", "2024-05-29 17:41:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717004491;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717004491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:43:40", "2024-05-29 17:43:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088825", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 17:44:40", "2024-05-29 17:44:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717004680;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717004680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:56:47", "2024-05-29 17:56:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088826", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 17:57:47", "2024-05-29 17:57:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717005467;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717005467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 17:59:57", "2024-05-29 17:59:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088827", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:00:57", "2024-05-29 18:00:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717005657;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717005657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:04:34", "2024-05-29 18:04:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088828", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:05:34", "2024-05-29 18:05:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717005934;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717005934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:06:12", "2024-05-29 18:06:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088829", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:07:12", "2024-05-29 18:07:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006032;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:08:10", "2024-05-29 18:08:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088830", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:09:10", "2024-05-29 18:09:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006150;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:09:10", "2024-05-29 18:09:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088831", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:10:10", "2024-05-29 18:10:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006210;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:10:12", "2024-05-29 18:10:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088832", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:11:12", "2024-05-29 18:11:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006272;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:12:09", "2024-05-29 18:12:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088833", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:13:09", "2024-05-29 18:13:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006389;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:13:10", "2024-05-29 18:13:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088834", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:14:10", "2024-05-29 18:14:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006450;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:15:11", "2024-05-29 18:15:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088835", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:16:11", "2024-05-29 18:16:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006571;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:17:08", "2024-05-29 18:17:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088836", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:18:08", "2024-05-29 18:18:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006688;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:18:12", "2024-05-29 18:18:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088837", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:19:12", "2024-05-29 18:19:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006752;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006752;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:19:12", "2024-05-29 18:19:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088838", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:20:12", "2024-05-29 18:20:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006812;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006812;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:21:11", "2024-05-29 18:21:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088839", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:22:11", "2024-05-29 18:22:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717006931;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717006931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:23:10", "2024-05-29 18:23:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088840", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:24:10", "2024-05-29 18:24:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007050;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:25:11", "2024-05-29 18:25:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088841", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:26:11", "2024-05-29 18:26:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007171;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:27:12", "2024-05-29 18:27:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088842", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:28:12", "2024-05-29 18:28:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007292;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:29:10", "2024-05-29 18:29:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088843", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:30:10", "2024-05-29 18:30:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007410;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:30:10", "2024-05-29 18:30:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088844", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:31:10", "2024-05-29 18:31:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007470;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007470;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:31:11", "2024-05-29 18:31:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088845", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:32:11", "2024-05-29 18:32:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007531;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007531;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:33:11", "2024-05-29 18:33:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088846", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:34:11", "2024-05-29 18:34:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007651;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:34:11", "2024-05-29 18:34:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088847", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:35:11", "2024-05-29 18:35:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007711;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007711;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:35:11", "2024-05-29 18:35:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088848", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:36:11", "2024-05-29 18:36:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007771;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:37:10", "2024-05-29 18:37:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088849", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:38:10", "2024-05-29 18:38:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007890;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:38:12", "2024-05-29 18:38:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088850", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:39:12", "2024-05-29 18:39:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717007952;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717007952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:40:12", "2024-05-29 18:40:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088851", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:41:12", "2024-05-29 18:41:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008072;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:42:11", "2024-05-29 18:42:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088852", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:43:11", "2024-05-29 18:43:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008191;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:43:12", "2024-05-29 18:43:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088853", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:44:12", "2024-05-29 18:44:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008252;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:45:12", "2024-05-29 18:45:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088854", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:46:12", "2024-05-29 18:46:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008372;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008372;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:47:13", "2024-05-29 18:47:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088855", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:48:13", "2024-05-29 18:48:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008493;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:49:11", "2024-05-29 18:49:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088856", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:50:11", "2024-05-29 18:50:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008611;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:50:11", "2024-05-29 18:50:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088857", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:51:12", "2024-05-29 18:51:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008672;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:52:09", "2024-05-29 18:52:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088858", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:53:09", "2024-05-29 18:53:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008789;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:53:09", "2024-05-29 18:53:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088859", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:54:09", "2024-05-29 18:54:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008849;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:54:12", "2024-05-29 18:54:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088860", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:55:12", "2024-05-29 18:55:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717008912;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717008912;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:56:10", "2024-05-29 18:56:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088861", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:57:10", "2024-05-29 18:57:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009030;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:57:11", "2024-05-29 18:57:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088862", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 18:58:11", "2024-05-29 18:58:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009091;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 18:59:10", "2024-05-29 18:59:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088863", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:00:10", "2024-05-29 19:00:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009210;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:00:11", "2024-05-29 19:00:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088864", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:01:11", "2024-05-29 19:01:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009271;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:01:11", "2024-05-29 19:01:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088865", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:02:11", "2024-05-29 19:02:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009331;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:03:10", "2024-05-29 19:03:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088866", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:04:10", "2024-05-29 19:04:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009450;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:05:11", "2024-05-29 19:05:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088867", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:06:11", "2024-05-29 19:06:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009571;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:06:12", "2024-05-29 19:06:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088868", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:07:13", "2024-05-29 19:07:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009633;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:08:10", "2024-05-29 19:08:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088869", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:09:10", "2024-05-29 19:09:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009750;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:10:11", "2024-05-29 19:10:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088870", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:11:11", "2024-05-29 19:11:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009871;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:11:11", "2024-05-29 19:11:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088871", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:12:11", "2024-05-29 19:12:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717009931;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717009931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:13:11", "2024-05-29 19:13:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088872", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:14:11", "2024-05-29 19:14:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010051;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:15:10", "2024-05-29 19:15:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088873", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:16:10", "2024-05-29 19:16:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010170;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:17:12", "2024-05-29 19:17:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088874", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:18:12", "2024-05-29 19:18:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010292;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:19:12", "2024-05-29 19:19:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088875", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:20:12", "2024-05-29 19:20:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010412;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:21:10", "2024-05-29 19:21:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088876", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:22:10", "2024-05-29 19:22:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010530;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:22:11", "2024-05-29 19:22:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088877", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:23:11", "2024-05-29 19:23:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010591;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:24:12", "2024-05-29 19:24:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088878", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:25:12", "2024-05-29 19:25:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010712;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:26:12", "2024-05-29 19:26:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088879", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:27:12", "2024-05-29 19:27:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010832;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010832;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:28:11", "2024-05-29 19:28:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088880", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:29:11", "2024-05-29 19:29:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717010951;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717010951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:29:13", "2024-05-29 19:29:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088881", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:30:13", "2024-05-29 19:30:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011013;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:31:12", "2024-05-29 19:31:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088882", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:32:12", "2024-05-29 19:32:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011132;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:33:10", "2024-05-29 19:33:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088883", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:34:10", "2024-05-29 19:34:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011250;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:34:14", "2024-05-29 19:34:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088884", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:35:14", "2024-05-29 19:35:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011314;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011314;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:36:10", "2024-05-29 19:36:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088885", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:37:10", "2024-05-29 19:37:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011430;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:37:10", "2024-05-29 19:37:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088886", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:38:10", "2024-05-29 19:38:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011490;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:38:11", "2024-05-29 19:38:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088887", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:39:11", "2024-05-29 19:39:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011551;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:39:13", "2024-05-29 19:39:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088888", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:40:13", "2024-05-29 19:40:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011613;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:41:13", "2024-05-29 19:41:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088889", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:42:13", "2024-05-29 19:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011733;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:43:11", "2024-05-29 19:43:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088890", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:44:11", "2024-05-29 19:44:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011851;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:44:14", "2024-05-29 19:44:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088891", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:45:14", "2024-05-29 19:45:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717011914;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717011914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:46:12", "2024-05-29 19:46:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088892", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:47:12", "2024-05-29 19:47:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012032;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:48:12", "2024-05-29 19:48:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088893", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:49:12", "2024-05-29 19:49:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012152;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:50:13", "2024-05-29 19:50:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088894", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:51:13", "2024-05-29 19:51:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012273;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:52:12", "2024-05-29 19:52:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088895", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:53:12", "2024-05-29 19:53:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012392;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:54:11", "2024-05-29 19:54:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088896", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:55:11", "2024-05-29 19:55:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012511;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:56:13", "2024-05-29 19:56:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088897", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:57:13", "2024-05-29 19:57:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012633;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 19:58:12", "2024-05-29 19:58:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088898", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 19:59:12", "2024-05-29 19:59:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012752;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012752;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:00:16", "2024-05-29 20:00:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088899", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:01:16", "2024-05-29 20:01:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012876;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:02:13", "2024-05-29 20:02:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088900", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:03:13", "2024-05-29 20:03:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717012993;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717012993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:03:14", "2024-05-29 20:03:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088901", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:04:14", "2024-05-29 20:04:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013054;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:05:15", "2024-05-29 20:05:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088902", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:06:15", "2024-05-29 20:06:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013175;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013175;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:07:14", "2024-05-29 20:07:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088903", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:08:14", "2024-05-29 20:08:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013294;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:09:15", "2024-05-29 20:09:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088904", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:10:15", "2024-05-29 20:10:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013415;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:11:12", "2024-05-29 20:11:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088905", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:12:12", "2024-05-29 20:12:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013532;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:13:12", "2024-05-29 20:13:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088906", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:14:12", "2024-05-29 20:14:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013652;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:15:11", "2024-05-29 20:15:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088907", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:16:11", "2024-05-29 20:16:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013771;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:16:12", "2024-05-29 20:16:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088908", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:17:13", "2024-05-29 20:17:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013833;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:18:11", "2024-05-29 20:18:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088909", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:19:11", "2024-05-29 20:19:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717013951;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717013951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:19:12", "2024-05-29 20:19:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088910", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:20:12", "2024-05-29 20:20:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014012;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014012;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:21:13", "2024-05-29 20:21:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088911", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:22:13", "2024-05-29 20:22:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014133;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:22:14", "2024-05-29 20:22:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088912", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:23:14", "2024-05-29 20:23:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014194;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014194;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:24:13", "2024-05-29 20:24:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088913", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:25:13", "2024-05-29 20:25:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014313;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:26:16", "2024-05-29 20:26:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088914", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:27:16", "2024-05-29 20:27:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014436;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014436;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:28:12", "2024-05-29 20:28:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088915", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:29:12", "2024-05-29 20:29:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014552;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:29:13", "2024-05-29 20:29:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088916", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:30:13", "2024-05-29 20:30:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014613;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:31:13", "2024-05-29 20:31:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088917", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:32:13", "2024-05-29 20:32:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014733;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:33:10", "2024-05-29 20:33:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088918", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:34:10", "2024-05-29 20:34:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014850;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:35:14", "2024-05-29 20:35:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088919", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:36:14", "2024-05-29 20:36:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717014974;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717014974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:37:11", "2024-05-29 20:37:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088920", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:38:11", "2024-05-29 20:38:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015091;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:38:15", "2024-05-29 20:38:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088921", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:39:15", "2024-05-29 20:39:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015155;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:40:12", "2024-05-29 20:40:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088922", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:41:12", "2024-05-29 20:41:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015272;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:41:15", "2024-05-29 20:41:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088923", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:42:15", "2024-05-29 20:42:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015335;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:43:11", "2024-05-29 20:43:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088924", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:44:11", "2024-05-29 20:44:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015451;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015451;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:45:13", "2024-05-29 20:45:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088925", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:46:13", "2024-05-29 20:46:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015573;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:47:12", "2024-05-29 20:47:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088926", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:48:12", "2024-05-29 20:48:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015692;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:48:17", "2024-05-29 20:48:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088927", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:49:17", "2024-05-29 20:49:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015757;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:50:15", "2024-05-29 20:50:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088928", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:51:15", "2024-05-29 20:51:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015875;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:52:17", "2024-05-29 20:52:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088929", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:53:17", "2024-05-29 20:53:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717015997;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717015997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:54:16", "2024-05-29 20:54:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088930", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:55:16", "2024-05-29 20:55:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016116;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:56:12", "2024-05-29 20:56:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088931", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:57:12", "2024-05-29 20:57:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016232;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:58:11", "2024-05-29 20:58:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088932", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 20:59:14", "2024-05-29 20:59:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016354;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 20:59:16", "2024-05-29 20:59:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088933", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:00:16", "2024-05-29 21:00:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016416;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016416;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:01:13", "2024-05-29 21:01:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088934", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:02:13", "2024-05-29 21:02:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016533;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:03:11", "2024-05-29 21:03:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088935", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:04:11", "2024-05-29 21:04:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016651;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:04:12", "2024-05-29 21:04:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088936", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:05:12", "2024-05-29 21:05:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016712;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:05:18", "2024-05-29 21:05:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088937", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:06:18", "2024-05-29 21:06:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016778;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:07:16", "2024-05-29 21:07:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088938", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:08:16", "2024-05-29 21:08:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717016896;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717016896;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:09:16", "2024-05-29 21:09:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088939", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:10:16", "2024-05-29 21:10:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717017016;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717017016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:12:43", "2024-05-29 21:12:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088940", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:13:45", "2024-05-29 21:13:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717017225;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717017225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:28:51", "2024-05-29 21:28:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088941", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:29:51", "2024-05-29 21:29:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717018191;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717018191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:40:36", "2024-05-29 21:40:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088942", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:41:36", "2024-05-29 21:41:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717018896;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717018896;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:43:35", "2024-05-29 21:43:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088943", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:44:35", "2024-05-29 21:44:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717019075;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717019075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:55:53", "2024-05-29 21:55:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088944", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:56:53", "2024-05-29 21:56:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717019813;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717019813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 21:58:53", "2024-05-29 21:58:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088945", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 21:59:53", "2024-05-29 21:59:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717019993;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717019993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 22:11:33", "2024-05-29 22:11:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088946", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 22:12:33", "2024-05-29 22:12:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717020753;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717020753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 22:14:31", "2024-05-29 22:14:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088947", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 22:15:32", "2024-05-29 22:15:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717020932;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717020932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 22:27:00", "2024-05-29 22:27:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088948", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 22:28:00", "2024-05-29 22:28:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717021680;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717021680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 22:30:05", "2024-05-29 22:30:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088949", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 22:31:05", "2024-05-29 22:31:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717021865;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717021865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 22:42:34", "2024-05-29 22:42:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088950", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 22:43:34", "2024-05-29 22:43:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717022614;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717022614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 22:46:12", "2024-05-29 22:46:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088951", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 22:47:12", "2024-05-29 22:47:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717022832;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717022832;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 22:57:58", "2024-05-29 22:57:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088952", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 22:58:58", "2024-05-29 22:58:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717023538;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717023538;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 23:00:57", "2024-05-29 23:00:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088953", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 23:01:57", "2024-05-29 23:01:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717023717;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717023717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 23:13:26", "2024-05-29 23:13:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088954", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 23:14:26", "2024-05-29 23:14:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717024466;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717024466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 23:16:23", "2024-05-29 23:16:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088955", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 23:17:23", "2024-05-29 23:17:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717024643;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717024643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 23:29:00", "2024-05-29 23:29:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088956", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 23:30:00", "2024-05-29 23:30:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717025400;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717025400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 23:31:57", "2024-05-29 23:31:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088957", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 23:32:57", "2024-05-29 23:32:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717025577;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717025577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 23:44:29", "2024-05-29 23:44:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088958", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 23:45:29", "2024-05-29 23:45:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717026329;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717026329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-29 23:47:31", "2024-05-29 23:47:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088959", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-29 23:48:31", "2024-05-29 23:48:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717026511;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717026511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:00:09", "2024-05-30 00:00:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088960", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:01:09", "2024-05-30 00:01:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717027269;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717027269;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:03:11", "2024-05-30 00:03:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088961", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:04:11", "2024-05-30 00:04:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717027451;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717027451;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:15:53", "2024-05-30 00:15:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088962", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:16:53", "2024-05-30 00:16:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717028213;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717028213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:18:54", "2024-05-30 00:18:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088963", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:19:54", "2024-05-30 00:19:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717028394;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717028394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:31:38", "2024-05-30 00:31:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088964", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:32:38", "2024-05-30 00:32:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717029158;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717029158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:34:44", "2024-05-30 00:34:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088965", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:35:44", "2024-05-30 00:35:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717029344;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717029344;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:47:34", "2024-05-30 00:47:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088966", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:48:34", "2024-05-30 00:48:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717030114;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717030114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 00:50:34", "2024-05-30 00:50:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088967", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 00:51:34", "2024-05-30 00:51:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717030294;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717030294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:03:27", "2024-05-30 01:03:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088968", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:04:27", "2024-05-30 01:04:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717031067;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717031067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:06:30", "2024-05-30 01:06:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088969", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:07:30", "2024-05-30 01:07:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717031250;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717031250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:19:21", "2024-05-30 01:19:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088970", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:20:21", "2024-05-30 01:20:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717032021;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717032021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:22:27", "2024-05-30 01:22:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088971", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:23:27", "2024-05-30 01:23:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717032207;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717032207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:35:20", "2024-05-30 01:35:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088972", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:36:20", "2024-05-30 01:36:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717032980;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717032980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:38:26", "2024-05-30 01:38:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088973", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:39:26", "2024-05-30 01:39:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717033166;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717033166;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:51:19", "2024-05-30 01:51:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088974", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:52:19", "2024-05-30 01:52:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717033939;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717033939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 01:54:24", "2024-05-30 01:54:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088975", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 01:55:24", "2024-05-30 01:55:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717034124;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717034124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:07:28", "2024-05-30 02:07:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088976", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:08:29", "2024-05-30 02:08:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717034909;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717034909;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:10:40", "2024-05-30 02:10:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088977", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:11:40", "2024-05-30 02:11:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717035100;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717035100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:21:11", "2024-05-30 02:21:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088978", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:22:11", "2024-05-30 02:22:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717035731;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717035731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:23:13", "2024-05-30 02:23:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088979", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:24:13", "2024-05-30 02:24:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717035853;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717035853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:26:59", "2024-05-30 02:26:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088980", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:27:59", "2024-05-30 02:27:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717036079;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717036079;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:28:16", "2024-05-30 02:28:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088981", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:29:16", "2024-05-30 02:29:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717036156;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717036156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:32:22", "2024-05-30 02:32:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088982", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:33:22", "2024-05-30 02:33:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717036402;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717036402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:39:59", "2024-05-30 02:39:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088983", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:40:59", "2024-05-30 02:40:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717036859;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717036859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:43:08", "2024-05-30 02:43:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088984", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:44:08", "2024-05-30 02:44:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717037048;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717037048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:56:08", "2024-05-30 02:56:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088985", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 02:57:08", "2024-05-30 02:57:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717037828;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717037828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 02:59:16", "2024-05-30 02:59:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088986", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 03:00:16", "2024-05-30 03:00:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717038016;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717038016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 03:12:25", "2024-05-30 03:12:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088987", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 03:13:25", "2024-05-30 03:13:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717038805;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717038805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 03:15:35", "2024-05-30 03:15:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088988", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 03:16:35", "2024-05-30 03:16:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717038995;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717038995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 03:28:37", "2024-05-30 03:28:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088989", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 03:29:37", "2024-05-30 03:29:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717039777;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717039777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 03:31:46", "2024-05-30 03:31:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088990", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 03:32:46", "2024-05-30 03:32:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717039966;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717039966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 03:44:59", "2024-05-30 03:44:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088991", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 03:45:59", "2024-05-30 03:45:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717040759;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717040759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 03:48:00", "2024-05-30 03:48:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088992", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 03:49:00", "2024-05-30 03:49:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717040940;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717040940;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:01:01", "2024-05-30 04:01:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088993", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:02:01", "2024-05-30 04:02:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717041721;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717041721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:04:10", "2024-05-30 04:04:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088994", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:05:10", "2024-05-30 04:05:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717041910;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717041910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:17:20", "2024-05-30 04:17:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088995", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:18:20", "2024-05-30 04:18:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717042700;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717042700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:20:30", "2024-05-30 04:20:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088996", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:21:30", "2024-05-30 04:21:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717042890;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717042890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:33:34", "2024-05-30 04:33:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088997", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:34:34", "2024-05-30 04:34:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717043674;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717043674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:36:52", "2024-05-30 04:36:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088998", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:37:52", "2024-05-30 04:37:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717043872;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717043872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:49:44", "2024-05-30 04:49:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1088999", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:50:44", "2024-05-30 04:50:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717044644;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717044644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 04:52:54", "2024-05-30 04:52:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089000", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 04:53:54", "2024-05-30 04:53:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717044834;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717044834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:05:57", "2024-05-30 05:05:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089001", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:06:57", "2024-05-30 05:06:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717045617;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717045617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:09:06", "2024-05-30 05:09:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089002", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:10:06", "2024-05-30 05:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717045806;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717045806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:22:05", "2024-05-30 05:22:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089003", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:23:05", "2024-05-30 05:23:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717046585;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717046585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:25:16", "2024-05-30 05:25:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089004", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:26:16", "2024-05-30 05:26:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717046776;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717046776;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:38:19", "2024-05-30 05:38:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089005", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:39:19", "2024-05-30 05:39:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717047559;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717047559;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:41:34", "2024-05-30 05:41:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089006", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:42:34", "2024-05-30 05:42:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717047754;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717047754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:54:35", "2024-05-30 05:54:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089007", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:55:35", "2024-05-30 05:55:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717048535;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717048535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 05:57:44", "2024-05-30 05:57:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089008", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 05:58:45", "2024-05-30 05:58:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717048725;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717048725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 06:11:01", "2024-05-30 06:11:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089009", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 06:12:01", "2024-05-30 06:12:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717049521;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717049521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 06:14:15", "2024-05-30 06:14:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089010", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 06:15:15", "2024-05-30 06:15:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717049715;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717049715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 06:27:37", "2024-05-30 06:27:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089011", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 06:28:37", "2024-05-30 06:28:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717050517;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717050517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 06:30:48", "2024-05-30 06:30:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089012", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 06:31:48", "2024-05-30 06:31:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717050708;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717050708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 06:42:15", "2024-05-30 06:42:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089013", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 06:43:15", "2024-05-30 06:43:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717051395;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717051395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 06:44:02", "2024-05-30 06:44:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089014", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 06:45:02", "2024-05-30 06:45:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717051502;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717051502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 06:47:13", "2024-05-30 06:47:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089015", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 06:48:13", "2024-05-30 06:48:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717051693;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717051693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 07:00:27", "2024-05-30 07:00:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089016", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 07:01:27", "2024-05-30 07:01:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717052487;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717052487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 07:03:40", "2024-05-30 07:03:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089017", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 07:04:40", "2024-05-30 07:04:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717052680;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717052680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 07:07:00", "2024-05-30 07:07:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089018", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 07:08:00", "2024-05-30 07:08:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717052880;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717052880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 08:37:31", "2024-05-30 08:37:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089019", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 08:38:31", "2024-05-30 08:38:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717058311;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717058311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 11:08:29", "2024-05-30 11:08:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089020", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 11:09:29", "2024-05-30 11:09:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717067369;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717067369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 11:10:54", "2024-05-30 11:10:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089021", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 11:11:54", "2024-05-30 11:11:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717067514;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717067514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 11:14:09", "2024-05-30 11:14:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089022", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 11:15:09", "2024-05-30 11:15:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717067709;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717067709;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 11:27:25", "2024-05-30 11:27:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089023", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 11:28:25", "2024-05-30 11:28:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717068505;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717068505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 11:30:27", "2024-05-30 11:30:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089024", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 11:31:27", "2024-05-30 11:31:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717068687;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717068687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 11:43:43", "2024-05-30 11:43:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089025", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 11:44:43", "2024-05-30 11:44:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717069483;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717069483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 11:46:57", "2024-05-30 11:46:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089026", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 11:47:57", "2024-05-30 11:47:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717069677;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717069677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 12:03:20", "2024-05-30 12:03:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089027", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 12:04:20", "2024-05-30 12:04:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717070660;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717070660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 12:16:22", "2024-05-30 12:16:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089028", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 12:17:22", "2024-05-30 12:17:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717071442;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717071442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 12:19:32", "2024-05-30 12:19:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089029", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 12:20:32", "2024-05-30 12:20:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717071632;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717071632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 12:32:35", "2024-05-30 12:32:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089030", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 12:33:35", "2024-05-30 12:33:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717072415;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717072415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 12:35:44", "2024-05-30 12:35:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089031", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 12:36:44", "2024-05-30 12:36:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717072604;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717072604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 12:48:45", "2024-05-30 12:48:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089032", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 12:49:45", "2024-05-30 12:49:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717073385;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717073385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 12:52:39", "2024-05-30 12:52:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089033", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 12:53:39", "2024-05-30 12:53:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717073619;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717073619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:04:53", "2024-05-30 13:04:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089034", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:05:53", "2024-05-30 13:05:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717074353;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717074353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:08:04", "2024-05-30 13:08:04", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089035", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:09:04", "2024-05-30 13:09:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717074544;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717074544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:21:18", "2024-05-30 13:21:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089036", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:22:18", "2024-05-30 13:22:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717075338;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717075338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:24:26", "2024-05-30 13:24:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089037", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:25:26", "2024-05-30 13:25:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717075526;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717075526;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:37:29", "2024-05-30 13:37:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089038", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:38:29", "2024-05-30 13:38:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717076309;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717076309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:40:37", "2024-05-30 13:40:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089039", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:41:37", "2024-05-30 13:41:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717076497;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717076497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:53:42", "2024-05-30 13:53:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089040", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:54:42", "2024-05-30 13:54:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717077282;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717077282;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 13:56:51", "2024-05-30 13:56:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089041", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 13:57:51", "2024-05-30 13:57:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717077471;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717077471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 14:08:12", "2024-05-30 14:08:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089042", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 14:09:12", "2024-05-30 14:09:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717078152;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717078152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 14:11:34", "2024-05-30 14:11:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089043", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 14:12:34", "2024-05-30 14:12:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717078354;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717078354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 14:28:12", "2024-05-30 14:28:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089044", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 14:29:12", "2024-05-30 14:29:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717079352;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717079352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 14:56:45", "2024-05-30 14:56:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089045", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 14:57:45", "2024-05-30 14:57:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717081065;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717081065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 15:09:59", "2024-05-30 15:09:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089046", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 15:10:59", "2024-05-30 15:10:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717081859;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717081859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 15:13:13", "2024-05-30 15:13:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089047", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 15:14:13", "2024-05-30 15:14:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717082053;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717082053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 15:26:30", "2024-05-30 15:26:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089048", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 15:27:30", "2024-05-30 15:27:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717082850;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717082850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 15:30:29", "2024-05-30 15:30:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089049", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 15:31:29", "2024-05-30 15:31:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717083089;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717083089;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 15:42:57", "2024-05-30 15:42:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089050", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 15:43:57", "2024-05-30 15:43:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717083837;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717083837;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 15:46:09", "2024-05-30 15:46:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089051", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 15:47:09", "2024-05-30 15:47:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717084029;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717084029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 15:59:23", "2024-05-30 15:59:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089052", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:00:23", "2024-05-30 16:00:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717084823;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717084823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 16:02:39", "2024-05-30 16:02:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089053", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:03:39", "2024-05-30 16:03:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717085019;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717085019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 16:15:59", "2024-05-30 16:15:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089054", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:16:59", "2024-05-30 16:16:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717085819;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717085819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 16:19:11", "2024-05-30 16:19:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089055", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:20:11", "2024-05-30 16:20:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717086011;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717086011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 16:32:38", "2024-05-30 16:32:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089056", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:33:38", "2024-05-30 16:33:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717086818;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717086818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 16:35:55", "2024-05-30 16:35:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089057", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:36:55", "2024-05-30 16:36:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717087015;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717087015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 16:49:14", "2024-05-30 16:49:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089058", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:50:14", "2024-05-30 16:50:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717087814;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717087814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 16:52:24", "2024-05-30 16:52:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089059", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 16:53:24", "2024-05-30 16:53:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717088004;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717088004;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:05:46", "2024-05-30 17:05:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089060", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:06:46", "2024-05-30 17:06:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717088806;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717088806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:09:00", "2024-05-30 17:09:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089061", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:10:00", "2024-05-30 17:10:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717089000;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717089000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:22:14", "2024-05-30 17:22:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089062", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:23:14", "2024-05-30 17:23:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717089794;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717089794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:25:31", "2024-05-30 17:25:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089063", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:26:31", "2024-05-30 17:26:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717089991;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717089991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:38:42", "2024-05-30 17:38:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089064", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:39:42", "2024-05-30 17:39:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717090782;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717090782;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:41:53", "2024-05-30 17:41:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089065", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:42:53", "2024-05-30 17:42:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717090973;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717090973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:42:54", "2024-05-30 17:42:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089066", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:43:54", "2024-05-30 17:43:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717091034;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717091034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:55:10", "2024-05-30 17:55:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089067", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:56:10", "2024-05-30 17:56:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717091770;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717091770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 17:58:22", "2024-05-30 17:58:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089068", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 17:59:22", "2024-05-30 17:59:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717091962;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717091962;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 18:11:22", "2024-05-30 18:11:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089069", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 18:12:22", "2024-05-30 18:12:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717092742;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717092742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 18:14:31", "2024-05-30 18:14:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089070", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 18:15:31", "2024-05-30 18:15:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717092931;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717092931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 18:27:20", "2024-05-30 18:27:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089071", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 18:28:20", "2024-05-30 18:28:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717093700;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717093700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 18:30:28", "2024-05-30 18:30:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089072", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 18:31:28", "2024-05-30 18:31:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717093888;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717093888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 18:46:26", "2024-05-30 18:46:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089073", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 18:47:26", "2024-05-30 18:47:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717094846;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717094846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 18:59:22", "2024-05-30 18:59:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089074", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:00:22", "2024-05-30 19:00:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717095622;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717095622;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 19:02:24", "2024-05-30 19:02:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089075", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:03:24", "2024-05-30 19:03:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717095804;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717095804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 19:18:19", "2024-05-30 19:18:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089076", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:19:19", "2024-05-30 19:19:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717096759;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717096759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 19:31:03", "2024-05-30 19:31:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089077", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:32:03", "2024-05-30 19:32:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717097523;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717097523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 19:34:08", "2024-05-30 19:34:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089078", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:35:08", "2024-05-30 19:35:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717097708;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717097708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 19:46:49", "2024-05-30 19:46:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089079", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:47:49", "2024-05-30 19:47:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717098469;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717098469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 19:49:53", "2024-05-30 19:49:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089080", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:50:53", "2024-05-30 19:50:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717098653;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717098653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 19:51:43", "2024-05-30 19:51:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089081", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 19:52:43", "2024-05-30 19:52:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717098763;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717098763;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:02:32", "2024-05-30 20:02:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089082", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:03:32", "2024-05-30 20:03:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717099412;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717099412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:05:33", "2024-05-30 20:05:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089083", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:06:33", "2024-05-30 20:06:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717099593;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717099593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:18:13", "2024-05-30 20:18:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089084", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:19:13", "2024-05-30 20:19:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717100353;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717100353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:21:19", "2024-05-30 20:21:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089085", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:22:19", "2024-05-30 20:22:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717100539;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717100539;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:33:57", "2024-05-30 20:33:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089086", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:34:57", "2024-05-30 20:34:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717101297;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717101297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:36:58", "2024-05-30 20:36:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089087", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:37:58", "2024-05-30 20:37:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717101478;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717101478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:49:27", "2024-05-30 20:49:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089088", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:50:27", "2024-05-30 20:50:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717102227;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717102227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 20:52:42", "2024-05-30 20:52:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089089", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 20:53:42", "2024-05-30 20:53:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717102422;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717102422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:04:55", "2024-05-30 21:04:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089090", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:05:55", "2024-05-30 21:05:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717103155;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717103155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:07:59", "2024-05-30 21:07:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089091", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:08:59", "2024-05-30 21:08:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717103339;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717103339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:11:55", "2024-05-30 21:11:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089092", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:12:55", "2024-05-30 21:12:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717103575;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717103575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:20:23", "2024-05-30 21:20:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089093", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:21:23", "2024-05-30 21:21:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717104083;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717104083;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:23:24", "2024-05-30 21:23:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089094", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:24:24", "2024-05-30 21:24:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717104264;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717104264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:35:56", "2024-05-30 21:35:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089095", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:36:56", "2024-05-30 21:36:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717105016;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717105016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:38:58", "2024-05-30 21:38:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089096", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:39:58", "2024-05-30 21:39:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717105198;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717105198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:47:25", "2024-05-30 21:47:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089097", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:48:25", "2024-05-30 21:48:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717105705;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717105705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:51:26", "2024-05-30 21:51:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089098", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:52:26", "2024-05-30 21:52:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717105946;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717105946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 21:54:27", "2024-05-30 21:54:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089099", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 21:55:27", "2024-05-30 21:55:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717106127;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717106127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:03:19", "2024-05-30 22:03:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089100", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:04:20", "2024-05-30 22:04:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717106660;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717106660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:06:57", "2024-05-30 22:06:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089101", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:07:57", "2024-05-30 22:07:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717106877;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717106877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:10:18", "2024-05-30 22:10:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089102", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:11:19", "2024-05-30 22:11:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717107079;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717107079;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:22:34", "2024-05-30 22:22:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089103", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:23:34", "2024-05-30 22:23:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717107814;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717107814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:25:39", "2024-05-30 22:25:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089104", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:26:39", "2024-05-30 22:26:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717107999;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717107999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:28:54", "2024-05-30 22:28:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089105", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:29:54", "2024-05-30 22:29:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717108194;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717108194;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:38:23", "2024-05-30 22:38:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089106", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:39:23", "2024-05-30 22:39:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717108763;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717108763;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:41:18", "2024-05-30 22:41:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089107", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:42:18", "2024-05-30 22:42:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717108938;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717108938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:54:00", "2024-05-30 22:54:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089108", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:55:00", "2024-05-30 22:55:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717109700;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717109700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 22:57:50", "2024-05-30 22:57:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089109", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 22:58:50", "2024-05-30 22:58:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717109930;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717109930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:09:48", "2024-05-30 23:09:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089110", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 23:10:48", "2024-05-30 23:10:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717110648;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717110648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:12:46", "2024-05-30 23:12:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089111", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 23:13:46", "2024-05-30 23:13:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717110826;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717110826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:25:26", "2024-05-30 23:25:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089112", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 23:26:26", "2024-05-30 23:26:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717111586;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717111586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:28:35", "2024-05-30 23:28:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089113", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 23:29:35", "2024-05-30 23:29:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717111775;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717111775;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:41:11", "2024-05-30 23:41:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089114", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 23:42:11", "2024-05-30 23:42:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717112531;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717112531;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:44:18", "2024-05-30 23:44:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089115", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 23:45:18", "2024-05-30 23:45:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717112718;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717112718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:56:46", "2024-05-30 23:56:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089116", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-30 23:57:46", "2024-05-30 23:57:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717113466;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717113466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-30 23:59:46", "2024-05-30 23:59:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089117", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 00:00:46", "2024-05-31 00:00:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717113646;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717113646;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 00:12:28", "2024-05-31 00:12:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089118", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 00:13:28", "2024-05-31 00:13:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717114408;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717114408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 00:15:32", "2024-05-31 00:15:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089119", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 00:16:32", "2024-05-31 00:16:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717114592;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717114592;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 00:28:16", "2024-05-31 00:28:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089120", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 00:29:16", "2024-05-31 00:29:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717115356;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717115356;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 00:31:22", "2024-05-31 00:31:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089121", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 00:32:22", "2024-05-31 00:32:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717115542;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717115542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 00:44:08", "2024-05-31 00:44:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089122", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 00:45:08", "2024-05-31 00:45:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717116308;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717116308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 00:47:11", "2024-05-31 00:47:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089123", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 00:48:11", "2024-05-31 00:48:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717116491;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717116491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 00:59:58", "2024-05-31 00:59:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089124", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 01:00:58", "2024-05-31 01:00:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717117258;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717117258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 01:03:06", "2024-05-31 01:03:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089125", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 01:04:06", "2024-05-31 01:04:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717117446;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717117446;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 01:19:18", "2024-05-31 01:19:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089126", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 01:20:18", "2024-05-31 01:20:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717118418;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717118418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 01:32:22", "2024-05-31 01:32:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089127", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 01:33:22", "2024-05-31 01:33:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717119202;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717119202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 01:35:30", "2024-05-31 01:35:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089128", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 01:36:30", "2024-05-31 01:36:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717119390;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717119390;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 01:48:32", "2024-05-31 01:48:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089129", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 01:49:33", "2024-05-31 01:49:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717120173;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717120173;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 01:51:38", "2024-05-31 01:51:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089130", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 01:52:38", "2024-05-31 01:52:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717120358;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717120358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:05:00", "2024-05-31 02:05:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089131", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:06:00", "2024-05-31 02:06:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717121160;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717121160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:08:14", "2024-05-31 02:08:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089132", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:09:14", "2024-05-31 02:09:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717121354;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717121354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:21:22", "2024-05-31 02:21:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089133", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:22:22", "2024-05-31 02:22:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717122142;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717122142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:24:56", "2024-05-31 02:24:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089134", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:25:56", "2024-05-31 02:25:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717122356;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717122356;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:38:17", "2024-05-31 02:38:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089135", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:39:17", "2024-05-31 02:39:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717123157;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717123157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:41:32", "2024-05-31 02:41:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089136", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:42:32", "2024-05-31 02:42:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717123352;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717123352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:54:50", "2024-05-31 02:54:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089137", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:55:50", "2024-05-31 02:55:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717124150;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717124150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 02:58:05", "2024-05-31 02:58:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089138", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 02:59:05", "2024-05-31 02:59:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717124345;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717124345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 03:11:30", "2024-05-31 03:11:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089139", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 03:12:30", "2024-05-31 03:12:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717125150;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717125150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 03:14:16", "2024-05-31 03:14:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089140", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 03:15:16", "2024-05-31 03:15:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717125316;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717125316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 03:15:42", "2024-05-31 03:15:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089141", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 03:16:42", "2024-05-31 03:16:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717125402;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717125402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 03:28:14", "2024-05-31 03:28:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089142", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 03:29:14", "2024-05-31 03:29:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717126154;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717126154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 03:31:30", "2024-05-31 03:31:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089143", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 03:32:30", "2024-05-31 03:32:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717126350;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717126350;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 03:44:52", "2024-05-31 03:44:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089144", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 03:45:52", "2024-05-31 03:45:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717127152;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717127152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 03:48:05", "2024-05-31 03:48:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089145", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 03:49:05", "2024-05-31 03:49:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717127345;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717127345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:01:28", "2024-05-31 04:01:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089146", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:02:28", "2024-05-31 04:02:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717128148;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717128148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:04:43", "2024-05-31 04:04:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089147", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:05:43", "2024-05-31 04:05:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717128343;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717128343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:16:55", "2024-05-31 04:16:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089148", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:17:55", "2024-05-31 04:17:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717129075;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717129075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:18:17", "2024-05-31 04:18:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089149", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:19:17", "2024-05-31 04:19:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717129157;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717129157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:22:24", "2024-05-31 04:22:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089150", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:23:24", "2024-05-31 04:23:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717129404;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717129404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:35:03", "2024-05-31 04:35:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089151", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:36:03", "2024-05-31 04:36:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717130163;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717130163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:39:11", "2024-05-31 04:39:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089152", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:40:11", "2024-05-31 04:40:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717130411;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717130411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:51:48", "2024-05-31 04:51:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089153", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:52:49", "2024-05-31 04:52:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717131169;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717131169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 04:55:06", "2024-05-31 04:55:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089154", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 04:56:06", "2024-05-31 04:56:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717131366;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717131366;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:01:33", "2024-05-31 05:01:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089155", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:02:33", "2024-05-31 05:02:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717131753;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717131753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:08:38", "2024-05-31 05:08:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089156", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:09:38", "2024-05-31 05:09:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717132178;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717132178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:11:53", "2024-05-31 05:11:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089157", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:12:53", "2024-05-31 05:12:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717132373;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717132373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:25:22", "2024-05-31 05:25:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089158", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:26:22", "2024-05-31 05:26:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717133182;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717133182;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:28:36", "2024-05-31 05:28:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089159", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:29:36", "2024-05-31 05:29:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717133376;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717133376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:42:01", "2024-05-31 05:42:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089160", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:43:01", "2024-05-31 05:43:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717134181;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717134181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:45:12", "2024-05-31 05:45:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089161", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:46:12", "2024-05-31 05:46:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717134372;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717134372;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 05:58:36", "2024-05-31 05:58:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089162", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 05:59:36", "2024-05-31 05:59:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717135176;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717135176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 06:01:57", "2024-05-31 06:01:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089163", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 06:02:57", "2024-05-31 06:02:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717135377;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717135377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 06:15:20", "2024-05-31 06:15:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089164", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 06:16:20", "2024-05-31 06:16:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717136180;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717136180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 06:18:34", "2024-05-31 06:18:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089165", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 06:19:34", "2024-05-31 06:19:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717136374;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717136374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 06:32:04", "2024-05-31 06:32:04", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089166", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 06:33:04", "2024-05-31 06:33:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717137184;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717137184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 06:35:23", "2024-05-31 06:35:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089167", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 06:36:23", "2024-05-31 06:36:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717137383;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717137383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 06:49:09", "2024-05-31 06:49:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089168", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 06:50:09", "2024-05-31 06:50:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717138209;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717138209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 06:52:26", "2024-05-31 06:52:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089169", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 06:53:26", "2024-05-31 06:53:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717138406;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717138406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 07:06:02", "2024-05-31 07:06:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089170", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 07:07:02", "2024-05-31 07:07:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717139222;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717139222;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 07:09:21", "2024-05-31 07:09:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089171", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 07:10:21", "2024-05-31 07:10:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717139421;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717139421;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 07:23:03", "2024-05-31 07:23:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089172", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 07:24:03", "2024-05-31 07:24:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717140243;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717140243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 07:26:21", "2024-05-31 07:26:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089173", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 07:27:21", "2024-05-31 07:27:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717140441;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717140441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 07:40:01", "2024-05-31 07:40:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089174", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 07:41:02", "2024-05-31 07:41:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717141262;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717141262;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 07:43:20", "2024-05-31 07:43:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089175", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 07:44:20", "2024-05-31 07:44:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717141460;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717141460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 07:56:46", "2024-05-31 07:56:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089176", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 07:57:46", "2024-05-31 07:57:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717142266;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717142266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 08:00:13", "2024-05-31 08:00:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089177", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 08:01:13", "2024-05-31 08:01:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717142473;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717142473;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 08:13:29", "2024-05-31 08:13:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089178", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 08:14:29", "2024-05-31 08:14:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717143269;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717143269;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 08:16:44", "2024-05-31 08:16:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089179", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 08:17:44", "2024-05-31 08:17:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717143464;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717143464;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 08:30:01", "2024-05-31 08:30:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089180", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 08:31:01", "2024-05-31 08:31:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717144261;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717144261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 08:33:15", "2024-05-31 08:33:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089181", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 08:34:15", "2024-05-31 08:34:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717144455;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717144455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 08:46:48", "2024-05-31 08:46:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089182", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 08:47:48", "2024-05-31 08:47:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717145268;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717145268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 08:50:03", "2024-05-31 08:50:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089183", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 08:51:03", "2024-05-31 08:51:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717145463;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717145463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:06:41", "2024-05-31 09:06:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089184", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:07:41", "2024-05-31 09:07:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717146461;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717146461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:20:09", "2024-05-31 09:20:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089185", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:21:10", "2024-05-31 09:21:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717147270;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717147270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:23:25", "2024-05-31 09:23:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089186", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:24:25", "2024-05-31 09:24:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717147465;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717147465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:28:14", "2024-05-31 09:28:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089187", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:29:14", "2024-05-31 09:29:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717147754;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717147754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:36:53", "2024-05-31 09:36:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089188", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:37:53", "2024-05-31 09:37:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717148273;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717148273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:40:14", "2024-05-31 09:40:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089189", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:41:14", "2024-05-31 09:41:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717148474;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717148474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:45:31", "2024-05-31 09:45:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089190", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:46:31", "2024-05-31 09:46:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717148791;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717148791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:53:30", "2024-05-31 09:53:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089191", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:54:30", "2024-05-31 09:54:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717149270;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717149270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 09:55:39", "2024-05-31 09:55:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089192", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 09:56:39", "2024-05-31 09:56:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717149399;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717149399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:04:11", "2024-05-31 10:04:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089193", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:05:11", "2024-05-31 10:05:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717149911;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717149911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:07:25", "2024-05-31 10:07:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089194", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:08:25", "2024-05-31 10:08:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717150105;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717150105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:20:54", "2024-05-31 10:20:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089195", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:21:54", "2024-05-31 10:21:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717150914;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717150914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:24:09", "2024-05-31 10:24:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089196", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:25:09", "2024-05-31 10:25:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717151109;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717151109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:37:37", "2024-05-31 10:37:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089197", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:38:37", "2024-05-31 10:38:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717151917;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717151917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:40:54", "2024-05-31 10:40:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089198", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:41:54", "2024-05-31 10:41:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717152114;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717152114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:54:14", "2024-05-31 10:54:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089199", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:55:14", "2024-05-31 10:55:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717152914;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717152914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 10:57:27", "2024-05-31 10:57:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089200", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 10:58:27", "2024-05-31 10:58:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717153107;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717153107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 11:10:54", "2024-05-31 11:10:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089201", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 11:11:54", "2024-05-31 11:11:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717153914;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717153914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 11:14:14", "2024-05-31 11:14:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089202", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 11:15:14", "2024-05-31 11:15:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717154114;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717154114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 11:27:31", "2024-05-31 11:27:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089203", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 11:28:31", "2024-05-31 11:28:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717154911;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717154911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 11:30:47", "2024-05-31 11:30:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089204", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 11:31:47", "2024-05-31 11:31:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717155107;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717155107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 11:41:11", "2024-05-31 11:41:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089205", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 11:42:11", "2024-05-31 11:42:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717155731;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717155731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 11:42:15", "2024-05-31 11:42:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089206", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 11:43:15", "2024-05-31 11:43:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717155795;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717155795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 11:47:05", "2024-05-31 11:47:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089207", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 11:48:05", "2024-05-31 11:48:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717156085;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717156085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 12:03:30", "2024-05-31 12:03:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089208", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 12:04:30", "2024-05-31 12:04:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717157070;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717157070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 12:20:10", "2024-05-31 12:20:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089209", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 12:21:10", "2024-05-31 12:21:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717158070;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717158070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 12:33:26", "2024-05-31 12:33:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089210", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 12:34:26", "2024-05-31 12:34:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717158866;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717158866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 12:36:40", "2024-05-31 12:36:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089211", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 12:37:40", "2024-05-31 12:37:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717159060;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717159060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 12:50:00", "2024-05-31 12:50:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089212", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 12:51:00", "2024-05-31 12:51:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717159860;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717159860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 12:53:15", "2024-05-31 12:53:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089213", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 12:54:15", "2024-05-31 12:54:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717160055;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717160055;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 13:06:48", "2024-05-31 13:06:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089214", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 13:07:48", "2024-05-31 13:07:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717160868;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717160868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 13:10:03", "2024-05-31 13:10:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089215", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 13:11:03", "2024-05-31 13:11:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717161063;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717161063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 13:23:27", "2024-05-31 13:23:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089216", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 13:24:27", "2024-05-31 13:24:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717161867;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717161867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 13:26:55", "2024-05-31 13:26:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089217", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 13:27:55", "2024-05-31 13:27:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717162075;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717162075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 13:40:30", "2024-05-31 13:40:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089218", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 13:41:30", "2024-05-31 13:41:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717162890;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717162890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 13:43:47", "2024-05-31 13:43:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089219", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 13:44:47", "2024-05-31 13:44:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717163087;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717163087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 13:57:22", "2024-05-31 13:57:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089220", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 13:58:22", "2024-05-31 13:58:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717163902;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717163902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:00:40", "2024-05-31 14:00:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089221", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:01:40", "2024-05-31 14:01:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717164100;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717164100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:14:20", "2024-05-31 14:14:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089222", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:15:20", "2024-05-31 14:15:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717164920;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717164920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:17:40", "2024-05-31 14:17:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089223", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:18:40", "2024-05-31 14:18:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717165120;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717165120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:31:14", "2024-05-31 14:31:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089224", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:32:14", "2024-05-31 14:32:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717165934;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717165934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:34:30", "2024-05-31 14:34:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089225", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:35:30", "2024-05-31 14:35:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717166130;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717166130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:45:37", "2024-05-31 14:45:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089226", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:46:37", "2024-05-31 14:46:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717166797;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717166797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:48:05", "2024-05-31 14:48:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089227", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:49:05", "2024-05-31 14:49:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717166945;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717166945;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 14:51:22", "2024-05-31 14:51:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089228", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 14:52:22", "2024-05-31 14:52:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717167142;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717167142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:04:59", "2024-05-31 15:04:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089229", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 15:05:59", "2024-05-31 15:05:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717167959;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717167959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:08:19", "2024-05-31 15:08:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089230", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 15:09:19", "2024-05-31 15:09:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717168159;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717168159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:22:06", "2024-05-31 15:22:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089231", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 15:23:06", "2024-05-31 15:23:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717168986;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717168986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:25:22", "2024-05-31 15:25:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089232", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 15:26:22", "2024-05-31 15:26:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717169182;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717169182;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:39:10", "2024-05-31 15:39:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089233", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 15:40:10", "2024-05-31 15:40:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717170010;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717170010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:42:32", "2024-05-31 15:42:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089234", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 15:43:32", "2024-05-31 15:43:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717170212;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717170212;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:56:13", "2024-05-31 15:56:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089235", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 15:57:13", "2024-05-31 15:57:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717171033;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717171033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 15:59:58", "2024-05-31 15:59:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089236", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 16:00:58", "2024-05-31 16:00:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717171258;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717171258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 16:13:52", "2024-05-31 16:13:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089237", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 16:14:52", "2024-05-31 16:14:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717172092;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717172092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 16:17:19", "2024-05-31 16:17:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089238", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 16:18:19", "2024-05-31 16:18:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717172299;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717172299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 16:31:19", "2024-05-31 16:31:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089239", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 16:32:19", "2024-05-31 16:32:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717173139;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717173139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 16:34:43", "2024-05-31 16:34:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089240", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 16:35:43", "2024-05-31 16:35:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717173343;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717173343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 16:48:38", "2024-05-31 16:48:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089241", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 16:49:38", "2024-05-31 16:49:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717174178;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717174178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 16:52:03", "2024-05-31 16:52:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089242", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 16:53:03", "2024-05-31 16:53:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717174383;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717174383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:06:03", "2024-05-31 17:06:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089243", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:07:03", "2024-05-31 17:07:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717175223;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717175223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:09:24", "2024-05-31 17:09:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089244", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:10:24", "2024-05-31 17:10:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717175424;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717175424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:23:23", "2024-05-31 17:23:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089245", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:24:23", "2024-05-31 17:24:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717176263;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717176263;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:26:47", "2024-05-31 17:26:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089246", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:27:47", "2024-05-31 17:27:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717176467;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717176467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:40:53", "2024-05-31 17:40:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089247", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:41:53", "2024-05-31 17:41:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717177313;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717177313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:44:14", "2024-05-31 17:44:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089248", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:45:14", "2024-05-31 17:45:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717177514;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717177514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:45:51", "2024-05-31 17:45:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089249", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:46:51", "2024-05-31 17:46:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717177611;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717177611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 17:58:15", "2024-05-31 17:58:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089250", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 17:59:15", "2024-05-31 17:59:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717178355;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717178355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:01:39", "2024-05-31 18:01:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089251", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:02:39", "2024-05-31 18:02:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717178559;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717178559;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:15:37", "2024-05-31 18:15:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089252", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:16:37", "2024-05-31 18:16:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717179397;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717179397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:19:01", "2024-05-31 18:19:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089253", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:20:01", "2024-05-31 18:20:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717179601;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717179601;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:33:03", "2024-05-31 18:33:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089254", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:34:03", "2024-05-31 18:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717180443;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717180443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:36:21", "2024-05-31 18:36:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089255", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:37:21", "2024-05-31 18:37:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717180641;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717180641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:44:57", "2024-05-31 18:44:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089256", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:45:57", "2024-05-31 18:45:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717181157;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717181157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:50:01", "2024-05-31 18:50:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089257", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:51:01", "2024-05-31 18:51:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717181461;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717181461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 18:53:19", "2024-05-31 18:53:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089258", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 18:54:19", "2024-05-31 18:54:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717181659;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717181659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:06:54", "2024-05-31 19:06:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089259", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:07:54", "2024-05-31 19:07:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717182474;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717182474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:10:11", "2024-05-31 19:10:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089260", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:11:11", "2024-05-31 19:11:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717182671;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717182671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:23:42", "2024-05-31 19:23:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089261", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:24:42", "2024-05-31 19:24:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717183482;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717183482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:26:20", "2024-05-31 19:26:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089262", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:27:20", "2024-05-31 19:27:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717183640;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717183640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:27:49", "2024-05-31 19:27:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089263", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:28:49", "2024-05-31 19:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717183729;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717183729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:40:19", "2024-05-31 19:40:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089264", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:41:19", "2024-05-31 19:41:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717184479;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717184479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:43:34", "2024-05-31 19:43:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089265", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:44:34", "2024-05-31 19:44:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717184674;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717184674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 19:57:02", "2024-05-31 19:57:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089266", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 19:58:02", "2024-05-31 19:58:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717185482;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717185482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 20:00:17", "2024-05-31 20:00:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089267", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 20:01:17", "2024-05-31 20:01:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717185677;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717185677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 20:13:53", "2024-05-31 20:13:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089268", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 20:14:53", "2024-05-31 20:14:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717186493;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717186493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 20:17:14", "2024-05-31 20:17:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089269", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 20:18:14", "2024-05-31 20:18:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717186694;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717186694;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 20:30:58", "2024-05-31 20:30:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089270", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 20:31:58", "2024-05-31 20:31:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717187518;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717187518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 20:34:11", "2024-05-31 20:34:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089271", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 20:35:11", "2024-05-31 20:35:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717187711;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717187711;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 20:47:24", "2024-05-31 20:47:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089272", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 20:48:24", "2024-05-31 20:48:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717188504;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717188504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 20:50:36", "2024-05-31 20:50:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089273", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 20:51:36", "2024-05-31 20:51:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717188696;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717188696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:03:50", "2024-05-31 21:03:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089274", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:04:50", "2024-05-31 21:04:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717189490;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717189490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:07:08", "2024-05-31 21:07:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089275", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:08:08", "2024-05-31 21:08:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717189688;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717189688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:20:20", "2024-05-31 21:20:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089276", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:21:20", "2024-05-31 21:21:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717190480;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717190480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:23:31", "2024-05-31 21:23:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089277", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:24:31", "2024-05-31 21:24:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717190671;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717190671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:36:47", "2024-05-31 21:36:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089278", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:37:47", "2024-05-31 21:37:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717191467;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717191467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:39:58", "2024-05-31 21:39:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089279", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:40:58", "2024-05-31 21:40:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717191658;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717191658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:53:07", "2024-05-31 21:53:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089280", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:54:07", "2024-05-31 21:54:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717192447;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717192447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 21:56:21", "2024-05-31 21:56:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089281", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 21:57:21", "2024-05-31 21:57:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717192641;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717192641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:09:34", "2024-05-31 22:09:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089282", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:10:34", "2024-05-31 22:10:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717193434;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717193434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:12:48", "2024-05-31 22:12:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089283", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:13:48", "2024-05-31 22:13:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717193628;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717193628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:26:03", "2024-05-31 22:26:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089284", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:27:03", "2024-05-31 22:27:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717194423;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717194423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:29:16", "2024-05-31 22:29:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089285", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:30:16", "2024-05-31 22:30:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717194616;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717194616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:42:26", "2024-05-31 22:42:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089286", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:43:26", "2024-05-31 22:43:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717195406;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717195406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:45:39", "2024-05-31 22:45:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089287", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:46:39", "2024-05-31 22:46:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717195599;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717195599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:54:33", "2024-05-31 22:54:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089288", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:55:33", "2024-05-31 22:55:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717196133;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717196133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 22:58:43", "2024-05-31 22:58:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089289", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 22:59:43", "2024-05-31 22:59:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717196383;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717196383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 23:02:43", "2024-05-31 23:02:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089290", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 23:03:43", "2024-05-31 23:03:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717196623;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717196623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 23:06:26", "2024-05-31 23:06:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089291", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 23:07:26", "2024-05-31 23:07:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717196846;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717196846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 23:14:53", "2024-05-31 23:14:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089292", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 23:15:53", "2024-05-31 23:15:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717197353;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717197353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 23:18:01", "2024-05-31 23:18:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089293", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 23:19:01", "2024-05-31 23:19:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717197541;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717197541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 23:31:02", "2024-05-31 23:31:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089294", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 23:32:02", "2024-05-31 23:32:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717198322;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717198322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 23:34:14", "2024-05-31 23:34:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089295", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 23:35:14", "2024-05-31 23:35:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717198514;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717198514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-05-31 23:50:21", "2024-05-31 23:50:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089296", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-05-31 23:51:21", "2024-05-31 23:51:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717199481;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717199481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:00:05", "2024-06-01 00:00:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089297", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:01:05", "2024-06-01 00:01:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717200065;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717200065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:03:22", "2024-06-01 00:03:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089298", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:04:22", "2024-06-01 00:04:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717200262;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717200262;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:06:33", "2024-06-01 00:06:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089299", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:07:33", "2024-06-01 00:07:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717200453;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717200453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:23:02", "2024-06-01 00:23:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089300", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:24:02", "2024-06-01 00:24:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717201442;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717201442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:36:12", "2024-06-01 00:36:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089301", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:37:12", "2024-06-01 00:37:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717202232;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717202232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:39:24", "2024-06-01 00:39:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089302", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:40:24", "2024-06-01 00:40:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717202424;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717202424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:52:34", "2024-06-01 00:52:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089303", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:53:34", "2024-06-01 00:53:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717203214;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717203214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 00:55:46", "2024-06-01 00:55:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089304", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 00:56:46", "2024-06-01 00:56:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717203406;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717203406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 01:09:06", "2024-06-01 01:09:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089305", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 01:10:06", "2024-06-01 01:10:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717204206;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717204206;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 01:12:19", "2024-06-01 01:12:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089306", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 01:13:19", "2024-06-01 01:13:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717204399;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717204399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 01:25:36", "2024-06-01 01:25:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089307", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 01:26:36", "2024-06-01 01:26:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717205196;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717205196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 01:28:46", "2024-06-01 01:28:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089308", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 01:29:46", "2024-06-01 01:29:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717205386;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717205386;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 01:41:49", "2024-06-01 01:41:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089309", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 01:42:49", "2024-06-01 01:42:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717206169;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717206169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 01:44:58", "2024-06-01 01:44:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089310", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 01:45:58", "2024-06-01 01:45:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717206358;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717206358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 01:57:56", "2024-06-01 01:57:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089311", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 01:58:56", "2024-06-01 01:58:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717207136;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717207136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 02:01:08", "2024-06-01 02:01:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089312", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 02:02:08", "2024-06-01 02:02:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717207328;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717207328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 02:11:27", "2024-06-01 02:11:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089313", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 02:12:27", "2024-06-01 02:12:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717207947;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717207947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 02:14:22", "2024-06-01 02:14:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089314", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 02:15:22", "2024-06-01 02:15:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717208122;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717208122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 02:17:35", "2024-06-01 02:17:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089315", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 02:18:35", "2024-06-01 02:18:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717208315;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717208315;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 02:30:38", "2024-06-01 02:30:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089316", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 02:31:38", "2024-06-01 02:31:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717209098;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717209098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 02:33:54", "2024-06-01 02:33:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089317", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 02:34:54", "2024-06-01 02:34:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717209294;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717209294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 03:56:37", "2024-06-01 03:56:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089318", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 03:57:37", "2024-06-01 03:57:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717214257;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717214257;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 03:58:19", "2024-06-01 03:58:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089319", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 03:59:19", "2024-06-01 03:59:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717214359;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717214359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 05:33:19", "2024-06-01 05:33:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089320", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 05:34:19", "2024-06-01 05:34:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717220059;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717220059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 05:58:09", "2024-06-01 05:58:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089321", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 05:59:09", "2024-06-01 05:59:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717221549;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717221549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 06:18:02", "2024-06-01 06:18:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089322", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 06:19:02", "2024-06-01 06:19:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717222742;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717222742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 06:40:05", "2024-06-01 06:40:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089323", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 06:41:05", "2024-06-01 06:41:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717224065;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717224065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 08:39:13", "2024-06-01 08:39:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089324", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 08:40:13", "2024-06-01 08:40:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717231213;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717231213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 08:49:29", "2024-06-01 08:49:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089325", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 08:50:29", "2024-06-01 08:50:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717231829;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717231829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 09:41:54", "2024-06-01 09:41:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089326", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 09:42:54", "2024-06-01 09:42:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717234974;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717234974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 11:36:08", "2024-06-01 11:36:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089327", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 11:37:08", "2024-06-01 11:37:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717241828;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717241828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 11:39:21", "2024-06-01 11:39:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089328", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 11:40:21", "2024-06-01 11:40:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717242021;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717242021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 11:52:34", "2024-06-01 11:52:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089329", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 11:53:34", "2024-06-01 11:53:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717242814;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717242814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 11:55:48", "2024-06-01 11:55:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089330", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 11:56:48", "2024-06-01 11:56:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717243008;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717243008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:05:15", "2024-06-01 12:05:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089331", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:06:15", "2024-06-01 12:06:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717243575;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717243575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:08:57", "2024-06-01 12:08:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089332", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:09:57", "2024-06-01 12:09:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717243797;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717243797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:12:12", "2024-06-01 12:12:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089333", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:13:12", "2024-06-01 12:13:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717243992;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717243992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:25:31", "2024-06-01 12:25:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089334", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:26:31", "2024-06-01 12:26:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717244791;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717244791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:28:44", "2024-06-01 12:28:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089335", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:29:44", "2024-06-01 12:29:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717244984;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717244984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:35:48", "2024-06-01 12:35:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089336", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:36:48", "2024-06-01 12:36:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717245408;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717245408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:42:01", "2024-06-01 12:42:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089337", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:43:01", "2024-06-01 12:43:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717245781;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717245781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:45:14", "2024-06-01 12:45:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089338", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:46:14", "2024-06-01 12:46:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717245974;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717245974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 12:58:29", "2024-06-01 12:58:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089339", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 12:59:29", "2024-06-01 12:59:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717246769;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717246769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 13:02:31", "2024-06-01 13:02:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089340", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 13:03:31", "2024-06-01 13:03:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717247011;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717247011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 13:14:50", "2024-06-01 13:14:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089341", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 13:15:50", "2024-06-01 13:15:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717247750;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717247750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 13:18:01", "2024-06-01 13:18:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089342", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 13:19:01", "2024-06-01 13:19:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717247941;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717247941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 13:31:20", "2024-06-01 13:31:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089343", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 13:32:20", "2024-06-01 13:32:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717248740;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717248740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 13:34:25", "2024-06-01 13:34:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089344", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 13:35:25", "2024-06-01 13:35:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717248925;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717248925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 13:47:22", "2024-06-01 13:47:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089345", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 13:48:22", "2024-06-01 13:48:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717249702;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717249702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 13:50:29", "2024-06-01 13:50:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089346", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 13:51:29", "2024-06-01 13:51:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717249889;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717249889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 14:03:05", "2024-06-01 14:03:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089347", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 14:04:06", "2024-06-01 14:04:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717250646;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717250646;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 14:06:42", "2024-06-01 14:06:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089348", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 14:07:42", "2024-06-01 14:07:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717250862;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717250862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 14:22:50", "2024-06-01 14:22:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089349", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 14:23:50", "2024-06-01 14:23:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717251830;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717251830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 14:36:06", "2024-06-01 14:36:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089350", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 14:37:06", "2024-06-01 14:37:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717252626;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717252626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 14:39:21", "2024-06-01 14:39:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089351", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 14:40:21", "2024-06-01 14:40:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717252821;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717252821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 14:52:36", "2024-06-01 14:52:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089352", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 14:53:36", "2024-06-01 14:53:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717253616;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717253616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 14:56:39", "2024-06-01 14:56:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089353", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 14:57:39", "2024-06-01 14:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717253859;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717253859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:03:55", "2024-06-01 15:03:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089354", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:04:55", "2024-06-01 15:04:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717254295;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717254295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:09:07", "2024-06-01 15:09:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089355", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:10:07", "2024-06-01 15:10:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717254607;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717254607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:12:14", "2024-06-01 15:12:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089356", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:13:14", "2024-06-01 15:13:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717254794;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717254794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:25:22", "2024-06-01 15:25:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089357", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:26:22", "2024-06-01 15:26:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717255582;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717255582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:28:29", "2024-06-01 15:28:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089358", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:29:29", "2024-06-01 15:29:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717255769;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717255769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:34:54", "2024-06-01 15:34:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089359", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:35:54", "2024-06-01 15:35:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717256154;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717256154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:39:03", "2024-06-01 15:39:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089360", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:40:03", "2024-06-01 15:40:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717256403;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717256403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:41:25", "2024-06-01 15:41:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089361", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:42:25", "2024-06-01 15:42:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717256545;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717256545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:43:10", "2024-06-01 15:43:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089362", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:44:10", "2024-06-01 15:44:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717256650;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717256650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:44:30", "2024-06-01 15:44:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089363", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:45:30", "2024-06-01 15:45:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717256730;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717256730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 15:57:23", "2024-06-01 15:57:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089364", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 15:58:23", "2024-06-01 15:58:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717257503;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717257503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 16:01:17", "2024-06-01 16:01:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089365", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 16:02:17", "2024-06-01 16:02:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717257737;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717257737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 16:13:11", "2024-06-01 16:13:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089366", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 16:14:11", "2024-06-01 16:14:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717258451;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717258451;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 16:16:19", "2024-06-01 16:16:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089367", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 16:17:19", "2024-06-01 16:17:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717258639;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717258639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 16:29:24", "2024-06-01 16:29:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089368", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 16:30:24", "2024-06-01 16:30:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717259424;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717259424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 16:32:31", "2024-06-01 16:32:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089369", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 16:33:31", "2024-06-01 16:33:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717259611;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717259611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 16:46:17", "2024-06-01 16:46:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089370", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 16:47:17", "2024-06-01 16:47:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717260437;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717260437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 16:49:27", "2024-06-01 16:49:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089371", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 16:50:27", "2024-06-01 16:50:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717260627;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717260627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:02:33", "2024-06-01 17:02:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089372", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:03:33", "2024-06-01 17:03:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717261413;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717261413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:05:45", "2024-06-01 17:05:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089373", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:06:45", "2024-06-01 17:06:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717261605;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717261605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:18:44", "2024-06-01 17:18:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089374", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:19:44", "2024-06-01 17:19:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717262384;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717262384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:21:52", "2024-06-01 17:21:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089375", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:22:52", "2024-06-01 17:22:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717262572;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717262572;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:34:50", "2024-06-01 17:34:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089376", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:35:50", "2024-06-01 17:35:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717263350;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717263350;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:38:09", "2024-06-01 17:38:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089377", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:39:09", "2024-06-01 17:39:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717263549;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717263549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:51:17", "2024-06-01 17:51:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089378", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:52:17", "2024-06-01 17:52:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717264337;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717264337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:54:18", "2024-06-01 17:54:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089379", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:55:18", "2024-06-01 17:55:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717264518;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717264518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 17:55:18", "2024-06-01 17:55:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089380", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 17:56:18", "2024-06-01 17:56:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717264578;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717264578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:07:18", "2024-06-01 18:07:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089381", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:08:18", "2024-06-01 18:08:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717265298;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717265298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:10:26", "2024-06-01 18:10:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089382", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:11:26", "2024-06-01 18:11:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717265486;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717265486;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:26:02", "2024-06-01 18:26:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089383", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:27:02", "2024-06-01 18:27:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717266422;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717266422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:27:17", "2024-06-01 18:27:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089384", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:28:17", "2024-06-01 18:28:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717266497;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717266497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:39:19", "2024-06-01 18:39:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089385", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:40:19", "2024-06-01 18:40:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717267219;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717267219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:42:23", "2024-06-01 18:42:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089386", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:43:23", "2024-06-01 18:43:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717267403;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717267403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:55:10", "2024-06-01 18:55:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089387", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:56:10", "2024-06-01 18:56:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717268170;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717268170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 18:58:10", "2024-06-01 18:58:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089388", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 18:59:10", "2024-06-01 18:59:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717268350;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717268350;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 19:10:50", "2024-06-01 19:10:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089389", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 19:11:50", "2024-06-01 19:11:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717269110;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717269110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 19:13:56", "2024-06-01 19:13:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089390", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 19:14:56", "2024-06-01 19:14:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717269296;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717269296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 19:26:33", "2024-06-01 19:26:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089391", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 19:27:33", "2024-06-01 19:27:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717270053;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717270053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 19:29:35", "2024-06-01 19:29:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089392", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 19:30:35", "2024-06-01 19:30:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717270235;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717270235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 19:42:12", "2024-06-01 19:42:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089393", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 19:43:12", "2024-06-01 19:43:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717270992;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717270992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 19:45:16", "2024-06-01 19:45:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089394", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 19:46:16", "2024-06-01 19:46:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717271176;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717271176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 19:57:51", "2024-06-01 19:57:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089395", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 19:58:51", "2024-06-01 19:58:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717271931;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717271931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:00:55", "2024-06-01 20:00:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089396", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:01:55", "2024-06-01 20:01:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717272115;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717272115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:13:29", "2024-06-01 20:13:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089397", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:14:29", "2024-06-01 20:14:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717272869;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717272869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:16:30", "2024-06-01 20:16:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089398", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:17:30", "2024-06-01 20:17:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717273050;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717273050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:29:04", "2024-06-01 20:29:04", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089399", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:30:04", "2024-06-01 20:30:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717273804;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717273804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:32:56", "2024-06-01 20:32:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089400", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:33:56", "2024-06-01 20:33:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717274036;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717274036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:37:55", "2024-06-01 20:37:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089401", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:38:55", "2024-06-01 20:38:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717274335;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717274335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:44:40", "2024-06-01 20:44:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089402", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:45:40", "2024-06-01 20:45:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717274740;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717274740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:47:44", "2024-06-01 20:47:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089403", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:48:44", "2024-06-01 20:48:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717274924;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717274924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:52:46", "2024-06-01 20:52:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089404", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:53:46", "2024-06-01 20:53:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717275226;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717275226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 20:56:52", "2024-06-01 20:56:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089405", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 20:57:52", "2024-06-01 20:57:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717275472;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717275472;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:00:15", "2024-06-01 21:00:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089406", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:01:15", "2024-06-01 21:01:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717275675;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717275675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:03:24", "2024-06-01 21:03:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089407", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:04:24", "2024-06-01 21:04:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717275864;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717275864;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:07:55", "2024-06-01 21:07:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089408", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:08:55", "2024-06-01 21:08:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717276135;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717276135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:14:43", "2024-06-01 21:14:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089409", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:15:43", "2024-06-01 21:15:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717276543;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717276543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:16:01", "2024-06-01 21:16:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089410", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:17:01", "2024-06-01 21:17:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717276621;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717276621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:18:32", "2024-06-01 21:18:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089411", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:19:32", "2024-06-01 21:19:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717276772;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717276772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:19:51", "2024-06-01 21:19:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089412", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:20:51", "2024-06-01 21:20:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717276851;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717276851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:22:39", "2024-06-01 21:22:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089413", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:23:39", "2024-06-01 21:23:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717277019;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717277019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:31:33", "2024-06-01 21:31:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089414", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:32:33", "2024-06-01 21:32:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717277553;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717277553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:34:32", "2024-06-01 21:34:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089415", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:35:32", "2024-06-01 21:35:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717277732;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717277732;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:38:10", "2024-06-01 21:38:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089416", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:39:10", "2024-06-01 21:39:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717277950;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717277950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:43:34", "2024-06-01 21:43:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089417", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:44:34", "2024-06-01 21:44:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717278274;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717278274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:46:49", "2024-06-01 21:46:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089418", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:47:49", "2024-06-01 21:47:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717278469;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717278469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:49:03", "2024-06-01 21:49:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089419", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:50:03", "2024-06-01 21:50:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717278603;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717278603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:50:33", "2024-06-01 21:50:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089420", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:51:33", "2024-06-01 21:51:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717278693;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717278693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 21:54:46", "2024-06-01 21:54:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089421", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 21:55:46", "2024-06-01 21:55:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717278946;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717278946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:00:35", "2024-06-01 22:00:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089422", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:01:35", "2024-06-01 22:01:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717279295;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717279295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:02:15", "2024-06-01 22:02:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089423", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:03:15", "2024-06-01 22:03:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717279395;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717279395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:05:12", "2024-06-01 22:05:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089424", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:06:12", "2024-06-01 22:06:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717279572;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717279572;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:06:15", "2024-06-01 22:06:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089425", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:07:15", "2024-06-01 22:07:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717279635;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717279635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:12:16", "2024-06-01 22:12:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089426", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:13:16", "2024-06-01 22:13:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717279996;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717279996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:17:39", "2024-06-01 22:17:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089427", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:18:39", "2024-06-01 22:18:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717280319;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717280319;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:20:42", "2024-06-01 22:20:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089428", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:21:42", "2024-06-01 22:21:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717280502;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717280502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:24:43", "2024-06-01 22:24:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089429", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:25:43", "2024-06-01 22:25:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717280743;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717280743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:30:25", "2024-06-01 22:30:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089430", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:31:25", "2024-06-01 22:31:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717281085;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717281085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:33:03", "2024-06-01 22:33:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089431", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:34:03", "2024-06-01 22:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717281243;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717281243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:36:03", "2024-06-01 22:36:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089432", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:37:03", "2024-06-01 22:37:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717281423;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717281423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:37:22", "2024-06-01 22:37:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089433", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:38:22", "2024-06-01 22:38:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717281502;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717281502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:48:24", "2024-06-01 22:48:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089434", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:49:24", "2024-06-01 22:49:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717282164;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717282164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:50:06", "2024-06-01 22:50:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089435", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:51:06", "2024-06-01 22:51:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717282266;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717282266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:51:23", "2024-06-01 22:51:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089436", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:52:23", "2024-06-01 22:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717282343;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717282343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 22:56:33", "2024-06-01 22:56:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089437", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 22:57:33", "2024-06-01 22:57:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717282653;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717282653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:03:31", "2024-06-01 23:03:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089438", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:04:31", "2024-06-01 23:04:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717283071;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717283071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:06:45", "2024-06-01 23:06:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089439", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:07:45", "2024-06-01 23:07:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717283265;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717283265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:09:57", "2024-06-01 23:09:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089440", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:10:57", "2024-06-01 23:10:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717283457;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717283457;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:16:57", "2024-06-01 23:16:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089441", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:17:57", "2024-06-01 23:17:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717283877;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717283877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:22:06", "2024-06-01 23:22:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089442", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:23:06", "2024-06-01 23:23:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717284186;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717284186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:24:08", "2024-06-01 23:24:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089443", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:25:08", "2024-06-01 23:25:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717284308;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717284308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:31:27", "2024-06-01 23:31:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089444", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:32:27", "2024-06-01 23:32:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717284747;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717284747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:37:34", "2024-06-01 23:37:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089445", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:38:34", "2024-06-01 23:38:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717285114;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717285114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-01 23:52:55", "2024-06-01 23:52:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089446", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-01 23:53:55", "2024-06-01 23:53:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717286035;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717286035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:00:50", "2024-06-02 00:00:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089447", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:01:50", "2024-06-02 00:01:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717286510;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717286510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:05:14", "2024-06-02 00:05:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089448", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:06:14", "2024-06-02 00:06:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717286774;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717286774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:09:08", "2024-06-02 00:09:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089449", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:10:08", "2024-06-02 00:10:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717287008;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717287008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:16:48", "2024-06-02 00:16:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089450", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:17:49", "2024-06-02 00:17:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717287469;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717287469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:20:42", "2024-06-02 00:20:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089451", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:21:42", "2024-06-02 00:21:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717287702;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717287702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:23:35", "2024-06-02 00:23:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089452", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:24:35", "2024-06-02 00:24:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717287875;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717287875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:32:34", "2024-06-02 00:32:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089453", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:33:34", "2024-06-02 00:33:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717288414;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717288414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:38:55", "2024-06-02 00:38:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089454", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:39:55", "2024-06-02 00:39:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717288795;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717288795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:41:06", "2024-06-02 00:41:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089455", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:42:06", "2024-06-02 00:42:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717288926;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717288926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:48:45", "2024-06-02 00:48:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089456", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:49:45", "2024-06-02 00:49:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717289385;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717289385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:51:22", "2024-06-02 00:51:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089457", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:52:22", "2024-06-02 00:52:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717289542;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717289542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:54:26", "2024-06-02 00:54:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089458", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:55:26", "2024-06-02 00:55:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717289726;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717289726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:56:43", "2024-06-02 00:56:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089459", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:57:43", "2024-06-02 00:57:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717289863;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717289863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 00:58:23", "2024-06-02 00:58:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089460", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 00:59:23", "2024-06-02 00:59:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717289963;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717289963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:04:51", "2024-06-02 01:04:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089461", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:05:51", "2024-06-02 01:05:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717290351;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717290351;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:07:03", "2024-06-02 01:07:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089462", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:08:03", "2024-06-02 01:08:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717290483;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717290483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:10:11", "2024-06-02 01:10:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089463", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:11:11", "2024-06-02 01:11:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717290671;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717290671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:13:07", "2024-06-02 01:13:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089464", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:14:07", "2024-06-02 01:14:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717290847;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717290847;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:22:03", "2024-06-02 01:22:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089465", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:23:03", "2024-06-02 01:23:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717291383;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717291383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:26:06", "2024-06-02 01:26:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089466", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:27:06", "2024-06-02 01:27:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717291626;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717291626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:29:49", "2024-06-02 01:29:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089467", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:30:49", "2024-06-02 01:30:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717291849;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717291849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:38:02", "2024-06-02 01:38:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089468", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:39:02", "2024-06-02 01:39:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717292342;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717292342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:41:59", "2024-06-02 01:41:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089469", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:42:59", "2024-06-02 01:42:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717292579;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717292579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:46:46", "2024-06-02 01:46:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089470", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:47:46", "2024-06-02 01:47:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717292866;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717292866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:55:22", "2024-06-02 01:55:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089471", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:56:22", "2024-06-02 01:56:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717293382;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717293382;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 01:57:52", "2024-06-02 01:57:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089472", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 01:58:52", "2024-06-02 01:58:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717293532;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717293532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:04:27", "2024-06-02 02:04:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089473", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:05:27", "2024-06-02 02:05:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717293927;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717293927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:10:39", "2024-06-02 02:10:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089474", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:11:39", "2024-06-02 02:11:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717294299;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717294299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:13:51", "2024-06-02 02:13:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089475", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:14:51", "2024-06-02 02:14:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717294491;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717294491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:22:35", "2024-06-02 02:22:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089476", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:23:36", "2024-06-02 02:23:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717295016;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717295016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:26:39", "2024-06-02 02:26:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089477", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:27:39", "2024-06-02 02:27:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717295259;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717295259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:29:46", "2024-06-02 02:29:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089478", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:30:46", "2024-06-02 02:30:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717295446;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717295446;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:31:45", "2024-06-02 02:31:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089479", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:32:45", "2024-06-02 02:32:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717295565;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717295565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:41:22", "2024-06-02 02:41:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089480", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:42:22", "2024-06-02 02:42:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717296142;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717296142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:42:37", "2024-06-02 02:42:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089481", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:43:37", "2024-06-02 02:43:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717296217;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717296217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:45:42", "2024-06-02 02:45:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089482", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:46:42", "2024-06-02 02:46:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717296402;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717296402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:50:24", "2024-06-02 02:50:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089483", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:51:24", "2024-06-02 02:51:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717296684;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717296684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:56:00", "2024-06-02 02:56:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089484", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:57:00", "2024-06-02 02:57:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717297020;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717297020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 02:58:30", "2024-06-02 02:58:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089485", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 02:59:30", "2024-06-02 02:59:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717297170;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717297170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:00:21", "2024-06-02 03:00:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089486", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:01:21", "2024-06-02 03:01:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717297281;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717297281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:01:39", "2024-06-02 03:01:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089487", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:02:39", "2024-06-02 03:02:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717297359;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717297359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:06:00", "2024-06-02 03:06:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089488", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:07:00", "2024-06-02 03:07:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717297620;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717297620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:14:36", "2024-06-02 03:14:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089489", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:15:36", "2024-06-02 03:15:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717298136;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717298136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:17:43", "2024-06-02 03:17:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089490", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:18:43", "2024-06-02 03:18:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717298323;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717298323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:19:18", "2024-06-02 03:19:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089491", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:20:18", "2024-06-02 03:20:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717298418;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717298418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:29:57", "2024-06-02 03:29:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089492", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:30:57", "2024-06-02 03:30:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717299057;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717299057;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:33:42", "2024-06-02 03:33:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089493", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:34:42", "2024-06-02 03:34:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717299282;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717299282;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:46:35", "2024-06-02 03:46:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089494", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:47:35", "2024-06-02 03:47:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717300055;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717300055;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:49:09", "2024-06-02 03:49:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089495", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:50:09", "2024-06-02 03:50:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717300209;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717300209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:50:28", "2024-06-02 03:50:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089496", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 03:51:28", "2024-06-02 03:51:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717300288;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717300288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 03:59:28", "2024-06-02 03:59:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089497", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:00:28", "2024-06-02 04:00:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717300828;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717300828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:05:47", "2024-06-02 04:05:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089498", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:06:47", "2024-06-02 04:06:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717301207;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717301207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:09:26", "2024-06-02 04:09:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089499", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:10:26", "2024-06-02 04:10:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717301426;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717301426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:15:06", "2024-06-02 04:15:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089500", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:16:06", "2024-06-02 04:16:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717301766;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717301766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:18:46", "2024-06-02 04:18:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089501", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:19:46", "2024-06-02 04:19:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717301986;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717301986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:21:54", "2024-06-02 04:21:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089502", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:22:54", "2024-06-02 04:22:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717302174;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717302174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:29:32", "2024-06-02 04:29:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089503", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:30:32", "2024-06-02 04:30:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717302632;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717302632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:34:49", "2024-06-02 04:34:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089504", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:35:49", "2024-06-02 04:35:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717302949;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717302949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:37:57", "2024-06-02 04:37:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089505", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:38:57", "2024-06-02 04:38:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717303137;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717303137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:40:02", "2024-06-02 04:40:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089506", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:41:02", "2024-06-02 04:41:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717303262;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717303262;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:50:07", "2024-06-02 04:50:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089507", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:51:07", "2024-06-02 04:51:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717303867;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717303867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 04:54:07", "2024-06-02 04:54:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089508", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 04:55:07", "2024-06-02 04:55:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717304107;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717304107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:00:41", "2024-06-02 05:00:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089509", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:01:41", "2024-06-02 05:01:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717304501;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717304501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:07:20", "2024-06-02 05:07:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089510", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:08:20", "2024-06-02 05:08:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717304900;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717304900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:10:22", "2024-06-02 05:10:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089511", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:11:22", "2024-06-02 05:11:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717305082;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717305082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:21:55", "2024-06-02 05:21:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089512", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:22:55", "2024-06-02 05:22:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717305775;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717305775;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:26:39", "2024-06-02 05:26:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089513", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:27:39", "2024-06-02 05:27:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717306059;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717306059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:30:18", "2024-06-02 05:30:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089514", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:31:18", "2024-06-02 05:31:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717306278;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717306278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:38:37", "2024-06-02 05:38:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089515", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:39:37", "2024-06-02 05:39:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717306777;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717306777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:42:44", "2024-06-02 05:42:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089516", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:43:44", "2024-06-02 05:43:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717307024;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717307024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:45:35", "2024-06-02 05:45:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089517", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:46:35", "2024-06-02 05:46:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717307195;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717307195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:53:11", "2024-06-02 05:53:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089518", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:54:11", "2024-06-02 05:54:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717307651;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717307651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 05:58:47", "2024-06-02 05:58:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089519", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 05:59:47", "2024-06-02 05:59:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717307987;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717307987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:01:40", "2024-06-02 06:01:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089520", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:02:40", "2024-06-02 06:02:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717308160;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717308160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:09:34", "2024-06-02 06:09:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089521", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:10:34", "2024-06-02 06:10:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717308634;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717308634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:11:43", "2024-06-02 06:11:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089522", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:12:43", "2024-06-02 06:12:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717308763;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717308763;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:14:57", "2024-06-02 06:14:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089523", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:15:57", "2024-06-02 06:15:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717308957;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717308957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:25:19", "2024-06-02 06:25:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089524", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:26:19", "2024-06-02 06:26:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717309579;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717309579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:27:54", "2024-06-02 06:27:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089525", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:28:54", "2024-06-02 06:28:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717309734;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717309734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:31:51", "2024-06-02 06:31:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089526", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:32:51", "2024-06-02 06:32:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717309971;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717309971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:32:55", "2024-06-02 06:32:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089527", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:33:55", "2024-06-02 06:33:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717310035;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717310035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:47:30", "2024-06-02 06:47:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089528", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:48:30", "2024-06-02 06:48:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717310910;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717310910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 06:54:34", "2024-06-02 06:54:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089529", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 06:55:34", "2024-06-02 06:55:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717311334;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717311334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:01:32", "2024-06-02 07:01:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089530", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:02:32", "2024-06-02 07:02:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717311752;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717311752;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:08:31", "2024-06-02 07:08:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089531", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:09:31", "2024-06-02 07:09:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717312171;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717312171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:15:18", "2024-06-02 07:15:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089532", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:16:18", "2024-06-02 07:16:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717312578;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717312578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:22:10", "2024-06-02 07:22:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089533", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:23:10", "2024-06-02 07:23:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717312990;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717312990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:35:21", "2024-06-02 07:35:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089534", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:36:21", "2024-06-02 07:36:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717313781;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717313781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:41:30", "2024-06-02 07:41:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089535", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:42:30", "2024-06-02 07:42:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717314150;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717314150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:48:06", "2024-06-02 07:48:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089536", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:49:06", "2024-06-02 07:49:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717314546;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717314546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 07:54:24", "2024-06-02 07:54:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089537", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 07:55:24", "2024-06-02 07:55:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717314924;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717314924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:01:03", "2024-06-02 08:01:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089538", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:02:03", "2024-06-02 08:02:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717315323;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717315323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:06:59", "2024-06-02 08:06:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089539", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:07:59", "2024-06-02 08:07:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717315679;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717315679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:13:23", "2024-06-02 08:13:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089540", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:14:23", "2024-06-02 08:14:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717316063;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717316063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:19:21", "2024-06-02 08:19:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089541", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:20:21", "2024-06-02 08:20:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717316421;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717316421;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:25:16", "2024-06-02 08:25:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089542", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:26:16", "2024-06-02 08:26:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717316776;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717316776;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:29:52", "2024-06-02 08:29:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089543", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:30:52", "2024-06-02 08:30:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717317052;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717317052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:33:39", "2024-06-02 08:33:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089544", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:34:39", "2024-06-02 08:34:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717317279;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717317279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:36:53", "2024-06-02 08:36:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089545", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:37:53", "2024-06-02 08:37:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717317473;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717317473;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:41:10", "2024-06-02 08:41:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089546", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:42:10", "2024-06-02 08:42:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717317730;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717317730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:49:42", "2024-06-02 08:49:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089547", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:50:42", "2024-06-02 08:50:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717318242;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717318242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:52:17", "2024-06-02 08:52:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089548", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:53:17", "2024-06-02 08:53:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717318397;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717318397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 08:53:35", "2024-06-02 08:53:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089549", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 08:54:35", "2024-06-02 08:54:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717318475;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717318475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:04:06", "2024-06-02 09:04:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089550", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:05:06", "2024-06-02 09:05:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717319106;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717319106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:05:42", "2024-06-02 09:05:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089551", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:06:42", "2024-06-02 09:06:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717319202;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717319202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:08:52", "2024-06-02 09:08:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089552", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:09:52", "2024-06-02 09:09:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717319392;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717319392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:16:32", "2024-06-02 09:16:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089553", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:17:32", "2024-06-02 09:17:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717319852;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717319852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:21:54", "2024-06-02 09:21:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089554", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:22:54", "2024-06-02 09:22:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717320174;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717320174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:23:41", "2024-06-02 09:23:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089555", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:24:41", "2024-06-02 09:24:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717320281;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717320281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:25:03", "2024-06-02 09:25:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089556", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:26:03", "2024-06-02 09:26:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717320363;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717320363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:28:43", "2024-06-02 09:28:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089557", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:29:43", "2024-06-02 09:29:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717320583;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717320583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:37:49", "2024-06-02 09:37:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089558", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:38:49", "2024-06-02 09:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717321129;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717321129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:41:00", "2024-06-02 09:41:00", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089559", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:42:00", "2024-06-02 09:42:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717321320;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717321320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:53:23", "2024-06-02 09:53:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089560", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:54:23", "2024-06-02 09:54:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717322063;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717322063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 09:56:52", "2024-06-02 09:56:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089561", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 09:57:52", "2024-06-02 09:57:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717322272;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717322272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:05:04", "2024-06-02 10:05:04", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089562", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:06:04", "2024-06-02 10:06:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717322764;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717322764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:09:35", "2024-06-02 10:09:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089563", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:10:35", "2024-06-02 10:10:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717323035;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717323035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:12:39", "2024-06-02 10:12:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089564", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:13:39", "2024-06-02 10:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717323219;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717323219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:25:24", "2024-06-02 10:25:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089565", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:26:24", "2024-06-02 10:26:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717323984;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717323984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:28:27", "2024-06-02 10:28:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089566", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:29:27", "2024-06-02 10:29:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717324167;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717324167;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:42:29", "2024-06-02 10:42:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089567", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:43:29", "2024-06-02 10:43:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717325009;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717325009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:43:56", "2024-06-02 10:43:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089568", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:44:56", "2024-06-02 10:44:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717325096;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717325096;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:54:13", "2024-06-02 10:54:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089569", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:55:13", "2024-06-02 10:55:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717325713;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717325713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 10:55:46", "2024-06-02 10:55:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089570", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 10:56:46", "2024-06-02 10:56:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717325806;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717325806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 11:08:31", "2024-06-02 11:08:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089571", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 11:09:31", "2024-06-02 11:09:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717326571;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717326571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 11:11:53", "2024-06-02 11:11:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089572", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 11:12:53", "2024-06-02 11:12:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717326773;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717326773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 11:16:09", "2024-06-02 11:16:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089573", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 11:17:09", "2024-06-02 11:17:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717327029;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717327029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 11:20:52", "2024-06-02 11:20:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089574", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 11:21:53", "2024-06-02 11:21:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717327313;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717327313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 11:27:22", "2024-06-02 11:27:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089575", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 11:28:22", "2024-06-02 11:28:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717327702;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717327702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 11:33:56", "2024-06-02 11:33:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089576", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 11:34:56", "2024-06-02 11:34:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717328096;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717328096;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 11:46:54", "2024-06-02 11:46:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089577", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 11:47:54", "2024-06-02 11:47:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717328874;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717328874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 12:00:51", "2024-06-02 12:00:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089578", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 12:01:51", "2024-06-02 12:01:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717329711;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717329711;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 12:12:54", "2024-06-02 12:12:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089579", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 12:13:54", "2024-06-02 12:13:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717330434;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717330434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 12:26:22", "2024-06-02 12:26:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089580", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 12:27:22", "2024-06-02 12:27:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717331242;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717331242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 12:29:58", "2024-06-02 12:29:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089581", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 12:30:58", "2024-06-02 12:30:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717331458;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717331458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 12:40:03", "2024-06-02 12:40:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089582", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 12:41:03", "2024-06-02 12:41:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717332063;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717332063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 12:51:35", "2024-06-02 12:51:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089583", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 12:52:35", "2024-06-02 12:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717332755;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717332755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:05:06", "2024-06-02 13:05:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089584", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:06:06", "2024-06-02 13:06:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717333566;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717333566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:16:15", "2024-06-02 13:16:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089585", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:17:15", "2024-06-02 13:17:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717334235;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717334235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:29:53", "2024-06-02 13:29:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089586", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:30:53", "2024-06-02 13:30:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717335053;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717335053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:33:34", "2024-06-02 13:33:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089587", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:34:34", "2024-06-02 13:34:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717335274;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717335274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:41:50", "2024-06-02 13:41:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089588", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:42:50", "2024-06-02 13:42:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717335770;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717335770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:45:46", "2024-06-02 13:45:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089589", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:46:46", "2024-06-02 13:46:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717336006;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717336006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:48:43", "2024-06-02 13:48:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089590", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:49:43", "2024-06-02 13:49:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717336183;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717336183;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 13:50:05", "2024-06-02 13:50:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089591", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 13:51:05", "2024-06-02 13:51:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717336265;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717336265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:02:28", "2024-06-02 14:02:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089592", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:03:28", "2024-06-02 14:03:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717337008;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717337008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:05:50", "2024-06-02 14:05:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089593", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:06:50", "2024-06-02 14:06:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717337210;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717337210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:06:51", "2024-06-02 14:06:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089594", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:07:51", "2024-06-02 14:07:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717337271;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717337271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:19:14", "2024-06-02 14:19:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089595", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:20:14", "2024-06-02 14:20:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717338014;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717338014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:21:55", "2024-06-02 14:21:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089596", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:22:55", "2024-06-02 14:22:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717338175;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717338175;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:23:34", "2024-06-02 14:23:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089597", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:24:34", "2024-06-02 14:24:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717338274;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717338274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:26:37", "2024-06-02 14:26:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089598", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:27:37", "2024-06-02 14:27:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717338457;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717338457;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:35:55", "2024-06-02 14:35:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089599", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:36:56", "2024-06-02 14:36:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717339016;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717339016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:39:17", "2024-06-02 14:39:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089600", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:40:17", "2024-06-02 14:40:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717339217;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717339217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:40:19", "2024-06-02 14:40:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089601", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:41:19", "2024-06-02 14:41:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717339279;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717339279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:52:43", "2024-06-02 14:52:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089602", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:53:44", "2024-06-02 14:53:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717340024;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717340024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 14:56:08", "2024-06-02 14:56:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089603", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 14:57:08", "2024-06-02 14:57:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717340228;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717340228;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:09:24", "2024-06-02 15:09:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089604", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:10:24", "2024-06-02 15:10:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717341024;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717341024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:12:48", "2024-06-02 15:12:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089605", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:13:48", "2024-06-02 15:13:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717341228;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717341228;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:13:52", "2024-06-02 15:13:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089606", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:14:52", "2024-06-02 15:14:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717341292;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717341292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:26:07", "2024-06-02 15:26:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089607", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:27:07", "2024-06-02 15:27:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717342027;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717342027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:29:27", "2024-06-02 15:29:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089608", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:30:27", "2024-06-02 15:30:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717342227;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717342227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:42:47", "2024-06-02 15:42:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089609", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:43:47", "2024-06-02 15:43:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717343027;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717343027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:46:08", "2024-06-02 15:46:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089610", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:47:08", "2024-06-02 15:47:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717343228;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717343228;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:47:10", "2024-06-02 15:47:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089611", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:48:10", "2024-06-02 15:48:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717343290;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717343290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:56:45", "2024-06-02 15:56:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089612", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 15:57:45", "2024-06-02 15:57:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717343865;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717343865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 15:59:20", "2024-06-02 15:59:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089613", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:00:20", "2024-06-02 16:00:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717344020;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717344020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:02:40", "2024-06-02 16:02:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089614", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:03:40", "2024-06-02 16:03:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717344220;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717344220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:15:57", "2024-06-02 16:15:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089615", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:16:57", "2024-06-02 16:16:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717345017;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717345017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:20:17", "2024-06-02 16:20:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089616", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:21:18", "2024-06-02 16:21:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717345278;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717345278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:32:19", "2024-06-02 16:32:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089617", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:33:19", "2024-06-02 16:33:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717345999;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717345999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:35:36", "2024-06-02 16:35:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089618", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:36:36", "2024-06-02 16:36:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717346196;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717346196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:36:37", "2024-06-02 16:36:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089619", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:37:37", "2024-06-02 16:37:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717346257;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717346257;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:48:28", "2024-06-02 16:48:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089620", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:49:28", "2024-06-02 16:49:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717346968;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717346968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 16:51:39", "2024-06-02 16:51:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089621", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 16:52:39", "2024-06-02 16:52:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717347159;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717347159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:04:18", "2024-06-02 17:04:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089622", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:05:18", "2024-06-02 17:05:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717347918;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717347918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:07:27", "2024-06-02 17:07:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089623", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:08:27", "2024-06-02 17:08:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717348107;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717348107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:20:15", "2024-06-02 17:20:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089624", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:21:15", "2024-06-02 17:21:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717348875;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717348875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:23:30", "2024-06-02 17:23:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089625", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:24:30", "2024-06-02 17:24:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717349070;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717349070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:36:25", "2024-06-02 17:36:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089626", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:37:25", "2024-06-02 17:37:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717349845;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717349845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:39:44", "2024-06-02 17:39:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089627", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:40:44", "2024-06-02 17:40:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717350044;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717350044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:55:42", "2024-06-02 17:55:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089628", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:56:42", "2024-06-02 17:56:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717351002;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717351002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 17:56:42", "2024-06-02 17:56:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089629", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 17:57:42", "2024-06-02 17:57:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717351062;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717351062;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:08:31", "2024-06-02 18:08:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089630", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:09:31", "2024-06-02 18:09:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717351771;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717351771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:11:42", "2024-06-02 18:11:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089631", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:12:42", "2024-06-02 18:12:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717351962;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717351962;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:12:42", "2024-06-02 18:12:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089632", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:13:42", "2024-06-02 18:13:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717352022;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717352022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:24:39", "2024-06-02 18:24:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089633", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:25:39", "2024-06-02 18:25:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717352739;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717352739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:27:53", "2024-06-02 18:27:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089634", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:28:53", "2024-06-02 18:28:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717352933;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717352933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:40:43", "2024-06-02 18:40:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089635", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:41:43", "2024-06-02 18:41:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717353703;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717353703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:43:49", "2024-06-02 18:43:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089636", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:44:49", "2024-06-02 18:44:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717353889;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717353889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:44:49", "2024-06-02 18:44:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089637", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:45:49", "2024-06-02 18:45:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717353949;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717353949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:56:31", "2024-06-02 18:56:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089638", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 18:57:31", "2024-06-02 18:57:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717354651;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717354651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 18:59:39", "2024-06-02 18:59:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089639", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:00:39", "2024-06-02 19:00:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717354839;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717354839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 19:00:39", "2024-06-02 19:00:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089640", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:01:39", "2024-06-02 19:01:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717354899;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717354899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 19:12:22", "2024-06-02 19:12:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089641", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:13:22", "2024-06-02 19:13:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717355602;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717355602;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 19:15:33", "2024-06-02 19:15:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089642", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:16:33", "2024-06-02 19:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717355793;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717355793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 19:28:14", "2024-06-02 19:28:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089643", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:29:14", "2024-06-02 19:29:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717356554;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717356554;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 19:32:25", "2024-06-02 19:32:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089644", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:33:25", "2024-06-02 19:33:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717356805;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717356805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 19:44:11", "2024-06-02 19:44:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089645", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:45:11", "2024-06-02 19:45:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717357511;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717357511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 19:47:23", "2024-06-02 19:47:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089646", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 19:48:23", "2024-06-02 19:48:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717357703;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717357703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 20:00:06", "2024-06-02 20:00:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089647", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 20:01:06", "2024-06-02 20:01:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717358466;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717358466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 20:03:17", "2024-06-02 20:03:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089648", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 20:04:17", "2024-06-02 20:04:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717358657;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717358657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 20:19:11", "2024-06-02 20:19:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089649", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 20:20:11", "2024-06-02 20:20:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717359611;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717359611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 20:31:44", "2024-06-02 20:31:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089650", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 20:32:44", "2024-06-02 20:32:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717360364;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717360364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 20:34:55", "2024-06-02 20:34:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089651", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 20:35:55", "2024-06-02 20:35:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717360555;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717360555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 20:47:36", "2024-06-02 20:47:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089652", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 20:48:36", "2024-06-02 20:48:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717361316;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717361316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 20:50:45", "2024-06-02 20:50:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089653", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 20:51:45", "2024-06-02 20:51:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717361505;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717361505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:03:25", "2024-06-02 21:03:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089654", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:04:25", "2024-06-02 21:04:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717362265;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717362265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:06:35", "2024-06-02 21:06:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089655", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:07:35", "2024-06-02 21:07:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717362455;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717362455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:07:36", "2024-06-02 21:07:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089656", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:08:36", "2024-06-02 21:08:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717362516;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717362516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:12:55", "2024-06-02 21:12:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089657", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:13:55", "2024-06-02 21:13:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717362835;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717362835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:19:11", "2024-06-02 21:19:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089658", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:20:11", "2024-06-02 21:20:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717363211;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717363211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:22:22", "2024-06-02 21:22:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089659", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:23:22", "2024-06-02 21:23:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717363402;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717363402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:34:48", "2024-06-02 21:34:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089660", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:35:48", "2024-06-02 21:35:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717364148;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717364148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:37:58", "2024-06-02 21:37:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089661", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:38:58", "2024-06-02 21:38:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717364338;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717364338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:41:36", "2024-06-02 21:41:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089662", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:42:36", "2024-06-02 21:42:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717364556;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717364556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:50:25", "2024-06-02 21:50:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089663", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:51:25", "2024-06-02 21:51:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717365085;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717365085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 21:53:33", "2024-06-02 21:53:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089664", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 21:54:33", "2024-06-02 21:54:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717365273;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717365273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:06:27", "2024-06-02 22:06:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089665", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:07:27", "2024-06-02 22:07:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717366047;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717366047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:09:38", "2024-06-02 22:09:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089666", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:10:38", "2024-06-02 22:10:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717366238;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717366238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:10:45", "2024-06-02 22:10:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089667", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:11:45", "2024-06-02 22:11:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717366305;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717366305;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:22:38", "2024-06-02 22:22:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089668", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:23:38", "2024-06-02 22:23:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717367018;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717367018;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:26:51", "2024-06-02 22:26:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089669", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:27:51", "2024-06-02 22:27:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717367271;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717367271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:38:47", "2024-06-02 22:38:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089670", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:39:47", "2024-06-02 22:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717367987;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717367987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:42:01", "2024-06-02 22:42:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089671", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:43:01", "2024-06-02 22:43:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717368181;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717368181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:54:57", "2024-06-02 22:54:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089672", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:55:57", "2024-06-02 22:55:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717368957;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717368957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:58:10", "2024-06-02 22:58:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089673", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 22:59:10", "2024-06-02 22:59:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717369150;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717369150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 22:59:11", "2024-06-02 22:59:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089674", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:00:11", "2024-06-02 23:00:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717369211;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717369211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:06:57", "2024-06-02 23:06:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089675", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:07:57", "2024-06-02 23:07:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717369677;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717369677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:11:11", "2024-06-02 23:11:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089676", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:12:11", "2024-06-02 23:12:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717369931;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717369931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:14:26", "2024-06-02 23:14:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089677", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:15:26", "2024-06-02 23:15:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717370126;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717370126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:15:28", "2024-06-02 23:15:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089678", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:16:28", "2024-06-02 23:16:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717370188;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717370188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:27:26", "2024-06-02 23:27:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089679", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:28:26", "2024-06-02 23:28:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717370906;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717370906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:30:41", "2024-06-02 23:30:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089680", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:31:41", "2024-06-02 23:31:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717371101;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717371101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:31:42", "2024-06-02 23:31:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089681", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:32:42", "2024-06-02 23:32:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717371162;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717371162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:43:42", "2024-06-02 23:43:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089682", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:44:42", "2024-06-02 23:44:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717371882;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717371882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:47:56", "2024-06-02 23:47:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089683", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-02 23:48:56", "2024-06-02 23:48:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717372136;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717372136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-02 23:59:54", "2024-06-02 23:59:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089684", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:00:54", "2024-06-03 00:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717372854;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717372854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:03:11", "2024-06-03 00:03:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089685", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:04:11", "2024-06-03 00:04:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717373051;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717373051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:04:14", "2024-06-03 00:04:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089686", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:05:14", "2024-06-03 00:05:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717373114;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717373114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:16:21", "2024-06-03 00:16:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089687", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:17:21", "2024-06-03 00:17:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717373841;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717373841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:19:39", "2024-06-03 00:19:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089688", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:20:39", "2024-06-03 00:20:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717374039;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717374039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:20:39", "2024-06-03 00:20:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089689", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:21:39", "2024-06-03 00:21:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717374099;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717374099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:32:45", "2024-06-03 00:32:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089690", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:33:45", "2024-06-03 00:33:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717374825;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717374825;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:36:01", "2024-06-03 00:36:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089691", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:37:01", "2024-06-03 00:37:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717375021;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717375021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:37:02", "2024-06-03 00:37:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089692", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:38:02", "2024-06-03 00:38:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717375082;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717375082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:49:09", "2024-06-03 00:49:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089693", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:50:09", "2024-06-03 00:50:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717375809;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717375809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 00:52:31", "2024-06-03 00:52:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089694", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 00:53:31", "2024-06-03 00:53:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717376011;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717376011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:05:34", "2024-06-03 01:05:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089695", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:06:34", "2024-06-03 01:06:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717376794;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717376794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:08:52", "2024-06-03 01:08:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089696", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:09:52", "2024-06-03 01:09:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717376992;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717376992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:09:53", "2024-06-03 01:09:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089697", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:10:53", "2024-06-03 01:10:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717377053;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717377053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:21:45", "2024-06-03 01:21:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089698", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:22:45", "2024-06-03 01:22:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717377765;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717377765;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:24:54", "2024-06-03 01:24:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089699", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:25:54", "2024-06-03 01:25:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717377954;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717377954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:37:28", "2024-06-03 01:37:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089700", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:38:28", "2024-06-03 01:38:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717378708;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717378708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:40:41", "2024-06-03 01:40:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089701", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:41:41", "2024-06-03 01:41:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717378901;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717378901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:53:33", "2024-06-03 01:53:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089702", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:54:33", "2024-06-03 01:54:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717379673;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717379673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:56:50", "2024-06-03 01:56:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089703", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:57:50", "2024-06-03 01:57:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717379870;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717379870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 01:57:53", "2024-06-03 01:57:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089704", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 01:58:53", "2024-06-03 01:58:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717379933;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717379933;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:09:59", "2024-06-03 02:09:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089705", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:10:59", "2024-06-03 02:10:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717380659;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717380659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:13:22", "2024-06-03 02:13:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089706", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:14:22", "2024-06-03 02:14:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717380862;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717380862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:14:24", "2024-06-03 02:14:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089707", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:15:24", "2024-06-03 02:15:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717380924;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717380924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:24:11", "2024-06-03 02:24:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089708", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:25:11", "2024-06-03 02:25:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717381511;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717381511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:26:32", "2024-06-03 02:26:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089709", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:27:32", "2024-06-03 02:27:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717381652;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717381652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:29:47", "2024-06-03 02:29:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089710", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:30:47", "2024-06-03 02:30:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717381847;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717381847;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:30:48", "2024-06-03 02:30:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089711", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:31:48", "2024-06-03 02:31:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717381908;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717381908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:42:51", "2024-06-03 02:42:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089712", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:43:51", "2024-06-03 02:43:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717382631;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717382631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:46:09", "2024-06-03 02:46:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089713", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:47:09", "2024-06-03 02:47:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717382829;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717382829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:47:11", "2024-06-03 02:47:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089714", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 02:48:11", "2024-06-03 02:48:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717382891;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717382891;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 02:59:20", "2024-06-03 02:59:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089715", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:00:20", "2024-06-03 03:00:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717383620;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717383620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:02:40", "2024-06-03 03:02:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089716", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:03:40", "2024-06-03 03:03:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717383820;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717383820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:03:41", "2024-06-03 03:03:41", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089717", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:04:41", "2024-06-03 03:04:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717383881;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717383881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:16:01", "2024-06-03 03:16:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089718", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:17:01", "2024-06-03 03:17:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717384621;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717384621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:19:20", "2024-06-03 03:19:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089719", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:20:20", "2024-06-03 03:20:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717384820;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717384820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:20:22", "2024-06-03 03:20:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089720", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:21:22", "2024-06-03 03:21:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717384882;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717384882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:32:47", "2024-06-03 03:32:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089721", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:33:47", "2024-06-03 03:33:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717385627;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717385627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:36:38", "2024-06-03 03:36:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089722", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:37:38", "2024-06-03 03:37:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717385858;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717385858;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:38:03", "2024-06-03 03:38:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089723", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:39:03", "2024-06-03 03:39:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717385943;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717385943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:45:33", "2024-06-03 03:45:33", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089724", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:46:33", "2024-06-03 03:46:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717386393;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717386393;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:48:38", "2024-06-03 03:48:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089725", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:49:38", "2024-06-03 03:49:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717386578;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717386578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:51:53", "2024-06-03 03:51:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089726", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:52:53", "2024-06-03 03:52:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717386773;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717386773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:52:58", "2024-06-03 03:52:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089727", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:53:58", "2024-06-03 03:53:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717386838;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717386838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 03:54:08", "2024-06-03 03:54:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089728", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 03:55:08", "2024-06-03 03:55:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717386908;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717386908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:02:24", "2024-06-03 04:02:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089729", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:03:24", "2024-06-03 04:03:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717387404;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717387404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:05:06", "2024-06-03 04:05:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089730", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:06:06", "2024-06-03 04:06:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717387566;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717387566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:08:24", "2024-06-03 04:08:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089731", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:09:24", "2024-06-03 04:09:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717387764;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717387764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:12:37", "2024-06-03 04:12:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089732", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:13:37", "2024-06-03 04:13:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717388017;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717388017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:21:38", "2024-06-03 04:21:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089733", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:22:38", "2024-06-03 04:22:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717388558;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717388558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:22:38", "2024-06-03 04:22:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089734", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:23:38", "2024-06-03 04:23:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717388618;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717388618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:24:58", "2024-06-03 04:24:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089735", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:25:58", "2024-06-03 04:25:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717388758;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717388758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:25:59", "2024-06-03 04:25:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089736", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:26:59", "2024-06-03 04:26:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717388819;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717388819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:38:18", "2024-06-03 04:38:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089737", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:39:18", "2024-06-03 04:39:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717389558;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717389558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:41:38", "2024-06-03 04:41:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089738", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:42:38", "2024-06-03 04:42:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717389758;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717389758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:54:52", "2024-06-03 04:54:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089739", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 04:55:52", "2024-06-03 04:55:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717390552;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717390552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 04:59:12", "2024-06-03 04:59:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089740", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:00:12", "2024-06-03 05:00:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717390812;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717390812;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:03:07", "2024-06-03 05:03:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089741", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:04:07", "2024-06-03 05:04:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717391047;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717391047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:11:29", "2024-06-03 05:11:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089742", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:12:29", "2024-06-03 05:12:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717391549;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717391549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:12:50", "2024-06-03 05:12:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089743", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:13:50", "2024-06-03 05:13:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717391630;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717391630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:14:47", "2024-06-03 05:14:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089744", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:15:47", "2024-06-03 05:15:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717391747;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717391747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:15:47", "2024-06-03 05:15:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089745", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:16:47", "2024-06-03 05:16:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717391807;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717391807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:23:28", "2024-06-03 05:23:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089746", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:24:28", "2024-06-03 05:24:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717392268;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717392268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:27:50", "2024-06-03 05:27:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089747", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:28:50", "2024-06-03 05:28:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717392530;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717392530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:31:12", "2024-06-03 05:31:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089748", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:32:12", "2024-06-03 05:32:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717392732;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717392732;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:32:13", "2024-06-03 05:32:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089749", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:33:13", "2024-06-03 05:33:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717392793;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717392793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:34:17", "2024-06-03 05:34:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089750", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:35:17", "2024-06-03 05:35:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717392917;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717392917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:44:27", "2024-06-03 05:44:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089751", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:45:27", "2024-06-03 05:45:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717393527;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717393527;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:47:46", "2024-06-03 05:47:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089752", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:48:46", "2024-06-03 05:48:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717393726;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717393726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:48:47", "2024-06-03 05:48:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089753", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:49:47", "2024-06-03 05:49:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717393787;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717393787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 05:54:34", "2024-06-03 05:54:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089754", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 05:55:34", "2024-06-03 05:55:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717394134;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717394134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:01:02", "2024-06-03 06:01:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089755", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:02:02", "2024-06-03 06:02:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717394522;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717394522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:04:25", "2024-06-03 06:04:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089756", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:05:25", "2024-06-03 06:05:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717394725;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717394725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:15:51", "2024-06-03 06:15:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089757", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:16:51", "2024-06-03 06:16:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717395411;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717395411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:17:50", "2024-06-03 06:17:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089758", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:18:50", "2024-06-03 06:18:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717395530;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717395530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:21:10", "2024-06-03 06:21:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089759", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:22:10", "2024-06-03 06:22:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717395730;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717395730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:26:15", "2024-06-03 06:26:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089760", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:27:15", "2024-06-03 06:27:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717396035;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717396035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:34:44", "2024-06-03 06:34:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089761", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:35:44", "2024-06-03 06:35:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717396544;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717396544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:36:44", "2024-06-03 06:36:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089762", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:37:44", "2024-06-03 06:37:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717396664;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717396664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:38:06", "2024-06-03 06:38:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089763", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:39:06", "2024-06-03 06:39:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717396746;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717396746;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:39:10", "2024-06-03 06:39:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089764", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:40:10", "2024-06-03 06:40:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717396810;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717396810;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:43:29", "2024-06-03 06:43:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089765", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:44:29", "2024-06-03 06:44:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717397069;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717397069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:47:11", "2024-06-03 06:47:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089766", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:48:11", "2024-06-03 06:48:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717397291;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717397291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:51:43", "2024-06-03 06:51:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089767", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:52:43", "2024-06-03 06:52:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717397563;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717397563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:55:10", "2024-06-03 06:55:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089768", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:56:10", "2024-06-03 06:56:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717397770;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717397770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:56:14", "2024-06-03 06:56:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089769", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:57:14", "2024-06-03 06:57:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717397834;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717397834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 06:57:15", "2024-06-03 06:57:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089770", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 06:58:15", "2024-06-03 06:58:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717397895;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717397895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:03:15", "2024-06-03 07:03:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089771", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:04:15", "2024-06-03 07:04:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398255;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398255;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:05:10", "2024-06-03 07:05:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089772", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:06:10", "2024-06-03 07:06:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398370;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:06:11", "2024-06-03 07:06:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089773", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:07:11", "2024-06-03 07:07:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398431;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:08:11", "2024-06-03 07:08:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089774", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:09:11", "2024-06-03 07:09:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398551;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:09:15", "2024-06-03 07:09:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089775", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:10:15", "2024-06-03 07:10:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398615;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:11:09", "2024-06-03 07:11:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089776", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:12:09", "2024-06-03 07:12:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398729;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:12:11", "2024-06-03 07:12:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089777", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:13:11", "2024-06-03 07:13:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398791;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:13:13", "2024-06-03 07:13:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089778", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:14:13", "2024-06-03 07:14:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398853;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:15:12", "2024-06-03 07:15:12", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089779", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:16:12", "2024-06-03 07:16:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717398972;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717398972;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:19:23", "2024-06-03 07:19:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089780", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:20:23", "2024-06-03 07:20:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717399223;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717399223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:25:34", "2024-06-03 07:25:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089781", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:26:34", "2024-06-03 07:26:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717399594;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717399594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:28:56", "2024-06-03 07:28:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089782", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:29:56", "2024-06-03 07:29:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717399796;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717399796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:42:36", "2024-06-03 07:42:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089783", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:43:36", "2024-06-03 07:43:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717400616;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717400616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:45:58", "2024-06-03 07:45:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089784", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:46:58", "2024-06-03 07:46:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717400818;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717400818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:47:04", "2024-06-03 07:47:04", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089785", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:48:04", "2024-06-03 07:48:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717400884;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717400884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:51:15", "2024-06-03 07:51:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089786", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 07:52:15", "2024-06-03 07:52:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717401135;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717401135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 07:59:55", "2024-06-03 07:59:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089787", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:00:55", "2024-06-03 08:00:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717401655;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717401655;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:02:37", "2024-06-03 08:02:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089788", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:03:37", "2024-06-03 08:03:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717401817;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717401817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:04:27", "2024-06-03 08:04:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089789", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:05:27", "2024-06-03 08:05:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717401927;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717401927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:12:51", "2024-06-03 08:12:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089790", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:13:51", "2024-06-03 08:13:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717402431;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717402431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:17:13", "2024-06-03 08:17:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089791", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:18:13", "2024-06-03 08:18:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717402693;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717402693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:20:47", "2024-06-03 08:20:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089792", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:21:47", "2024-06-03 08:21:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717402907;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717402907;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:21:51", "2024-06-03 08:21:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089793", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:22:51", "2024-06-03 08:22:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717402971;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717402971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:23:23", "2024-06-03 08:23:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089794", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:24:23", "2024-06-03 08:24:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717403063;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717403063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:34:37", "2024-06-03 08:34:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089795", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:35:37", "2024-06-03 08:35:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717403737;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717403737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:45:29", "2024-06-03 08:45:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089796", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:46:29", "2024-06-03 08:46:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717404389;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717404389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:51:47", "2024-06-03 08:51:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089797", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:52:47", "2024-06-03 08:52:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717404767;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717404767;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:55:27", "2024-06-03 08:55:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089798", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:56:27", "2024-06-03 08:56:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717404987;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717404987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 08:56:29", "2024-06-03 08:56:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089799", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 08:57:29", "2024-06-03 08:57:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717405049;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717405049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:06:29", "2024-06-03 09:06:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089800", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:07:29", "2024-06-03 09:07:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717405649;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717405649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:08:18", "2024-06-03 09:08:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089801", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:09:18", "2024-06-03 09:09:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717405758;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717405758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:12:19", "2024-06-03 09:12:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089802", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:13:19", "2024-06-03 09:13:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717405999;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717405999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:13:28", "2024-06-03 09:13:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089803", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:14:28", "2024-06-03 09:14:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717406068;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717406068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:19:26", "2024-06-03 09:19:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089804", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:20:26", "2024-06-03 09:20:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717406426;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717406426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:25:21", "2024-06-03 09:25:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089805", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:26:21", "2024-06-03 09:26:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717406781;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717406781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:30:53", "2024-06-03 09:30:53", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089806", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:31:53", "2024-06-03 09:31:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717407113;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717407113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:36:16", "2024-06-03 09:36:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089807", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:37:16", "2024-06-03 09:37:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717407436;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717407436;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:42:20", "2024-06-03 09:42:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089808", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:43:20", "2024-06-03 09:43:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717407800;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717407800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:43:57", "2024-06-03 09:43:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089809", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:44:57", "2024-06-03 09:44:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717407897;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717407897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:47:21", "2024-06-03 09:47:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089810", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:48:21", "2024-06-03 09:48:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717408101;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717408101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:48:23", "2024-06-03 09:48:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089811", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:49:23", "2024-06-03 09:49:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717408163;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717408163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 09:55:24", "2024-06-03 09:55:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089812", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 09:56:24", "2024-06-03 09:56:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717408584;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717408584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:00:43", "2024-06-03 10:00:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089813", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:01:43", "2024-06-03 10:01:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717408903;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717408903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:02:09", "2024-06-03 10:02:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089814", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:03:09", "2024-06-03 10:03:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717408989;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717408989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:05:08", "2024-06-03 10:05:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089815", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:06:08", "2024-06-03 10:06:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717409168;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717409168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:08:57", "2024-06-03 10:08:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089816", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:09:57", "2024-06-03 10:09:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717409397;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717409397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:15:58", "2024-06-03 10:15:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089817", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:16:58", "2024-06-03 10:16:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717409818;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717409818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:21:46", "2024-06-03 10:21:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089818", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:22:46", "2024-06-03 10:22:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717410166;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717410166;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:22:50", "2024-06-03 10:22:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089819", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:23:50", "2024-06-03 10:23:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717410230;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717410230;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:30:15", "2024-06-03 10:30:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089820", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:31:15", "2024-06-03 10:31:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717410675;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717410675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:35:47", "2024-06-03 10:35:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089821", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:36:47", "2024-06-03 10:36:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717411007;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717411007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:37:28", "2024-06-03 10:37:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089822", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:38:28", "2024-06-03 10:38:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717411108;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717411108;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:39:19", "2024-06-03 10:39:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089823", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:40:19", "2024-06-03 10:40:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717411219;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717411219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:40:23", "2024-06-03 10:40:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089824", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:41:23", "2024-06-03 10:41:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717411283;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717411283;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:45:26", "2024-06-03 10:45:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089825", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:46:26", "2024-06-03 10:46:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717411586;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717411586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:53:25", "2024-06-03 10:53:25", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089826", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:54:25", "2024-06-03 10:54:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717412065;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717412065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:57:07", "2024-06-03 10:57:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089827", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:58:07", "2024-06-03 10:58:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717412287;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717412287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 10:58:16", "2024-06-03 10:58:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089828", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 10:59:16", "2024-06-03 10:59:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717412356;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717412356;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:01:35", "2024-06-03 11:01:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089829", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:02:35", "2024-06-03 11:02:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717412555;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717412555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:08:44", "2024-06-03 11:08:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089830", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:09:44", "2024-06-03 11:09:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717412984;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717412984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:11:46", "2024-06-03 11:11:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089831", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:12:46", "2024-06-03 11:12:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717413166;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717413166;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:16:22", "2024-06-03 11:16:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089832", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:17:22", "2024-06-03 11:17:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717413442;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717413442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:25:57", "2024-06-03 11:25:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089833", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:26:57", "2024-06-03 11:26:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717414017;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717414017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:29:29", "2024-06-03 11:29:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089834", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:30:29", "2024-06-03 11:30:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717414229;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717414229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:33:07", "2024-06-03 11:33:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089835", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:34:07", "2024-06-03 11:34:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717414447;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717414447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:34:15", "2024-06-03 11:34:15", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089836", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:35:15", "2024-06-03 11:35:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717414515;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717414515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:43:26", "2024-06-03 11:43:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089837", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:44:26", "2024-06-03 11:44:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717415066;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717415066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:50:59", "2024-06-03 11:50:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089838", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:51:59", "2024-06-03 11:51:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717415519;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717415519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 11:51:59", "2024-06-03 11:51:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089839", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 11:52:59", "2024-06-03 11:52:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717415579;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717415579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:00:47", "2024-06-03 12:00:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089840", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:01:47", "2024-06-03 12:01:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717416107;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717416107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:09:59", "2024-06-03 12:09:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089841", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:10:59", "2024-06-03 12:10:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717416659;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717416659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:15:39", "2024-06-03 12:15:39", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089842", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:16:39", "2024-06-03 12:16:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717416999;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717416999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:23:14", "2024-06-03 12:23:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089843", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:24:14", "2024-06-03 12:24:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717417454;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717417454;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:27:06", "2024-06-03 12:27:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089844", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:28:06", "2024-06-03 12:28:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717417686;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717417686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:28:10", "2024-06-03 12:28:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089845", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:29:10", "2024-06-03 12:29:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717417750;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717417750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:31:32", "2024-06-03 12:31:32", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089846", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:32:32", "2024-06-03 12:32:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717417952;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717417952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:40:18", "2024-06-03 12:40:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089847", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:41:18", "2024-06-03 12:41:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717418478;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717418478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:41:26", "2024-06-03 12:41:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089848", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:42:26", "2024-06-03 12:42:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717418546;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717418546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:45:04", "2024-06-03 12:45:04", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089849", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:46:04", "2024-06-03 12:46:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717418764;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717418764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:46:09", "2024-06-03 12:46:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089850", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:47:09", "2024-06-03 12:47:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717418829;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717418829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:48:24", "2024-06-03 12:48:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089851", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:49:24", "2024-06-03 12:49:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717418964;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717418964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 12:52:30", "2024-06-03 12:52:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089852", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 12:53:30", "2024-06-03 12:53:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717419210;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717419210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 13:01:42", "2024-06-03 13:01:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089853", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 13:02:42", "2024-06-03 13:02:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717419762;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717419762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 13:05:22", "2024-06-03 13:05:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089854", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 13:06:22", "2024-06-03 13:06:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717419982;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717419982;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 13:06:28", "2024-06-03 13:06:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089855", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 13:07:28", "2024-06-03 13:07:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717420048;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717420048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 13:19:51", "2024-06-03 13:19:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089856", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 13:20:51", "2024-06-03 13:20:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717420851;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717420851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 13:23:29", "2024-06-03 13:23:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089857", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 13:24:29", "2024-06-03 13:24:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717421069;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717421069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 14:15:49", "2024-06-03 14:15:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089858", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 14:16:49", "2024-06-03 14:16:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717424209;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717424209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 14:25:54", "2024-06-03 14:25:54", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089859", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 14:26:54", "2024-06-03 14:26:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717424814;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717424814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 15:20:47", "2024-06-03 15:20:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089860", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 15:21:47", "2024-06-03 15:21:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717428107;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717428107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 15:27:24", "2024-06-03 15:27:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089861", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 15:28:24", "2024-06-03 15:28:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717428504;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717428504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 15:38:08", "2024-06-03 15:38:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089862", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 15:39:08", "2024-06-03 15:39:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717429148;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717429148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 15:44:34", "2024-06-03 15:44:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089863", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 15:45:34", "2024-06-03 15:45:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717429534;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717429534;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 15:55:14", "2024-06-03 15:55:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089864", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 15:56:14", "2024-06-03 15:56:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717430174;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717430174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 16:01:43", "2024-06-03 16:01:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089865", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 16:02:43", "2024-06-03 16:02:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717430563;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717430563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 16:12:31", "2024-06-03 16:12:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089866", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 16:13:31", "2024-06-03 16:13:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717431211;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717431211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 16:18:56", "2024-06-03 16:18:56", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089867", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 16:19:56", "2024-06-03 16:19:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717431596;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717431596;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 16:30:16", "2024-06-03 16:30:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089868", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 16:31:16", "2024-06-03 16:31:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717432276;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717432276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 16:36:38", "2024-06-03 16:36:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089869", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 16:37:38", "2024-06-03 16:37:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717432658;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717432658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 16:47:18", "2024-06-03 16:47:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089870", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 16:48:18", "2024-06-03 16:48:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717433298;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717433298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 16:53:44", "2024-06-03 16:53:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089871", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 16:54:44", "2024-06-03 16:54:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717433684;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717433684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:04:24", "2024-06-03 17:04:24", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089872", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:05:24", "2024-06-03 17:05:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717434324;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717434324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:10:46", "2024-06-03 17:10:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089873", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:11:46", "2024-06-03 17:11:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717434706;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717434706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:21:36", "2024-06-03 17:21:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089874", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:22:36", "2024-06-03 17:22:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717435356;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717435356;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:24:58", "2024-06-03 17:24:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089875", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:25:58", "2024-06-03 17:25:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717435558;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717435558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:27:49", "2024-06-03 17:27:49", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089876", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:28:49", "2024-06-03 17:28:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717435729;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717435729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:38:20", "2024-06-03 17:38:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089877", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:39:20", "2024-06-03 17:39:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717436360;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717436360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:44:42", "2024-06-03 17:44:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089878", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:45:42", "2024-06-03 17:45:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717436742;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717436742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 17:55:07", "2024-06-03 17:55:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089879", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 17:56:07", "2024-06-03 17:56:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717437367;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717437367;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 18:01:21", "2024-06-03 18:01:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089880", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 18:02:21", "2024-06-03 18:02:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717437741;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717437741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 18:11:46", "2024-06-03 18:11:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089881", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 18:12:46", "2024-06-03 18:12:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717438366;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717438366;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 18:18:02", "2024-06-03 18:18:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089882", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 18:19:02", "2024-06-03 18:19:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717438742;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717438742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 18:28:13", "2024-06-03 18:28:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089883", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 18:29:13", "2024-06-03 18:29:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717439353;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717439353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 18:44:45", "2024-06-03 18:44:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089884", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 18:45:45", "2024-06-03 18:45:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717440345;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717440345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 18:51:02", "2024-06-03 18:51:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089885", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 18:52:02", "2024-06-03 18:52:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717440722;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717440722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:01:18", "2024-06-03 19:01:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089886", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:02:18", "2024-06-03 19:02:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717441338;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717441338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:07:38", "2024-06-03 19:07:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089887", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:08:38", "2024-06-03 19:08:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717441718;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717441718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:18:05", "2024-06-03 19:18:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089888", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:19:05", "2024-06-03 19:19:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717442345;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717442345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:20:16", "2024-06-03 19:20:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089889", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:21:16", "2024-06-03 19:21:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717442476;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717442476;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:24:22", "2024-06-03 19:24:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089890", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:25:22", "2024-06-03 19:25:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717442722;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717442722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:34:46", "2024-06-03 19:34:46", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089891", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:35:46", "2024-06-03 19:35:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717443346;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717443346;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:41:03", "2024-06-03 19:41:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089892", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:42:03", "2024-06-03 19:42:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717443723;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717443723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:51:23", "2024-06-03 19:51:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089893", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:52:23", "2024-06-03 19:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717444343;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717444343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 19:57:37", "2024-06-03 19:57:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089894", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 19:58:37", "2024-06-03 19:58:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717444717;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717444717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:07:59", "2024-06-03 20:07:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089895", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:08:59", "2024-06-03 20:08:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717445339;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717445339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:14:11", "2024-06-03 20:14:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089896", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:15:11", "2024-06-03 20:15:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717445711;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717445711;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:23:14", "2024-06-03 20:23:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089897", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:24:14", "2024-06-03 20:24:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717446254;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717446254;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:24:26", "2024-06-03 20:24:26", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089898", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:25:26", "2024-06-03 20:25:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717446326;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717446326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:30:38", "2024-06-03 20:30:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089899", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:31:38", "2024-06-03 20:31:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717446698;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717446698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:40:55", "2024-06-03 20:40:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089900", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:41:55", "2024-06-03 20:41:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717447315;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717447315;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:47:08", "2024-06-03 20:47:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089901", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:48:08", "2024-06-03 20:48:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717447688;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717447688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 20:57:23", "2024-06-03 20:57:23", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089902", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 20:58:23", "2024-06-03 20:58:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717448303;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717448303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:03:37", "2024-06-03 21:03:37", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089903", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:04:37", "2024-06-03 21:04:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717448677;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717448677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:13:52", "2024-06-03 21:13:52", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089904", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:14:52", "2024-06-03 21:14:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717449292;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717449292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:18:03", "2024-06-03 21:18:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089905", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:19:03", "2024-06-03 21:19:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717449543;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717449543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:20:07", "2024-06-03 21:20:07", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089906", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:21:07", "2024-06-03 21:21:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717449667;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717449667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:23:43", "2024-06-03 21:23:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089907", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:24:43", "2024-06-03 21:24:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717449883;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717449883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:30:28", "2024-06-03 21:30:28", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089908", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:31:28", "2024-06-03 21:31:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717450288;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717450288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:36:42", "2024-06-03 21:36:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089909", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:37:42", "2024-06-03 21:37:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717450662;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717450662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:46:50", "2024-06-03 21:46:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089910", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:47:50", "2024-06-03 21:47:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717451270;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717451270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 21:52:58", "2024-06-03 21:52:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089911", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 21:53:58", "2024-06-03 21:53:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717451638;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717451638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:03:16", "2024-06-03 22:03:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089912", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:04:16", "2024-06-03 22:04:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717452256;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717452256;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:09:27", "2024-06-03 22:09:27", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089913", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:10:27", "2024-06-03 22:10:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717452627;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717452627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:19:44", "2024-06-03 22:19:44", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089914", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:20:44", "2024-06-03 22:20:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717453244;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717453244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:25:51", "2024-06-03 22:25:51", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089915", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:26:51", "2024-06-03 22:26:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717453611;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717453611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:35:57", "2024-06-03 22:35:57", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089916", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:36:57", "2024-06-03 22:36:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717454217;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717454217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:42:02", "2024-06-03 22:42:02", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089917", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:43:02", "2024-06-03 22:43:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717454582;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717454582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:52:10", "2024-06-03 22:52:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089918", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:53:10", "2024-06-03 22:53:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717455190;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717455190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 22:58:10", "2024-06-03 22:58:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089919", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 22:59:10", "2024-06-03 22:59:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717455550;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717455550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 23:08:21", "2024-06-03 23:08:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089920", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 23:09:21", "2024-06-03 23:09:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717456161;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717456161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 23:14:21", "2024-06-03 23:14:21", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089921", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 23:15:22", "2024-06-03 23:15:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717456522;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717456522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 23:24:20", "2024-06-03 23:24:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089922", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 23:25:20", "2024-06-03 23:25:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717457120;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717457120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 23:30:17", "2024-06-03 23:30:17", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089923", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 23:31:17", "2024-06-03 23:31:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717457477;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717457477;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 23:40:08", "2024-06-03 23:40:08", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089924", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 23:41:08", "2024-06-03 23:41:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717458068;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717458068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 23:46:03", "2024-06-03 23:46:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089925", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 23:47:03", "2024-06-03 23:47:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717458423;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717458423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-03 23:55:58", "2024-06-03 23:55:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089926", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-03 23:56:58", "2024-06-03 23:56:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717459018;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717459018;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 00:01:59", "2024-06-04 00:01:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089927", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 00:02:59", "2024-06-04 00:02:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717459379;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717459379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 00:18:10", "2024-06-04 00:18:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089928", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 00:19:10", "2024-06-04 00:19:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717460350;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717460350;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 00:27:58", "2024-06-04 00:27:58", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089929", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 00:28:58", "2024-06-04 00:28:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717460938;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717460938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 00:34:03", "2024-06-04 00:34:03", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089930", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 00:35:03", "2024-06-04 00:35:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717461303;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717461303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 00:44:01", "2024-06-04 00:44:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089931", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 00:45:01", "2024-06-04 00:45:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717461901;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717461901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 00:48:36", "2024-06-04 00:48:36", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089932", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 00:49:36", "2024-06-04 00:49:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717462176;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717462176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 00:50:06", "2024-06-04 00:50:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089933", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 00:51:06", "2024-06-04 00:51:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717462266;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717462266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:00:06", "2024-06-04 01:00:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089934", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:01:06", "2024-06-04 01:01:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717462866;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717462866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:06:14", "2024-06-04 01:06:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089935", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:07:14", "2024-06-04 01:07:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717463234;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717463234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:16:22", "2024-06-04 01:16:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089936", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:17:22", "2024-06-04 01:17:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717463842;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717463842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:22:22", "2024-06-04 01:22:22", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089937", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:23:22", "2024-06-04 01:23:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717464202;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717464202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:26:45", "2024-06-04 01:26:45", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089938", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:27:45", "2024-06-04 01:27:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717464465;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717464465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:28:11", "2024-06-04 01:28:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089939", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:29:11", "2024-06-04 01:29:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717464551;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717464551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:30:11", "2024-06-04 01:30:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089940", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:31:11", "2024-06-04 01:31:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717464671;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717464671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:31:11", "2024-06-04 01:31:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089941", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:32:11", "2024-06-04 01:32:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717464731;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717464731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:33:11", "2024-06-04 01:33:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089942", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:34:11", "2024-06-04 01:34:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717464851;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717464851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:35:09", "2024-06-04 01:35:09", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089943", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:36:09", "2024-06-04 01:36:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717464969;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717464969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:36:11", "2024-06-04 01:36:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089944", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:37:11", "2024-06-04 01:37:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717465031;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717465031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:38:31", "2024-06-04 01:38:31", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089945", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:39:31", "2024-06-04 01:39:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717465171;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717465171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:48:40", "2024-06-04 01:48:40", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089946", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:49:40", "2024-06-04 01:49:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717465780;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717465780;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 01:54:50", "2024-06-04 01:54:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089947", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 01:55:50", "2024-06-04 01:55:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717466150;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717466150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 02:05:05", "2024-06-04 02:05:05", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089948", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 02:06:05", "2024-06-04 02:06:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717466765;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717466765;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 02:11:13", "2024-06-04 02:11:13", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089949", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 02:12:13", "2024-06-04 02:12:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717467133;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717467133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 02:21:10", "2024-06-04 02:21:10", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089950", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 02:22:10", "2024-06-04 02:22:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717467730;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717467730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 02:27:06", "2024-06-04 02:27:06", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089951", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 02:28:06", "2024-06-04 02:28:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717468086;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717468086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 02:36:59", "2024-06-04 02:36:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089952", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 02:37:59", "2024-06-04 02:37:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717468679;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717468679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 02:43:01", "2024-06-04 02:43:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089953", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 02:44:01", "2024-06-04 02:44:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717469041;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717469041;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 03:02:20", "2024-06-04 03:02:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089954", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 03:03:20", "2024-06-04 03:03:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717470200;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717470200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 03:12:34", "2024-06-04 03:12:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089955", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 03:13:34", "2024-06-04 03:13:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717470814;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717470814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 03:18:34", "2024-06-04 03:18:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089956", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 03:19:34", "2024-06-04 03:19:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717471174;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717471174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 03:29:01", "2024-06-04 03:29:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089957", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 03:30:01", "2024-06-04 03:30:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717471801;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717471801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 03:30:42", "2024-06-04 03:30:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089958", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 03:31:42", "2024-06-04 03:31:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717471902;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717471902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 03:35:16", "2024-06-04 03:35:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089959", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 03:36:16", "2024-06-04 03:36:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717472176;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717472176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 03:51:43", "2024-06-04 03:51:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089960", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 03:52:43", "2024-06-04 03:52:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717473163;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717473163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:01:59", "2024-06-04 04:01:59", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089961", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:02:59", "2024-06-04 04:02:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717473779;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717473779;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:08:14", "2024-06-04 04:08:14", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089962", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:09:14", "2024-06-04 04:09:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717474154;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717474154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:18:35", "2024-06-04 04:18:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089963", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:19:35", "2024-06-04 04:19:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717474775;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717474775;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:24:47", "2024-06-04 04:24:47", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089964", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:25:47", "2024-06-04 04:25:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717475147;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717475147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:41:19", "2024-06-04 04:41:19", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089965", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:42:19", "2024-06-04 04:42:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717476139;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717476139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:49:43", "2024-06-04 04:49:43", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089966", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:50:43", "2024-06-04 04:50:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717476643;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717476643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:51:35", "2024-06-04 04:51:35", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089967", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:52:35", "2024-06-04 04:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717476755;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717476755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 04:57:50", "2024-06-04 04:57:50", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089968", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 04:58:50", "2024-06-04 04:58:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717477130;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717477130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 05:08:16", "2024-06-04 05:08:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089969", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 05:09:16", "2024-06-04 05:09:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717477756;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717477756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 05:14:38", "2024-06-04 05:14:38", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089970", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 05:15:38", "2024-06-04 05:15:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717478138;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717478138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 05:24:55", "2024-06-04 05:24:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089971", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 05:25:55", "2024-06-04 05:25:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717478755;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717478755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 05:31:20", "2024-06-04 05:31:20", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089972", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 05:32:20", "2024-06-04 05:32:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717479140;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717479140;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 05:41:34", "2024-06-04 05:41:34", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089973", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 05:42:34", "2024-06-04 05:42:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717479754;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717479754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 05:47:55", "2024-06-04 05:47:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089974", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 05:48:55", "2024-06-04 05:48:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717480135;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717480135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 05:58:11", "2024-06-04 05:58:11", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089975", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 05:59:11", "2024-06-04 05:59:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717480751;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717480751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 06:04:29", "2024-06-04 06:04:29", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089976", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 06:05:29", "2024-06-04 06:05:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717481129;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717481129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 06:14:48", "2024-06-04 06:14:48", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089977", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 06:15:48", "2024-06-04 06:15:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717481748;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717481748;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 06:21:01", "2024-06-04 06:21:01", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089978", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 06:22:01", "2024-06-04 06:22:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717482121;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717482121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 06:31:16", "2024-06-04 06:31:16", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089979", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 06:32:16", "2024-06-04 06:32:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717482736;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717482736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 06:37:30", "2024-06-04 06:37:30", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089980", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 06:38:30", "2024-06-04 06:38:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717483110;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717483110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 06:47:42", "2024-06-04 06:47:42", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089981", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 06:48:42", "2024-06-04 06:48:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717483722;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717483722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 06:53:55", "2024-06-04 06:53:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089982", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 06:54:55", "2024-06-04 06:54:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717484095;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717484095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 07:04:18", "2024-06-04 07:04:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089983", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 07:05:18", "2024-06-04 07:05:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717484718;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717484718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 07:05:55", "2024-06-04 07:05:55", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089984", "fluentcrm_scheduled_every_minute_tasks", "complete", "2024-06-04 07:06:55", "2024-06-04 07:06:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717484815;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717484815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-06-04 07:07:18", "2024-06-04 07:07:18", "0", NULL);
INSERT INTO `wp8s_actionscheduler_actions` VALUES("1089985", "fluentcrm_scheduled_every_minute_tasks", "pending", "2024-06-04 07:08:18", "2024-06-04 07:08:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717484898;s:18:\"\0*\0first_timestamp\";i:1716895630;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717484898;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp8s_actionscheduler_groups */
INSERT INTO `wp8s_actionscheduler_groups` VALUES("1", "fluent-crm");
INSERT INTO `wp8s_actionscheduler_groups` VALUES("2", "action-scheduler-migration");

/* INSERT TABLE DATA: wp8s_actionscheduler_logs */
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1", "1088703", "action created", "2024-05-28 11:27:10", "2024-05-28 11:27:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("2", "1088704", "action created", "2024-05-28 11:27:11", "2024-05-28 11:27:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("3", "1088703", "action started via Async Request", "2024-05-28 11:27:11", "2024-05-28 11:27:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("4", "1088703", "action complete via Async Request", "2024-05-28 11:27:11", "2024-05-28 11:27:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("5", "1088705", "action created", "2024-05-28 11:27:11", "2024-05-28 11:27:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("6", "1088704", "action started via Async Request", "2024-05-28 11:28:12", "2024-05-28 11:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("7", "1088704", "action complete via Async Request", "2024-05-28 11:28:12", "2024-05-28 11:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("8", "1088705", "action started via Async Request", "2024-05-28 11:28:12", "2024-05-28 11:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("9", "1088705", "action complete via Async Request", "2024-05-28 11:28:12", "2024-05-28 11:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("10", "1088706", "action created", "2024-05-28 11:28:12", "2024-05-28 11:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("11", "1088706", "action started via WP Cron", "2024-05-28 11:29:18", "2024-05-28 11:29:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("12", "1088706", "action complete via WP Cron", "2024-05-28 11:29:18", "2024-05-28 11:29:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("13", "1088707", "action created", "2024-05-28 11:29:18", "2024-05-28 11:29:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("14", "1088707", "action started via Async Request", "2024-05-28 11:30:57", "2024-05-28 11:30:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("15", "1088707", "action complete via Async Request", "2024-05-28 11:30:57", "2024-05-28 11:30:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("16", "1088708", "action created", "2024-05-28 11:30:57", "2024-05-28 11:30:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("17", "1088708", "action started via Async Request", "2024-05-28 11:32:09", "2024-05-28 11:32:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("18", "1088708", "action complete via Async Request", "2024-05-28 11:32:09", "2024-05-28 11:32:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("19", "1088709", "action created", "2024-05-28 11:32:09", "2024-05-28 11:32:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("20", "1088709", "action started via WP Cron", "2024-05-28 11:33:22", "2024-05-28 11:33:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("21", "1088709", "action complete via WP Cron", "2024-05-28 11:33:22", "2024-05-28 11:33:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("22", "1088710", "action created", "2024-05-28 11:33:22", "2024-05-28 11:33:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("23", "1088710", "action started via Async Request", "2024-05-28 11:35:49", "2024-05-28 11:35:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("24", "1088710", "action complete via Async Request", "2024-05-28 11:35:50", "2024-05-28 11:35:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("25", "1088711", "action created", "2024-05-28 11:35:50", "2024-05-28 11:35:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("26", "1088711", "action started via WP Cron", "2024-05-28 11:37:49", "2024-05-28 11:37:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("27", "1088711", "action complete via WP Cron", "2024-05-28 11:37:49", "2024-05-28 11:37:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("28", "1088712", "action created", "2024-05-28 11:37:49", "2024-05-28 11:37:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("29", "1088712", "action started via WP Cron", "2024-05-28 11:39:51", "2024-05-28 11:39:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("30", "1088712", "action complete via WP Cron", "2024-05-28 11:39:51", "2024-05-28 11:39:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("31", "1088713", "action created", "2024-05-28 11:39:51", "2024-05-28 11:39:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("32", "1088713", "action started via WP Cron", "2024-05-28 11:41:49", "2024-05-28 11:41:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("33", "1088713", "action complete via WP Cron", "2024-05-28 11:41:49", "2024-05-28 11:41:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("34", "1088714", "action created", "2024-05-28 11:41:49", "2024-05-28 11:41:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("35", "1088714", "action started via WP Cron", "2024-05-28 11:46:13", "2024-05-28 11:46:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("36", "1088714", "action complete via WP Cron", "2024-05-28 11:46:13", "2024-05-28 11:46:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("37", "1088715", "action created", "2024-05-28 11:46:13", "2024-05-28 11:46:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("38", "1088715", "action started via WP Cron", "2024-05-28 11:47:15", "2024-05-28 11:47:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("39", "1088715", "action complete via WP Cron", "2024-05-28 11:47:15", "2024-05-28 11:47:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("40", "1088716", "action created", "2024-05-28 11:47:15", "2024-05-28 11:47:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("41", "1088716", "action started via Async Request", "2024-05-28 11:48:20", "2024-05-28 11:48:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("42", "1088716", "action complete via Async Request", "2024-05-28 11:48:20", "2024-05-28 11:48:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("43", "1088717", "action created", "2024-05-28 11:48:20", "2024-05-28 11:48:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("44", "1088717", "action started via Async Request", "2024-05-28 11:49:37", "2024-05-28 11:49:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("45", "1088717", "action complete via Async Request", "2024-05-28 11:49:37", "2024-05-28 11:49:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("46", "1088718", "action created", "2024-05-28 11:49:37", "2024-05-28 11:49:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("47", "1088718", "action started via Async Request", "2024-05-28 11:50:56", "2024-05-28 11:50:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("48", "1088718", "action complete via Async Request", "2024-05-28 11:50:57", "2024-05-28 11:50:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("49", "1088719", "action created", "2024-05-28 11:50:57", "2024-05-28 11:50:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("50", "1088719", "action started via Async Request", "2024-05-28 11:52:07", "2024-05-28 11:52:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("51", "1088719", "action complete via Async Request", "2024-05-28 11:52:07", "2024-05-28 11:52:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("52", "1088720", "action created", "2024-05-28 11:52:07", "2024-05-28 11:52:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("53", "1088720", "action started via WP Cron", "2024-05-28 11:53:15", "2024-05-28 11:53:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("54", "1088720", "action complete via WP Cron", "2024-05-28 11:53:16", "2024-05-28 11:53:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("55", "1088721", "action created", "2024-05-28 11:53:16", "2024-05-28 11:53:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("56", "1088721", "action started via Async Request", "2024-05-28 11:54:32", "2024-05-28 11:54:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("57", "1088721", "action complete via Async Request", "2024-05-28 11:54:32", "2024-05-28 11:54:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("58", "1088722", "action created", "2024-05-28 11:54:32", "2024-05-28 11:54:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("59", "1088722", "action started via WP Cron", "2024-05-28 11:56:33", "2024-05-28 11:56:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("60", "1088722", "action complete via WP Cron", "2024-05-28 11:56:34", "2024-05-28 11:56:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("61", "1088723", "action created", "2024-05-28 11:56:34", "2024-05-28 11:56:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("62", "1088723", "action started via WP Cron", "2024-05-28 11:58:34", "2024-05-28 11:58:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("63", "1088723", "action complete via WP Cron", "2024-05-28 11:58:34", "2024-05-28 11:58:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("64", "1088724", "action created", "2024-05-28 11:58:34", "2024-05-28 11:58:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("65", "1088724", "action started via Async Request", "2024-05-28 12:00:36", "2024-05-28 12:00:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("66", "1088724", "action complete via Async Request", "2024-05-28 12:00:36", "2024-05-28 12:00:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("67", "1088725", "action created", "2024-05-28 12:00:36", "2024-05-28 12:00:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("68", "1088725", "action started via WP Cron", "2024-05-28 12:02:44", "2024-05-28 12:02:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("69", "1088725", "action complete via WP Cron", "2024-05-28 12:02:44", "2024-05-28 12:02:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("70", "1088726", "action created", "2024-05-28 12:02:44", "2024-05-28 12:02:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("71", "1088726", "action started via WP Cron", "2024-05-28 13:04:41", "2024-05-28 13:04:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("72", "1088726", "action complete via WP Cron", "2024-05-28 13:04:41", "2024-05-28 13:04:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("73", "1088727", "action created", "2024-05-28 13:04:41", "2024-05-28 13:04:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("74", "1088727", "action started via WP Cron", "2024-05-28 13:16:54", "2024-05-28 13:16:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("75", "1088727", "action complete via WP Cron", "2024-05-28 13:16:55", "2024-05-28 13:16:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("76", "1088728", "action created", "2024-05-28 13:16:55", "2024-05-28 13:16:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("77", "1088728", "action started via WP Cron", "2024-05-28 13:26:31", "2024-05-28 13:26:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("78", "1088728", "action complete via WP Cron", "2024-05-28 13:26:31", "2024-05-28 13:26:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("79", "1088729", "action created", "2024-05-28 13:26:31", "2024-05-28 13:26:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("80", "1088729", "action started via WP Cron", "2024-05-28 13:42:22", "2024-05-28 13:42:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("81", "1088729", "action complete via WP Cron", "2024-05-28 13:42:22", "2024-05-28 13:42:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("82", "1088730", "action created", "2024-05-28 13:42:22", "2024-05-28 13:42:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("83", "1088730", "action started via WP Cron", "2024-05-28 14:25:14", "2024-05-28 14:25:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("84", "1088730", "action complete via WP Cron", "2024-05-28 14:25:14", "2024-05-28 14:25:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("85", "1088731", "action created", "2024-05-28 14:25:14", "2024-05-28 14:25:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("86", "1088731", "action started via WP Cron", "2024-05-28 16:48:35", "2024-05-28 16:48:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("87", "1088731", "action complete via WP Cron", "2024-05-28 16:48:35", "2024-05-28 16:48:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("88", "1088732", "action created", "2024-05-28 16:48:35", "2024-05-28 16:48:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("89", "1088732", "action started via WP Cron", "2024-05-28 17:14:35", "2024-05-28 17:14:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("90", "1088732", "action complete via WP Cron", "2024-05-28 17:14:35", "2024-05-28 17:14:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("91", "1088733", "action created", "2024-05-28 17:14:35", "2024-05-28 17:14:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("92", "1088733", "action started via WP Cron", "2024-05-28 17:32:50", "2024-05-28 17:32:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("93", "1088733", "action complete via WP Cron", "2024-05-28 17:32:50", "2024-05-28 17:32:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("94", "1088734", "action created", "2024-05-28 17:32:50", "2024-05-28 17:32:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("95", "1088734", "action started via WP Cron", "2024-05-28 17:49:32", "2024-05-28 17:49:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("96", "1088734", "action complete via WP Cron", "2024-05-28 17:49:32", "2024-05-28 17:49:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("97", "1088735", "action created", "2024-05-28 17:49:32", "2024-05-28 17:49:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("98", "1088735", "action started via WP Cron", "2024-05-28 18:26:31", "2024-05-28 18:26:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("99", "1088735", "action complete via WP Cron", "2024-05-28 18:26:31", "2024-05-28 18:26:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("100", "1088736", "action created", "2024-05-28 18:26:31", "2024-05-28 18:26:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("101", "1088736", "action started via WP Cron", "2024-05-28 18:48:38", "2024-05-28 18:48:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("102", "1088736", "action complete via WP Cron", "2024-05-28 18:48:38", "2024-05-28 18:48:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("103", "1088737", "action created", "2024-05-28 18:48:38", "2024-05-28 18:48:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("104", "1088737", "action started via WP Cron", "2024-05-28 18:53:41", "2024-05-28 18:53:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("105", "1088737", "action complete via WP Cron", "2024-05-28 18:53:41", "2024-05-28 18:53:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("106", "1088738", "action created", "2024-05-28 18:53:41", "2024-05-28 18:53:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("107", "1088738", "action started via WP Cron", "2024-05-28 19:42:17", "2024-05-28 19:42:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("108", "1088738", "action complete via WP Cron", "2024-05-28 19:42:17", "2024-05-28 19:42:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("109", "1088739", "action created", "2024-05-28 19:42:17", "2024-05-28 19:42:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("110", "1088739", "action started via WP Cron", "2024-05-28 20:29:11", "2024-05-28 20:29:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("111", "1088739", "action complete via WP Cron", "2024-05-28 20:29:11", "2024-05-28 20:29:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("112", "1088740", "action created", "2024-05-28 20:29:11", "2024-05-28 20:29:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("113", "1088740", "action started via WP Cron", "2024-05-29 03:24:31", "2024-05-29 03:24:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("114", "1088740", "action complete via WP Cron", "2024-05-29 03:24:31", "2024-05-29 03:24:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("115", "1088741", "action created", "2024-05-29 03:24:31", "2024-05-29 03:24:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("116", "1088741", "action started via WP Cron", "2024-05-29 03:37:43", "2024-05-29 03:37:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("117", "1088741", "action complete via WP Cron", "2024-05-29 03:37:43", "2024-05-29 03:37:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("118", "1088742", "action created", "2024-05-29 03:37:43", "2024-05-29 03:37:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("119", "1088742", "action started via WP Cron", "2024-05-29 03:41:17", "2024-05-29 03:41:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("120", "1088742", "action complete via WP Cron", "2024-05-29 03:41:17", "2024-05-29 03:41:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("121", "1088743", "action created", "2024-05-29 03:41:17", "2024-05-29 03:41:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("122", "1088743", "action started via WP Cron", "2024-05-29 03:54:54", "2024-05-29 03:54:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("123", "1088743", "action complete via WP Cron", "2024-05-29 03:54:54", "2024-05-29 03:54:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("124", "1088744", "action created", "2024-05-29 03:54:54", "2024-05-29 03:54:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("125", "1088744", "action started via WP Cron", "2024-05-29 04:18:18", "2024-05-29 04:18:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("126", "1088744", "action complete via WP Cron", "2024-05-29 04:18:18", "2024-05-29 04:18:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("127", "1088745", "action created", "2024-05-29 04:18:18", "2024-05-29 04:18:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("128", "1088745", "action started via WP Cron", "2024-05-29 04:40:47", "2024-05-29 04:40:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("129", "1088745", "action complete via WP Cron", "2024-05-29 04:40:47", "2024-05-29 04:40:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("130", "1088746", "action created", "2024-05-29 04:40:47", "2024-05-29 04:40:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("131", "1088746", "action started via WP Cron", "2024-05-29 04:45:31", "2024-05-29 04:45:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("132", "1088746", "action complete via WP Cron", "2024-05-29 04:45:31", "2024-05-29 04:45:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("133", "1088747", "action created", "2024-05-29 04:45:31", "2024-05-29 04:45:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("134", "1088747", "action started via WP Cron", "2024-05-29 05:03:35", "2024-05-29 05:03:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("135", "1088747", "action complete via WP Cron", "2024-05-29 05:03:35", "2024-05-29 05:03:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("136", "1088748", "action created", "2024-05-29 05:03:35", "2024-05-29 05:03:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("137", "1088748", "action started via WP Cron", "2024-05-29 05:26:22", "2024-05-29 05:26:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("138", "1088748", "action complete via WP Cron", "2024-05-29 05:26:22", "2024-05-29 05:26:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("139", "1088749", "action created", "2024-05-29 05:26:22", "2024-05-29 05:26:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("140", "1088749", "action started via WP Cron", "2024-05-29 05:49:37", "2024-05-29 05:49:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("141", "1088749", "action complete via WP Cron", "2024-05-29 05:49:38", "2024-05-29 05:49:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("142", "1088750", "action created", "2024-05-29 05:49:38", "2024-05-29 05:49:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("143", "1088750", "action started via WP Cron", "2024-05-29 06:19:16", "2024-05-29 06:19:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("144", "1088750", "action complete via WP Cron", "2024-05-29 06:19:16", "2024-05-29 06:19:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("145", "1088751", "action created", "2024-05-29 06:19:16", "2024-05-29 06:19:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("146", "1088751", "action started via WP Cron", "2024-05-29 06:30:49", "2024-05-29 06:30:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("147", "1088751", "action complete via WP Cron", "2024-05-29 06:30:49", "2024-05-29 06:30:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("148", "1088752", "action created", "2024-05-29 06:30:49", "2024-05-29 06:30:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("149", "1088752", "action started via WP Cron", "2024-05-29 06:51:06", "2024-05-29 06:51:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("150", "1088752", "action complete via WP Cron", "2024-05-29 06:51:06", "2024-05-29 06:51:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("151", "1088753", "action created", "2024-05-29 06:51:06", "2024-05-29 06:51:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("152", "1088753", "action started via WP Cron", "2024-05-29 06:59:26", "2024-05-29 06:59:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("153", "1088753", "action complete via WP Cron", "2024-05-29 06:59:26", "2024-05-29 06:59:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("154", "1088754", "action created", "2024-05-29 06:59:26", "2024-05-29 06:59:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("155", "1088754", "action started via WP Cron", "2024-05-29 07:08:05", "2024-05-29 07:08:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("156", "1088754", "action complete via WP Cron", "2024-05-29 07:08:05", "2024-05-29 07:08:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("157", "1088755", "action created", "2024-05-29 07:08:05", "2024-05-29 07:08:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("158", "1088755", "action started via WP Cron", "2024-05-29 07:16:22", "2024-05-29 07:16:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("159", "1088755", "action complete via WP Cron", "2024-05-29 07:16:22", "2024-05-29 07:16:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("160", "1088756", "action created", "2024-05-29 07:16:22", "2024-05-29 07:16:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("161", "1088756", "action started via WP Cron", "2024-05-29 07:24:52", "2024-05-29 07:24:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("162", "1088756", "action complete via WP Cron", "2024-05-29 07:24:52", "2024-05-29 07:24:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("163", "1088757", "action created", "2024-05-29 07:24:52", "2024-05-29 07:24:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("164", "1088757", "action started via WP Cron", "2024-05-29 07:32:48", "2024-05-29 07:32:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("165", "1088757", "action complete via WP Cron", "2024-05-29 07:32:48", "2024-05-29 07:32:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("166", "1088758", "action created", "2024-05-29 07:32:48", "2024-05-29 07:32:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("167", "1088758", "action started via WP Cron", "2024-05-29 07:40:38", "2024-05-29 07:40:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("168", "1088758", "action complete via WP Cron", "2024-05-29 07:40:38", "2024-05-29 07:40:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("169", "1088759", "action created", "2024-05-29 07:40:38", "2024-05-29 07:40:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("170", "1088759", "action started via WP Cron", "2024-05-29 07:46:02", "2024-05-29 07:46:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("171", "1088759", "action complete via WP Cron", "2024-05-29 07:46:02", "2024-05-29 07:46:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("172", "1088760", "action created", "2024-05-29 07:46:02", "2024-05-29 07:46:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("173", "1088760", "action started via WP Cron", "2024-05-29 07:48:03", "2024-05-29 07:48:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("174", "1088760", "action complete via WP Cron", "2024-05-29 07:48:03", "2024-05-29 07:48:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("175", "1088761", "action created", "2024-05-29 07:48:03", "2024-05-29 07:48:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("176", "1088761", "action started via WP Cron", "2024-05-29 08:02:55", "2024-05-29 08:02:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("177", "1088761", "action complete via WP Cron", "2024-05-29 08:02:55", "2024-05-29 08:02:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("178", "1088762", "action created", "2024-05-29 08:02:55", "2024-05-29 08:02:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("179", "1088762", "action started via WP Cron", "2024-05-29 08:10:06", "2024-05-29 08:10:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("180", "1088762", "action complete via WP Cron", "2024-05-29 08:10:07", "2024-05-29 08:10:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("181", "1088763", "action created", "2024-05-29 08:10:07", "2024-05-29 08:10:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("182", "1088763", "action started via WP Cron", "2024-05-29 08:16:39", "2024-05-29 08:16:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("183", "1088763", "action complete via WP Cron", "2024-05-29 08:16:39", "2024-05-29 08:16:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("184", "1088764", "action created", "2024-05-29 08:16:39", "2024-05-29 08:16:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("185", "1088764", "action started via WP Cron", "2024-05-29 08:23:09", "2024-05-29 08:23:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("186", "1088764", "action complete via WP Cron", "2024-05-29 08:23:09", "2024-05-29 08:23:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("187", "1088765", "action created", "2024-05-29 08:23:09", "2024-05-29 08:23:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("188", "1088765", "action started via WP Cron", "2024-05-29 08:29:29", "2024-05-29 08:29:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("189", "1088765", "action complete via WP Cron", "2024-05-29 08:29:29", "2024-05-29 08:29:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("190", "1088766", "action created", "2024-05-29 08:29:29", "2024-05-29 08:29:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("191", "1088766", "action started via WP Cron", "2024-05-29 08:35:44", "2024-05-29 08:35:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("192", "1088766", "action complete via WP Cron", "2024-05-29 08:35:44", "2024-05-29 08:35:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("193", "1088767", "action created", "2024-05-29 08:35:44", "2024-05-29 08:35:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("194", "1088767", "action started via WP Cron", "2024-05-29 08:41:54", "2024-05-29 08:41:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("195", "1088767", "action complete via WP Cron", "2024-05-29 08:41:54", "2024-05-29 08:41:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("196", "1088768", "action created", "2024-05-29 08:41:54", "2024-05-29 08:41:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("197", "1088768", "action started via WP Cron", "2024-05-29 08:47:39", "2024-05-29 08:47:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("198", "1088768", "action complete via WP Cron", "2024-05-29 08:47:39", "2024-05-29 08:47:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("199", "1088769", "action created", "2024-05-29 08:47:39", "2024-05-29 08:47:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("200", "1088769", "action started via WP Cron", "2024-05-29 08:53:44", "2024-05-29 08:53:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("201", "1088769", "action complete via WP Cron", "2024-05-29 08:53:44", "2024-05-29 08:53:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("202", "1088770", "action created", "2024-05-29 08:53:44", "2024-05-29 08:53:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("203", "1088770", "action started via WP Cron", "2024-05-29 08:59:33", "2024-05-29 08:59:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("204", "1088770", "action complete via WP Cron", "2024-05-29 08:59:33", "2024-05-29 08:59:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("205", "1088771", "action created", "2024-05-29 08:59:33", "2024-05-29 08:59:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("206", "1088771", "action started via WP Cron", "2024-05-29 09:02:55", "2024-05-29 09:02:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("207", "1088771", "action complete via WP Cron", "2024-05-29 09:02:55", "2024-05-29 09:02:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("208", "1088772", "action created", "2024-05-29 09:02:55", "2024-05-29 09:02:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("209", "1088772", "action started via WP Cron", "2024-05-29 09:05:12", "2024-05-29 09:05:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("210", "1088772", "action complete via WP Cron", "2024-05-29 09:05:12", "2024-05-29 09:05:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("211", "1088773", "action created", "2024-05-29 09:05:12", "2024-05-29 09:05:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("212", "1088773", "action started via WP Cron", "2024-05-29 09:17:42", "2024-05-29 09:17:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("213", "1088773", "action complete via WP Cron", "2024-05-29 09:17:42", "2024-05-29 09:17:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("214", "1088774", "action created", "2024-05-29 09:17:43", "2024-05-29 09:17:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("215", "1088774", "action started via WP Cron", "2024-05-29 09:30:29", "2024-05-29 09:30:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("216", "1088774", "action complete via WP Cron", "2024-05-29 09:30:29", "2024-05-29 09:30:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("217", "1088775", "action created", "2024-05-29 09:30:29", "2024-05-29 09:30:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("218", "1088775", "action started via WP Cron", "2024-05-29 09:36:35", "2024-05-29 09:36:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("219", "1088775", "action complete via WP Cron", "2024-05-29 09:36:35", "2024-05-29 09:36:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("220", "1088776", "action created", "2024-05-29 09:36:35", "2024-05-29 09:36:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("221", "1088776", "action started via WP Cron", "2024-05-29 09:43:50", "2024-05-29 09:43:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("222", "1088776", "action complete via WP Cron", "2024-05-29 09:43:50", "2024-05-29 09:43:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("223", "1088777", "action created", "2024-05-29 09:43:50", "2024-05-29 09:43:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("224", "1088777", "action started via WP Cron", "2024-05-29 09:50:36", "2024-05-29 09:50:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("225", "1088777", "action complete via WP Cron", "2024-05-29 09:50:36", "2024-05-29 09:50:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("226", "1088778", "action created", "2024-05-29 09:50:36", "2024-05-29 09:50:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("227", "1088778", "action started via WP Cron", "2024-05-29 09:58:02", "2024-05-29 09:58:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("228", "1088778", "action complete via WP Cron", "2024-05-29 09:58:02", "2024-05-29 09:58:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("229", "1088779", "action created", "2024-05-29 09:58:02", "2024-05-29 09:58:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("230", "1088779", "action started via WP Cron", "2024-05-29 10:05:16", "2024-05-29 10:05:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("231", "1088779", "action complete via WP Cron", "2024-05-29 10:05:16", "2024-05-29 10:05:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("232", "1088780", "action created", "2024-05-29 10:05:16", "2024-05-29 10:05:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("233", "1088780", "action started via WP Cron", "2024-05-29 10:12:24", "2024-05-29 10:12:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("234", "1088780", "action complete via WP Cron", "2024-05-29 10:12:24", "2024-05-29 10:12:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("235", "1088781", "action created", "2024-05-29 10:12:24", "2024-05-29 10:12:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("236", "1088781", "action started via WP Cron", "2024-05-29 10:19:35", "2024-05-29 10:19:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("237", "1088781", "action complete via WP Cron", "2024-05-29 10:19:35", "2024-05-29 10:19:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("238", "1088782", "action created", "2024-05-29 10:19:35", "2024-05-29 10:19:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("239", "1088782", "action started via WP Cron", "2024-05-29 10:27:14", "2024-05-29 10:27:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("240", "1088782", "action complete via WP Cron", "2024-05-29 10:27:14", "2024-05-29 10:27:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("241", "1088783", "action created", "2024-05-29 10:27:14", "2024-05-29 10:27:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("242", "1088783", "action started via WP Cron", "2024-05-29 10:34:30", "2024-05-29 10:34:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("243", "1088783", "action complete via WP Cron", "2024-05-29 10:34:30", "2024-05-29 10:34:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("244", "1088784", "action created", "2024-05-29 10:34:30", "2024-05-29 10:34:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("245", "1088784", "action started via WP Cron", "2024-05-29 10:39:47", "2024-05-29 10:39:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("246", "1088784", "action complete via WP Cron", "2024-05-29 10:39:47", "2024-05-29 10:39:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("247", "1088785", "action created", "2024-05-29 10:39:47", "2024-05-29 10:39:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("248", "1088785", "action started via WP Cron", "2024-05-29 10:42:02", "2024-05-29 10:42:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("249", "1088785", "action complete via WP Cron", "2024-05-29 10:42:02", "2024-05-29 10:42:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("250", "1088786", "action created", "2024-05-29 10:42:02", "2024-05-29 10:42:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("251", "1088786", "action started via WP Cron", "2024-05-29 10:49:40", "2024-05-29 10:49:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("252", "1088786", "action complete via WP Cron", "2024-05-29 10:49:41", "2024-05-29 10:49:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("253", "1088787", "action created", "2024-05-29 10:49:41", "2024-05-29 10:49:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("254", "1088787", "action started via WP Cron", "2024-05-29 10:51:44", "2024-05-29 10:51:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("255", "1088787", "action complete via WP Cron", "2024-05-29 10:51:44", "2024-05-29 10:51:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("256", "1088788", "action created", "2024-05-29 10:51:44", "2024-05-29 10:51:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("257", "1088788", "action started via WP Cron", "2024-05-29 10:57:20", "2024-05-29 10:57:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("258", "1088788", "action complete via WP Cron", "2024-05-29 10:57:20", "2024-05-29 10:57:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("259", "1088789", "action created", "2024-05-29 10:57:20", "2024-05-29 10:57:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("260", "1088789", "action started via WP Cron", "2024-05-29 11:05:11", "2024-05-29 11:05:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("261", "1088789", "action complete via WP Cron", "2024-05-29 11:05:11", "2024-05-29 11:05:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("262", "1088790", "action created", "2024-05-29 11:05:11", "2024-05-29 11:05:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("263", "1088790", "action started via WP Cron", "2024-05-29 11:13:21", "2024-05-29 11:13:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("264", "1088790", "action complete via WP Cron", "2024-05-29 11:13:21", "2024-05-29 11:13:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("265", "1088791", "action created", "2024-05-29 11:13:21", "2024-05-29 11:13:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("266", "1088791", "action started via WP Cron", "2024-05-29 11:21:15", "2024-05-29 11:21:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("267", "1088791", "action complete via WP Cron", "2024-05-29 11:21:15", "2024-05-29 11:21:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("268", "1088792", "action created", "2024-05-29 11:21:15", "2024-05-29 11:21:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("269", "1088792", "action started via WP Cron", "2024-05-29 11:29:20", "2024-05-29 11:29:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("270", "1088792", "action complete via WP Cron", "2024-05-29 11:29:20", "2024-05-29 11:29:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("271", "1088793", "action created", "2024-05-29 11:29:20", "2024-05-29 11:29:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("272", "1088793", "action started via WP Cron", "2024-05-29 11:36:07", "2024-05-29 11:36:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("273", "1088793", "action complete via WP Cron", "2024-05-29 11:36:07", "2024-05-29 11:36:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("274", "1088794", "action created", "2024-05-29 11:36:07", "2024-05-29 11:36:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("275", "1088794", "action started via WP Cron", "2024-05-29 11:38:10", "2024-05-29 11:38:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("276", "1088794", "action complete via WP Cron", "2024-05-29 11:38:10", "2024-05-29 11:38:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("277", "1088795", "action created", "2024-05-29 11:38:10", "2024-05-29 11:38:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("278", "1088795", "action started via WP Cron", "2024-05-29 11:44:51", "2024-05-29 11:44:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("279", "1088795", "action complete via WP Cron", "2024-05-29 11:44:51", "2024-05-29 11:44:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("280", "1088796", "action created", "2024-05-29 11:44:51", "2024-05-29 11:44:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("281", "1088796", "action started via WP Cron", "2024-05-29 11:53:16", "2024-05-29 11:53:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("282", "1088796", "action complete via WP Cron", "2024-05-29 11:53:16", "2024-05-29 11:53:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("283", "1088797", "action created", "2024-05-29 11:53:16", "2024-05-29 11:53:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("284", "1088797", "action started via WP Cron", "2024-05-29 12:02:05", "2024-05-29 12:02:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("285", "1088797", "action complete via WP Cron", "2024-05-29 12:02:05", "2024-05-29 12:02:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("286", "1088798", "action created", "2024-05-29 12:02:05", "2024-05-29 12:02:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("287", "1088798", "action started via WP Cron", "2024-05-29 12:11:03", "2024-05-29 12:11:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("288", "1088798", "action complete via WP Cron", "2024-05-29 12:11:03", "2024-05-29 12:11:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("289", "1088799", "action created", "2024-05-29 12:11:03", "2024-05-29 12:11:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("290", "1088799", "action started via WP Cron", "2024-05-29 12:17:47", "2024-05-29 12:17:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("291", "1088799", "action complete via WP Cron", "2024-05-29 12:17:47", "2024-05-29 12:17:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("292", "1088800", "action created", "2024-05-29 12:17:47", "2024-05-29 12:17:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("293", "1088800", "action started via WP Cron", "2024-05-29 12:32:46", "2024-05-29 12:32:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("294", "1088800", "action complete via WP Cron", "2024-05-29 12:32:46", "2024-05-29 12:32:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("295", "1088801", "action created", "2024-05-29 12:32:46", "2024-05-29 12:32:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("296", "1088801", "action started via WP Cron", "2024-05-29 13:30:53", "2024-05-29 13:30:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("297", "1088801", "action complete via WP Cron", "2024-05-29 13:30:53", "2024-05-29 13:30:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("298", "1088802", "action created", "2024-05-29 13:30:53", "2024-05-29 13:30:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("299", "1088802", "action started via WP Cron", "2024-05-29 14:27:19", "2024-05-29 14:27:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("300", "1088802", "action complete via WP Cron", "2024-05-29 14:27:19", "2024-05-29 14:27:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("301", "1088803", "action created", "2024-05-29 14:27:19", "2024-05-29 14:27:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("302", "1088803", "action started via WP Cron", "2024-05-29 14:56:56", "2024-05-29 14:56:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("303", "1088803", "action complete via WP Cron", "2024-05-29 14:56:56", "2024-05-29 14:56:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("304", "1088804", "action created", "2024-05-29 14:56:56", "2024-05-29 14:56:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("305", "1088804", "action started via WP Cron", "2024-05-29 15:07:12", "2024-05-29 15:07:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("306", "1088804", "action complete via WP Cron", "2024-05-29 15:07:12", "2024-05-29 15:07:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("307", "1088805", "action created", "2024-05-29 15:07:12", "2024-05-29 15:07:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("308", "1088805", "action started via WP Cron", "2024-05-29 15:10:49", "2024-05-29 15:10:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("309", "1088805", "action complete via WP Cron", "2024-05-29 15:10:49", "2024-05-29 15:10:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("310", "1088806", "action created", "2024-05-29 15:10:49", "2024-05-29 15:10:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("311", "1088806", "action started via WP Cron", "2024-05-29 15:13:12", "2024-05-29 15:13:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("312", "1088806", "action complete via WP Cron", "2024-05-29 15:13:12", "2024-05-29 15:13:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("313", "1088807", "action created", "2024-05-29 15:13:12", "2024-05-29 15:13:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("314", "1088807", "action started via WP Cron", "2024-05-29 15:14:49", "2024-05-29 15:14:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("315", "1088807", "action complete via WP Cron", "2024-05-29 15:14:49", "2024-05-29 15:14:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("316", "1088808", "action created", "2024-05-29 15:14:49", "2024-05-29 15:14:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("317", "1088808", "action started via WP Cron", "2024-05-29 15:27:19", "2024-05-29 15:27:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("318", "1088808", "action complete via WP Cron", "2024-05-29 15:27:19", "2024-05-29 15:27:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("319", "1088809", "action created", "2024-05-29 15:27:19", "2024-05-29 15:27:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("320", "1088809", "action started via WP Cron", "2024-05-29 15:30:33", "2024-05-29 15:30:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("321", "1088809", "action complete via WP Cron", "2024-05-29 15:30:33", "2024-05-29 15:30:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("322", "1088810", "action created", "2024-05-29 15:30:33", "2024-05-29 15:30:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("323", "1088810", "action started via WP Cron", "2024-05-29 15:44:14", "2024-05-29 15:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("324", "1088810", "action complete via WP Cron", "2024-05-29 15:44:14", "2024-05-29 15:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("325", "1088811", "action created", "2024-05-29 15:44:14", "2024-05-29 15:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("326", "1088811", "action started via WP Cron", "2024-05-29 15:47:30", "2024-05-29 15:47:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("327", "1088811", "action complete via WP Cron", "2024-05-29 15:47:30", "2024-05-29 15:47:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("328", "1088812", "action created", "2024-05-29 15:47:30", "2024-05-29 15:47:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("329", "1088812", "action started via WP Cron", "2024-05-29 16:00:30", "2024-05-29 16:00:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("330", "1088812", "action complete via WP Cron", "2024-05-29 16:00:31", "2024-05-29 16:00:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("331", "1088813", "action created", "2024-05-29 16:00:31", "2024-05-29 16:00:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("332", "1088813", "action started via WP Cron", "2024-05-29 16:04:15", "2024-05-29 16:04:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("333", "1088813", "action complete via WP Cron", "2024-05-29 16:04:16", "2024-05-29 16:04:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("334", "1088814", "action created", "2024-05-29 16:04:16", "2024-05-29 16:04:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("335", "1088814", "action started via WP Cron", "2024-05-29 16:21:55", "2024-05-29 16:21:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("336", "1088814", "action complete via WP Cron", "2024-05-29 16:21:55", "2024-05-29 16:21:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("337", "1088815", "action created", "2024-05-29 16:21:55", "2024-05-29 16:21:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("338", "1088815", "action started via WP Cron", "2024-05-29 16:34:37", "2024-05-29 16:34:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("339", "1088815", "action complete via WP Cron", "2024-05-29 16:34:37", "2024-05-29 16:34:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("340", "1088816", "action created", "2024-05-29 16:34:37", "2024-05-29 16:34:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("341", "1088816", "action started via WP Cron", "2024-05-29 16:37:50", "2024-05-29 16:37:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("342", "1088816", "action complete via WP Cron", "2024-05-29 16:37:50", "2024-05-29 16:37:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("343", "1088817", "action created", "2024-05-29 16:37:50", "2024-05-29 16:37:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("344", "1088817", "action started via WP Cron", "2024-05-29 16:51:19", "2024-05-29 16:51:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("345", "1088817", "action complete via WP Cron", "2024-05-29 16:51:19", "2024-05-29 16:51:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("346", "1088818", "action created", "2024-05-29 16:51:19", "2024-05-29 16:51:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("347", "1088818", "action started via WP Cron", "2024-05-29 16:54:33", "2024-05-29 16:54:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("348", "1088818", "action complete via WP Cron", "2024-05-29 16:54:33", "2024-05-29 16:54:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("349", "1088819", "action created", "2024-05-29 16:54:33", "2024-05-29 16:54:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("350", "1088819", "action started via WP Cron", "2024-05-29 17:07:46", "2024-05-29 17:07:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("351", "1088819", "action complete via WP Cron", "2024-05-29 17:07:46", "2024-05-29 17:07:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("352", "1088820", "action created", "2024-05-29 17:07:46", "2024-05-29 17:07:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("353", "1088820", "action started via WP Cron", "2024-05-29 17:10:57", "2024-05-29 17:10:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("354", "1088820", "action complete via WP Cron", "2024-05-29 17:10:57", "2024-05-29 17:10:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("355", "1088821", "action created", "2024-05-29 17:10:57", "2024-05-29 17:10:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("356", "1088821", "action started via WP Cron", "2024-05-29 17:24:17", "2024-05-29 17:24:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("357", "1088821", "action complete via WP Cron", "2024-05-29 17:24:17", "2024-05-29 17:24:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("358", "1088822", "action created", "2024-05-29 17:24:17", "2024-05-29 17:24:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("359", "1088822", "action started via WP Cron", "2024-05-29 17:27:25", "2024-05-29 17:27:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("360", "1088822", "action complete via WP Cron", "2024-05-29 17:27:26", "2024-05-29 17:27:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("361", "1088823", "action created", "2024-05-29 17:27:26", "2024-05-29 17:27:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("362", "1088823", "action started via WP Cron", "2024-05-29 17:40:31", "2024-05-29 17:40:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("363", "1088823", "action complete via WP Cron", "2024-05-29 17:40:31", "2024-05-29 17:40:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("364", "1088824", "action created", "2024-05-29 17:40:31", "2024-05-29 17:40:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("365", "1088824", "action started via WP Cron", "2024-05-29 17:43:40", "2024-05-29 17:43:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("366", "1088824", "action complete via WP Cron", "2024-05-29 17:43:40", "2024-05-29 17:43:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("367", "1088825", "action created", "2024-05-29 17:43:40", "2024-05-29 17:43:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("368", "1088825", "action started via WP Cron", "2024-05-29 17:56:47", "2024-05-29 17:56:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("369", "1088825", "action complete via WP Cron", "2024-05-29 17:56:47", "2024-05-29 17:56:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("370", "1088826", "action created", "2024-05-29 17:56:47", "2024-05-29 17:56:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("371", "1088826", "action started via WP Cron", "2024-05-29 17:59:57", "2024-05-29 17:59:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("372", "1088826", "action complete via WP Cron", "2024-05-29 17:59:57", "2024-05-29 17:59:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("373", "1088827", "action created", "2024-05-29 17:59:57", "2024-05-29 17:59:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("374", "1088827", "action started via WP Cron", "2024-05-29 18:04:34", "2024-05-29 18:04:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("375", "1088827", "action complete via WP Cron", "2024-05-29 18:04:34", "2024-05-29 18:04:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("376", "1088828", "action created", "2024-05-29 18:04:34", "2024-05-29 18:04:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("377", "1088828", "action started via WP Cron", "2024-05-29 18:06:12", "2024-05-29 18:06:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("378", "1088828", "action complete via WP Cron", "2024-05-29 18:06:12", "2024-05-29 18:06:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("379", "1088829", "action created", "2024-05-29 18:06:12", "2024-05-29 18:06:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("380", "1088829", "action started via WP Cron", "2024-05-29 18:08:10", "2024-05-29 18:08:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("381", "1088829", "action complete via WP Cron", "2024-05-29 18:08:10", "2024-05-29 18:08:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("382", "1088830", "action created", "2024-05-29 18:08:10", "2024-05-29 18:08:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("383", "1088830", "action started via WP Cron", "2024-05-29 18:09:10", "2024-05-29 18:09:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("384", "1088830", "action complete via WP Cron", "2024-05-29 18:09:10", "2024-05-29 18:09:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("385", "1088831", "action created", "2024-05-29 18:09:10", "2024-05-29 18:09:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("386", "1088831", "action started via WP Cron", "2024-05-29 18:10:11", "2024-05-29 18:10:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("387", "1088831", "action complete via WP Cron", "2024-05-29 18:10:12", "2024-05-29 18:10:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("388", "1088832", "action created", "2024-05-29 18:10:12", "2024-05-29 18:10:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("389", "1088832", "action started via WP Cron", "2024-05-29 18:12:09", "2024-05-29 18:12:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("390", "1088832", "action complete via WP Cron", "2024-05-29 18:12:09", "2024-05-29 18:12:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("391", "1088833", "action created", "2024-05-29 18:12:09", "2024-05-29 18:12:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("392", "1088833", "action started via WP Cron", "2024-05-29 18:13:09", "2024-05-29 18:13:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("393", "1088833", "action complete via WP Cron", "2024-05-29 18:13:09", "2024-05-29 18:13:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("394", "1088834", "action created", "2024-05-29 18:13:10", "2024-05-29 18:13:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("395", "1088834", "action started via WP Cron", "2024-05-29 18:15:11", "2024-05-29 18:15:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("396", "1088834", "action complete via WP Cron", "2024-05-29 18:15:11", "2024-05-29 18:15:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("397", "1088835", "action created", "2024-05-29 18:15:11", "2024-05-29 18:15:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("398", "1088835", "action started via WP Cron", "2024-05-29 18:17:08", "2024-05-29 18:17:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("399", "1088835", "action complete via WP Cron", "2024-05-29 18:17:08", "2024-05-29 18:17:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("400", "1088836", "action created", "2024-05-29 18:17:08", "2024-05-29 18:17:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("401", "1088836", "action started via WP Cron", "2024-05-29 18:18:12", "2024-05-29 18:18:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("402", "1088836", "action complete via WP Cron", "2024-05-29 18:18:12", "2024-05-29 18:18:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("403", "1088837", "action created", "2024-05-29 18:18:12", "2024-05-29 18:18:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("404", "1088837", "action started via WP Cron", "2024-05-29 18:19:12", "2024-05-29 18:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("405", "1088837", "action complete via WP Cron", "2024-05-29 18:19:12", "2024-05-29 18:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("406", "1088838", "action created", "2024-05-29 18:19:12", "2024-05-29 18:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("407", "1088838", "action started via WP Cron", "2024-05-29 18:21:10", "2024-05-29 18:21:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("408", "1088838", "action complete via WP Cron", "2024-05-29 18:21:11", "2024-05-29 18:21:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("409", "1088839", "action created", "2024-05-29 18:21:11", "2024-05-29 18:21:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("410", "1088839", "action started via WP Cron", "2024-05-29 18:23:10", "2024-05-29 18:23:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("411", "1088839", "action complete via WP Cron", "2024-05-29 18:23:10", "2024-05-29 18:23:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("412", "1088840", "action created", "2024-05-29 18:23:10", "2024-05-29 18:23:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("413", "1088840", "action started via WP Cron", "2024-05-29 18:25:11", "2024-05-29 18:25:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("414", "1088840", "action complete via WP Cron", "2024-05-29 18:25:11", "2024-05-29 18:25:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("415", "1088841", "action created", "2024-05-29 18:25:11", "2024-05-29 18:25:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("416", "1088841", "action started via WP Cron", "2024-05-29 18:27:11", "2024-05-29 18:27:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("417", "1088841", "action complete via WP Cron", "2024-05-29 18:27:12", "2024-05-29 18:27:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("418", "1088842", "action created", "2024-05-29 18:27:12", "2024-05-29 18:27:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("419", "1088842", "action started via WP Cron", "2024-05-29 18:29:10", "2024-05-29 18:29:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("420", "1088842", "action complete via WP Cron", "2024-05-29 18:29:10", "2024-05-29 18:29:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("421", "1088843", "action created", "2024-05-29 18:29:10", "2024-05-29 18:29:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("422", "1088843", "action started via WP Cron", "2024-05-29 18:30:10", "2024-05-29 18:30:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("423", "1088843", "action complete via WP Cron", "2024-05-29 18:30:10", "2024-05-29 18:30:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("424", "1088844", "action created", "2024-05-29 18:30:10", "2024-05-29 18:30:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("425", "1088844", "action started via WP Cron", "2024-05-29 18:31:10", "2024-05-29 18:31:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("426", "1088844", "action complete via WP Cron", "2024-05-29 18:31:11", "2024-05-29 18:31:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("427", "1088845", "action created", "2024-05-29 18:31:11", "2024-05-29 18:31:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("428", "1088845", "action started via WP Cron", "2024-05-29 18:33:10", "2024-05-29 18:33:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("429", "1088845", "action complete via WP Cron", "2024-05-29 18:33:11", "2024-05-29 18:33:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("430", "1088846", "action created", "2024-05-29 18:33:11", "2024-05-29 18:33:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("431", "1088846", "action started via WP Cron", "2024-05-29 18:34:11", "2024-05-29 18:34:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("432", "1088846", "action complete via WP Cron", "2024-05-29 18:34:11", "2024-05-29 18:34:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("433", "1088847", "action created", "2024-05-29 18:34:11", "2024-05-29 18:34:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("434", "1088847", "action started via WP Cron", "2024-05-29 18:35:11", "2024-05-29 18:35:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("435", "1088847", "action complete via WP Cron", "2024-05-29 18:35:11", "2024-05-29 18:35:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("436", "1088848", "action created", "2024-05-29 18:35:11", "2024-05-29 18:35:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("437", "1088848", "action started via WP Cron", "2024-05-29 18:37:10", "2024-05-29 18:37:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("438", "1088848", "action complete via WP Cron", "2024-05-29 18:37:10", "2024-05-29 18:37:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("439", "1088849", "action created", "2024-05-29 18:37:10", "2024-05-29 18:37:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("440", "1088849", "action started via WP Cron", "2024-05-29 18:38:12", "2024-05-29 18:38:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("441", "1088849", "action complete via WP Cron", "2024-05-29 18:38:12", "2024-05-29 18:38:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("442", "1088850", "action created", "2024-05-29 18:38:12", "2024-05-29 18:38:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("443", "1088850", "action started via WP Cron", "2024-05-29 18:40:11", "2024-05-29 18:40:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("444", "1088850", "action complete via WP Cron", "2024-05-29 18:40:12", "2024-05-29 18:40:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("445", "1088851", "action created", "2024-05-29 18:40:12", "2024-05-29 18:40:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("446", "1088851", "action started via WP Cron", "2024-05-29 18:42:10", "2024-05-29 18:42:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("447", "1088851", "action complete via WP Cron", "2024-05-29 18:42:11", "2024-05-29 18:42:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("448", "1088852", "action created", "2024-05-29 18:42:11", "2024-05-29 18:42:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("449", "1088852", "action started via WP Cron", "2024-05-29 18:43:12", "2024-05-29 18:43:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("450", "1088852", "action complete via WP Cron", "2024-05-29 18:43:12", "2024-05-29 18:43:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("451", "1088853", "action created", "2024-05-29 18:43:12", "2024-05-29 18:43:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("452", "1088853", "action started via WP Cron", "2024-05-29 18:45:11", "2024-05-29 18:45:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("453", "1088853", "action complete via WP Cron", "2024-05-29 18:45:11", "2024-05-29 18:45:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("454", "1088854", "action created", "2024-05-29 18:45:12", "2024-05-29 18:45:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("455", "1088854", "action started via WP Cron", "2024-05-29 18:47:13", "2024-05-29 18:47:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("456", "1088854", "action complete via WP Cron", "2024-05-29 18:47:13", "2024-05-29 18:47:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("457", "1088855", "action created", "2024-05-29 18:47:13", "2024-05-29 18:47:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("458", "1088855", "action started via WP Cron", "2024-05-29 18:49:11", "2024-05-29 18:49:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("459", "1088855", "action complete via WP Cron", "2024-05-29 18:49:11", "2024-05-29 18:49:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("460", "1088856", "action created", "2024-05-29 18:49:11", "2024-05-29 18:49:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("461", "1088856", "action started via WP Cron", "2024-05-29 18:50:11", "2024-05-29 18:50:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("462", "1088856", "action complete via WP Cron", "2024-05-29 18:50:11", "2024-05-29 18:50:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("463", "1088857", "action created", "2024-05-29 18:50:12", "2024-05-29 18:50:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("464", "1088857", "action started via WP Cron", "2024-05-29 18:52:09", "2024-05-29 18:52:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("465", "1088857", "action complete via WP Cron", "2024-05-29 18:52:09", "2024-05-29 18:52:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("466", "1088858", "action created", "2024-05-29 18:52:09", "2024-05-29 18:52:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("467", "1088858", "action started via WP Cron", "2024-05-29 18:53:09", "2024-05-29 18:53:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("468", "1088858", "action complete via WP Cron", "2024-05-29 18:53:09", "2024-05-29 18:53:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("469", "1088859", "action created", "2024-05-29 18:53:09", "2024-05-29 18:53:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("470", "1088859", "action started via WP Cron", "2024-05-29 18:54:11", "2024-05-29 18:54:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("471", "1088859", "action complete via WP Cron", "2024-05-29 18:54:12", "2024-05-29 18:54:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("472", "1088860", "action created", "2024-05-29 18:54:12", "2024-05-29 18:54:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("473", "1088860", "action started via WP Cron", "2024-05-29 18:56:10", "2024-05-29 18:56:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("474", "1088860", "action complete via WP Cron", "2024-05-29 18:56:10", "2024-05-29 18:56:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("475", "1088861", "action created", "2024-05-29 18:56:10", "2024-05-29 18:56:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("476", "1088861", "action started via WP Cron", "2024-05-29 18:57:11", "2024-05-29 18:57:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("477", "1088861", "action complete via WP Cron", "2024-05-29 18:57:11", "2024-05-29 18:57:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("478", "1088862", "action created", "2024-05-29 18:57:11", "2024-05-29 18:57:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("479", "1088862", "action started via WP Cron", "2024-05-29 18:59:09", "2024-05-29 18:59:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("480", "1088862", "action complete via WP Cron", "2024-05-29 18:59:10", "2024-05-29 18:59:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("481", "1088863", "action created", "2024-05-29 18:59:10", "2024-05-29 18:59:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("482", "1088863", "action started via WP Cron", "2024-05-29 19:00:10", "2024-05-29 19:00:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("483", "1088863", "action complete via WP Cron", "2024-05-29 19:00:11", "2024-05-29 19:00:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("484", "1088864", "action created", "2024-05-29 19:00:11", "2024-05-29 19:00:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("485", "1088864", "action started via WP Cron", "2024-05-29 19:01:11", "2024-05-29 19:01:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("486", "1088864", "action complete via WP Cron", "2024-05-29 19:01:11", "2024-05-29 19:01:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("487", "1088865", "action created", "2024-05-29 19:01:11", "2024-05-29 19:01:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("488", "1088865", "action started via WP Cron", "2024-05-29 19:03:10", "2024-05-29 19:03:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("489", "1088865", "action complete via WP Cron", "2024-05-29 19:03:10", "2024-05-29 19:03:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("490", "1088866", "action created", "2024-05-29 19:03:10", "2024-05-29 19:03:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("491", "1088866", "action started via WP Cron", "2024-05-29 19:05:11", "2024-05-29 19:05:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("492", "1088866", "action complete via WP Cron", "2024-05-29 19:05:11", "2024-05-29 19:05:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("493", "1088867", "action created", "2024-05-29 19:05:11", "2024-05-29 19:05:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("494", "1088867", "action started via WP Cron", "2024-05-29 19:06:12", "2024-05-29 19:06:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("495", "1088867", "action complete via WP Cron", "2024-05-29 19:06:12", "2024-05-29 19:06:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("496", "1088868", "action created", "2024-05-29 19:06:13", "2024-05-29 19:06:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("497", "1088868", "action started via WP Cron", "2024-05-29 19:08:09", "2024-05-29 19:08:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("498", "1088868", "action complete via WP Cron", "2024-05-29 19:08:10", "2024-05-29 19:08:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("499", "1088869", "action created", "2024-05-29 19:08:10", "2024-05-29 19:08:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("500", "1088869", "action started via WP Cron", "2024-05-29 19:10:11", "2024-05-29 19:10:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("501", "1088869", "action complete via WP Cron", "2024-05-29 19:10:11", "2024-05-29 19:10:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("502", "1088870", "action created", "2024-05-29 19:10:11", "2024-05-29 19:10:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("503", "1088870", "action started via WP Cron", "2024-05-29 19:11:11", "2024-05-29 19:11:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("504", "1088870", "action complete via WP Cron", "2024-05-29 19:11:11", "2024-05-29 19:11:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("505", "1088871", "action created", "2024-05-29 19:11:12", "2024-05-29 19:11:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("506", "1088871", "action started via WP Cron", "2024-05-29 19:13:10", "2024-05-29 19:13:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("507", "1088871", "action complete via WP Cron", "2024-05-29 19:13:11", "2024-05-29 19:13:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("508", "1088872", "action created", "2024-05-29 19:13:11", "2024-05-29 19:13:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("509", "1088872", "action started via WP Cron", "2024-05-29 19:15:10", "2024-05-29 19:15:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("510", "1088872", "action complete via WP Cron", "2024-05-29 19:15:10", "2024-05-29 19:15:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("511", "1088873", "action created", "2024-05-29 19:15:10", "2024-05-29 19:15:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("512", "1088873", "action started via WP Cron", "2024-05-29 19:17:11", "2024-05-29 19:17:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("513", "1088873", "action complete via WP Cron", "2024-05-29 19:17:12", "2024-05-29 19:17:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("514", "1088874", "action created", "2024-05-29 19:17:12", "2024-05-29 19:17:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("515", "1088874", "action started via WP Cron", "2024-05-29 19:19:12", "2024-05-29 19:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("516", "1088874", "action complete via WP Cron", "2024-05-29 19:19:12", "2024-05-29 19:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("517", "1088875", "action created", "2024-05-29 19:19:12", "2024-05-29 19:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("518", "1088875", "action started via WP Cron", "2024-05-29 19:21:09", "2024-05-29 19:21:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("519", "1088875", "action complete via WP Cron", "2024-05-29 19:21:10", "2024-05-29 19:21:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("520", "1088876", "action created", "2024-05-29 19:21:10", "2024-05-29 19:21:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("521", "1088876", "action started via WP Cron", "2024-05-29 19:22:10", "2024-05-29 19:22:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("522", "1088876", "action complete via WP Cron", "2024-05-29 19:22:11", "2024-05-29 19:22:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("523", "1088877", "action created", "2024-05-29 19:22:11", "2024-05-29 19:22:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("524", "1088877", "action started via WP Cron", "2024-05-29 19:24:12", "2024-05-29 19:24:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("525", "1088877", "action complete via WP Cron", "2024-05-29 19:24:12", "2024-05-29 19:24:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("526", "1088878", "action created", "2024-05-29 19:24:13", "2024-05-29 19:24:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("527", "1088878", "action started via WP Cron", "2024-05-29 19:26:11", "2024-05-29 19:26:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("528", "1088878", "action complete via WP Cron", "2024-05-29 19:26:11", "2024-05-29 19:26:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("529", "1088879", "action created", "2024-05-29 19:26:12", "2024-05-29 19:26:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("530", "1088879", "action started via WP Cron", "2024-05-29 19:28:10", "2024-05-29 19:28:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("531", "1088879", "action complete via WP Cron", "2024-05-29 19:28:11", "2024-05-29 19:28:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("532", "1088880", "action created", "2024-05-29 19:28:11", "2024-05-29 19:28:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("533", "1088880", "action started via WP Cron", "2024-05-29 19:29:12", "2024-05-29 19:29:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("534", "1088880", "action complete via WP Cron", "2024-05-29 19:29:13", "2024-05-29 19:29:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("535", "1088881", "action created", "2024-05-29 19:29:13", "2024-05-29 19:29:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("536", "1088881", "action started via WP Cron", "2024-05-29 19:31:11", "2024-05-29 19:31:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("537", "1088881", "action complete via WP Cron", "2024-05-29 19:31:11", "2024-05-29 19:31:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("538", "1088882", "action created", "2024-05-29 19:31:12", "2024-05-29 19:31:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("539", "1088882", "action started via WP Cron", "2024-05-29 19:33:09", "2024-05-29 19:33:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("540", "1088882", "action complete via WP Cron", "2024-05-29 19:33:10", "2024-05-29 19:33:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("541", "1088883", "action created", "2024-05-29 19:33:10", "2024-05-29 19:33:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("542", "1088883", "action started via WP Cron", "2024-05-29 19:34:13", "2024-05-29 19:34:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("543", "1088883", "action complete via WP Cron", "2024-05-29 19:34:14", "2024-05-29 19:34:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("544", "1088884", "action created", "2024-05-29 19:34:14", "2024-05-29 19:34:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("545", "1088884", "action started via WP Cron", "2024-05-29 19:36:10", "2024-05-29 19:36:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("546", "1088884", "action complete via WP Cron", "2024-05-29 19:36:10", "2024-05-29 19:36:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("547", "1088885", "action created", "2024-05-29 19:36:10", "2024-05-29 19:36:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("548", "1088885", "action started via WP Cron", "2024-05-29 19:37:10", "2024-05-29 19:37:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("549", "1088885", "action complete via WP Cron", "2024-05-29 19:37:10", "2024-05-29 19:37:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("550", "1088886", "action created", "2024-05-29 19:37:11", "2024-05-29 19:37:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("551", "1088886", "action started via WP Cron", "2024-05-29 19:38:10", "2024-05-29 19:38:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("552", "1088886", "action complete via WP Cron", "2024-05-29 19:38:11", "2024-05-29 19:38:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("553", "1088887", "action created", "2024-05-29 19:38:11", "2024-05-29 19:38:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("554", "1088887", "action started via WP Cron", "2024-05-29 19:39:13", "2024-05-29 19:39:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("555", "1088887", "action complete via WP Cron", "2024-05-29 19:39:13", "2024-05-29 19:39:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("556", "1088888", "action created", "2024-05-29 19:39:13", "2024-05-29 19:39:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("557", "1088888", "action started via WP Cron", "2024-05-29 19:41:13", "2024-05-29 19:41:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("558", "1088888", "action complete via WP Cron", "2024-05-29 19:41:13", "2024-05-29 19:41:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("559", "1088889", "action created", "2024-05-29 19:41:13", "2024-05-29 19:41:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("560", "1088889", "action started via WP Cron", "2024-05-29 19:43:10", "2024-05-29 19:43:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("561", "1088889", "action complete via WP Cron", "2024-05-29 19:43:11", "2024-05-29 19:43:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("562", "1088890", "action created", "2024-05-29 19:43:11", "2024-05-29 19:43:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("563", "1088890", "action started via WP Cron", "2024-05-29 19:44:14", "2024-05-29 19:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("564", "1088890", "action complete via WP Cron", "2024-05-29 19:44:14", "2024-05-29 19:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("565", "1088891", "action created", "2024-05-29 19:44:15", "2024-05-29 19:44:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("566", "1088891", "action started via WP Cron", "2024-05-29 19:46:10", "2024-05-29 19:46:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("567", "1088891", "action complete via WP Cron", "2024-05-29 19:46:11", "2024-05-29 19:46:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("568", "1088892", "action created", "2024-05-29 19:46:12", "2024-05-29 19:46:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("569", "1088892", "action started via WP Cron", "2024-05-29 19:48:11", "2024-05-29 19:48:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("570", "1088892", "action complete via WP Cron", "2024-05-29 19:48:12", "2024-05-29 19:48:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("571", "1088893", "action created", "2024-05-29 19:48:12", "2024-05-29 19:48:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("572", "1088893", "action started via WP Cron", "2024-05-29 19:50:12", "2024-05-29 19:50:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("573", "1088893", "action complete via WP Cron", "2024-05-29 19:50:13", "2024-05-29 19:50:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("574", "1088894", "action created", "2024-05-29 19:50:13", "2024-05-29 19:50:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("575", "1088894", "action started via WP Cron", "2024-05-29 19:52:12", "2024-05-29 19:52:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("576", "1088894", "action complete via WP Cron", "2024-05-29 19:52:12", "2024-05-29 19:52:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("577", "1088895", "action created", "2024-05-29 19:52:12", "2024-05-29 19:52:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("578", "1088895", "action started via WP Cron", "2024-05-29 19:54:11", "2024-05-29 19:54:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("579", "1088895", "action complete via WP Cron", "2024-05-29 19:54:11", "2024-05-29 19:54:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("580", "1088896", "action created", "2024-05-29 19:54:11", "2024-05-29 19:54:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("581", "1088896", "action started via WP Cron", "2024-05-29 19:56:10", "2024-05-29 19:56:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("582", "1088896", "action complete via WP Cron", "2024-05-29 19:56:13", "2024-05-29 19:56:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("583", "1088897", "action created", "2024-05-29 19:56:13", "2024-05-29 19:56:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("584", "1088897", "action started via WP Cron", "2024-05-29 19:58:12", "2024-05-29 19:58:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("585", "1088897", "action complete via WP Cron", "2024-05-29 19:58:12", "2024-05-29 19:58:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("586", "1088898", "action created", "2024-05-29 19:58:13", "2024-05-29 19:58:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("587", "1088898", "action started via WP Cron", "2024-05-29 20:00:13", "2024-05-29 20:00:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("588", "1088898", "action complete via WP Cron", "2024-05-29 20:00:16", "2024-05-29 20:00:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("589", "1088899", "action created", "2024-05-29 20:00:16", "2024-05-29 20:00:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("590", "1088899", "action started via WP Cron", "2024-05-29 20:02:10", "2024-05-29 20:02:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("591", "1088899", "action complete via WP Cron", "2024-05-29 20:02:13", "2024-05-29 20:02:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("592", "1088900", "action created", "2024-05-29 20:02:13", "2024-05-29 20:02:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("593", "1088900", "action started via WP Cron", "2024-05-29 20:03:14", "2024-05-29 20:03:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("594", "1088900", "action complete via WP Cron", "2024-05-29 20:03:14", "2024-05-29 20:03:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("595", "1088901", "action created", "2024-05-29 20:03:14", "2024-05-29 20:03:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("596", "1088901", "action started via WP Cron", "2024-05-29 20:05:14", "2024-05-29 20:05:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("597", "1088901", "action complete via WP Cron", "2024-05-29 20:05:15", "2024-05-29 20:05:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("598", "1088902", "action created", "2024-05-29 20:05:15", "2024-05-29 20:05:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("599", "1088902", "action started via WP Cron", "2024-05-29 20:07:14", "2024-05-29 20:07:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("600", "1088902", "action complete via WP Cron", "2024-05-29 20:07:14", "2024-05-29 20:07:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("601", "1088903", "action created", "2024-05-29 20:07:14", "2024-05-29 20:07:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("602", "1088903", "action started via WP Cron", "2024-05-29 20:09:15", "2024-05-29 20:09:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("603", "1088903", "action complete via WP Cron", "2024-05-29 20:09:15", "2024-05-29 20:09:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("604", "1088904", "action created", "2024-05-29 20:09:15", "2024-05-29 20:09:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("605", "1088904", "action started via WP Cron", "2024-05-29 20:11:11", "2024-05-29 20:11:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("606", "1088904", "action complete via WP Cron", "2024-05-29 20:11:12", "2024-05-29 20:11:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("607", "1088905", "action created", "2024-05-29 20:11:12", "2024-05-29 20:11:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("608", "1088905", "action started via WP Cron", "2024-05-29 20:13:11", "2024-05-29 20:13:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("609", "1088905", "action complete via WP Cron", "2024-05-29 20:13:12", "2024-05-29 20:13:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("610", "1088906", "action created", "2024-05-29 20:13:12", "2024-05-29 20:13:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("611", "1088906", "action started via WP Cron", "2024-05-29 20:15:10", "2024-05-29 20:15:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("612", "1088906", "action complete via WP Cron", "2024-05-29 20:15:11", "2024-05-29 20:15:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("613", "1088907", "action created", "2024-05-29 20:15:11", "2024-05-29 20:15:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("614", "1088907", "action started via WP Cron", "2024-05-29 20:16:12", "2024-05-29 20:16:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("615", "1088907", "action complete via WP Cron", "2024-05-29 20:16:12", "2024-05-29 20:16:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("616", "1088908", "action created", "2024-05-29 20:16:13", "2024-05-29 20:16:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("617", "1088908", "action started via WP Cron", "2024-05-29 20:18:11", "2024-05-29 20:18:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("618", "1088908", "action complete via WP Cron", "2024-05-29 20:18:11", "2024-05-29 20:18:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("619", "1088909", "action created", "2024-05-29 20:18:11", "2024-05-29 20:18:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("620", "1088909", "action started via WP Cron", "2024-05-29 20:19:12", "2024-05-29 20:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("621", "1088909", "action complete via WP Cron", "2024-05-29 20:19:12", "2024-05-29 20:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("622", "1088910", "action created", "2024-05-29 20:19:12", "2024-05-29 20:19:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("623", "1088910", "action started via WP Cron", "2024-05-29 20:21:13", "2024-05-29 20:21:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("624", "1088910", "action complete via WP Cron", "2024-05-29 20:21:13", "2024-05-29 20:21:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("625", "1088911", "action created", "2024-05-29 20:21:13", "2024-05-29 20:21:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("626", "1088911", "action started via WP Cron", "2024-05-29 20:22:13", "2024-05-29 20:22:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("627", "1088911", "action complete via WP Cron", "2024-05-29 20:22:14", "2024-05-29 20:22:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("628", "1088912", "action created", "2024-05-29 20:22:14", "2024-05-29 20:22:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("629", "1088912", "action started via WP Cron", "2024-05-29 20:24:11", "2024-05-29 20:24:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("630", "1088912", "action complete via WP Cron", "2024-05-29 20:24:13", "2024-05-29 20:24:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("631", "1088913", "action created", "2024-05-29 20:24:13", "2024-05-29 20:24:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("632", "1088913", "action started via WP Cron", "2024-05-29 20:26:13", "2024-05-29 20:26:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("633", "1088913", "action complete via WP Cron", "2024-05-29 20:26:16", "2024-05-29 20:26:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("634", "1088914", "action created", "2024-05-29 20:26:16", "2024-05-29 20:26:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("635", "1088914", "action started via WP Cron", "2024-05-29 20:28:12", "2024-05-29 20:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("636", "1088914", "action complete via WP Cron", "2024-05-29 20:28:12", "2024-05-29 20:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("637", "1088915", "action created", "2024-05-29 20:28:13", "2024-05-29 20:28:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("638", "1088915", "action started via WP Cron", "2024-05-29 20:29:12", "2024-05-29 20:29:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("639", "1088915", "action complete via WP Cron", "2024-05-29 20:29:13", "2024-05-29 20:29:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("640", "1088916", "action created", "2024-05-29 20:29:13", "2024-05-29 20:29:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("641", "1088916", "action started via WP Cron", "2024-05-29 20:31:09", "2024-05-29 20:31:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("642", "1088916", "action complete via WP Cron", "2024-05-29 20:31:13", "2024-05-29 20:31:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("643", "1088917", "action created", "2024-05-29 20:31:13", "2024-05-29 20:31:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("644", "1088917", "action started via WP Cron", "2024-05-29 20:33:09", "2024-05-29 20:33:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("645", "1088917", "action complete via WP Cron", "2024-05-29 20:33:10", "2024-05-29 20:33:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("646", "1088918", "action created", "2024-05-29 20:33:10", "2024-05-29 20:33:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("647", "1088918", "action started via WP Cron", "2024-05-29 20:35:10", "2024-05-29 20:35:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("648", "1088918", "action complete via WP Cron", "2024-05-29 20:35:14", "2024-05-29 20:35:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("649", "1088919", "action created", "2024-05-29 20:35:14", "2024-05-29 20:35:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("650", "1088919", "action started via WP Cron", "2024-05-29 20:37:11", "2024-05-29 20:37:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("651", "1088919", "action complete via WP Cron", "2024-05-29 20:37:11", "2024-05-29 20:37:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("652", "1088920", "action created", "2024-05-29 20:37:11", "2024-05-29 20:37:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("653", "1088920", "action started via WP Cron", "2024-05-29 20:38:15", "2024-05-29 20:38:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("654", "1088920", "action complete via WP Cron", "2024-05-29 20:38:15", "2024-05-29 20:38:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("655", "1088921", "action created", "2024-05-29 20:38:15", "2024-05-29 20:38:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("656", "1088921", "action started via WP Cron", "2024-05-29 20:40:11", "2024-05-29 20:40:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("657", "1088921", "action complete via WP Cron", "2024-05-29 20:40:12", "2024-05-29 20:40:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("658", "1088922", "action created", "2024-05-29 20:40:12", "2024-05-29 20:40:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("659", "1088922", "action started via WP Cron", "2024-05-29 20:41:15", "2024-05-29 20:41:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("660", "1088922", "action complete via WP Cron", "2024-05-29 20:41:15", "2024-05-29 20:41:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("661", "1088923", "action created", "2024-05-29 20:41:15", "2024-05-29 20:41:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("662", "1088923", "action started via WP Cron", "2024-05-29 20:43:10", "2024-05-29 20:43:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("663", "1088923", "action complete via WP Cron", "2024-05-29 20:43:11", "2024-05-29 20:43:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("664", "1088924", "action created", "2024-05-29 20:43:11", "2024-05-29 20:43:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("665", "1088924", "action started via WP Cron", "2024-05-29 20:45:11", "2024-05-29 20:45:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("666", "1088924", "action complete via WP Cron", "2024-05-29 20:45:13", "2024-05-29 20:45:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("667", "1088925", "action created", "2024-05-29 20:45:13", "2024-05-29 20:45:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("668", "1088925", "action started via WP Cron", "2024-05-29 20:47:09", "2024-05-29 20:47:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("669", "1088925", "action complete via WP Cron", "2024-05-29 20:47:12", "2024-05-29 20:47:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("670", "1088926", "action created", "2024-05-29 20:47:13", "2024-05-29 20:47:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("671", "1088926", "action started via WP Cron", "2024-05-29 20:48:15", "2024-05-29 20:48:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("672", "1088926", "action complete via WP Cron", "2024-05-29 20:48:17", "2024-05-29 20:48:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("673", "1088927", "action created", "2024-05-29 20:48:17", "2024-05-29 20:48:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("674", "1088927", "action started via WP Cron", "2024-05-29 20:50:13", "2024-05-29 20:50:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("675", "1088927", "action complete via WP Cron", "2024-05-29 20:50:15", "2024-05-29 20:50:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("676", "1088928", "action created", "2024-05-29 20:50:15", "2024-05-29 20:50:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("677", "1088928", "action started via WP Cron", "2024-05-29 20:52:14", "2024-05-29 20:52:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("678", "1088928", "action complete via WP Cron", "2024-05-29 20:52:17", "2024-05-29 20:52:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("679", "1088929", "action created", "2024-05-29 20:52:17", "2024-05-29 20:52:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("680", "1088929", "action started via WP Cron", "2024-05-29 20:54:10", "2024-05-29 20:54:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("681", "1088929", "action complete via WP Cron", "2024-05-29 20:54:13", "2024-05-29 20:54:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("682", "1088930", "action created", "2024-05-29 20:54:16", "2024-05-29 20:54:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("683", "1088930", "action started via WP Cron", "2024-05-29 20:56:11", "2024-05-29 20:56:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("684", "1088930", "action complete via WP Cron", "2024-05-29 20:56:12", "2024-05-29 20:56:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("685", "1088931", "action created", "2024-05-29 20:56:12", "2024-05-29 20:56:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("686", "1088931", "action started via WP Cron", "2024-05-29 20:58:10", "2024-05-29 20:58:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("687", "1088931", "action complete via WP Cron", "2024-05-29 20:58:11", "2024-05-29 20:58:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("688", "1088932", "action created", "2024-05-29 20:58:14", "2024-05-29 20:58:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("689", "1088932", "action started via WP Cron", "2024-05-29 20:59:15", "2024-05-29 20:59:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("690", "1088932", "action complete via WP Cron", "2024-05-29 20:59:15", "2024-05-29 20:59:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("691", "1088933", "action created", "2024-05-29 20:59:16", "2024-05-29 20:59:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("692", "1088933", "action started via WP Cron", "2024-05-29 21:01:12", "2024-05-29 21:01:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("693", "1088933", "action complete via WP Cron", "2024-05-29 21:01:13", "2024-05-29 21:01:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("694", "1088934", "action created", "2024-05-29 21:01:13", "2024-05-29 21:01:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("695", "1088934", "action started via WP Cron", "2024-05-29 21:03:09", "2024-05-29 21:03:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("696", "1088934", "action complete via WP Cron", "2024-05-29 21:03:10", "2024-05-29 21:03:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("697", "1088935", "action created", "2024-05-29 21:03:11", "2024-05-29 21:03:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("698", "1088935", "action started via WP Cron", "2024-05-29 21:04:12", "2024-05-29 21:04:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("699", "1088935", "action complete via WP Cron", "2024-05-29 21:04:12", "2024-05-29 21:04:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("700", "1088936", "action created", "2024-05-29 21:04:12", "2024-05-29 21:04:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("701", "1088936", "action started via WP Cron", "2024-05-29 21:05:16", "2024-05-29 21:05:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("702", "1088936", "action complete via WP Cron", "2024-05-29 21:05:18", "2024-05-29 21:05:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("703", "1088937", "action created", "2024-05-29 21:05:18", "2024-05-29 21:05:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("704", "1088937", "action started via WP Cron", "2024-05-29 21:07:12", "2024-05-29 21:07:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("705", "1088937", "action complete via WP Cron", "2024-05-29 21:07:16", "2024-05-29 21:07:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("706", "1088938", "action created", "2024-05-29 21:07:16", "2024-05-29 21:07:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("707", "1088938", "action started via WP Cron", "2024-05-29 21:09:15", "2024-05-29 21:09:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("708", "1088938", "action complete via WP Cron", "2024-05-29 21:09:16", "2024-05-29 21:09:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("709", "1088939", "action created", "2024-05-29 21:09:16", "2024-05-29 21:09:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("710", "1088939", "action started via WP Cron", "2024-05-29 21:12:40", "2024-05-29 21:12:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("711", "1088939", "action complete via WP Cron", "2024-05-29 21:12:43", "2024-05-29 21:12:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("712", "1088940", "action created", "2024-05-29 21:12:45", "2024-05-29 21:12:45");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("713", "1088940", "action started via WP Cron", "2024-05-29 21:28:50", "2024-05-29 21:28:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("714", "1088940", "action complete via WP Cron", "2024-05-29 21:28:51", "2024-05-29 21:28:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("715", "1088941", "action created", "2024-05-29 21:28:51", "2024-05-29 21:28:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("716", "1088941", "action started via WP Cron", "2024-05-29 21:40:35", "2024-05-29 21:40:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("717", "1088941", "action complete via WP Cron", "2024-05-29 21:40:35", "2024-05-29 21:40:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("718", "1088942", "action created", "2024-05-29 21:40:36", "2024-05-29 21:40:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("719", "1088942", "action started via WP Cron", "2024-05-29 21:43:34", "2024-05-29 21:43:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("720", "1088942", "action complete via WP Cron", "2024-05-29 21:43:35", "2024-05-29 21:43:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("721", "1088943", "action created", "2024-05-29 21:43:35", "2024-05-29 21:43:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("722", "1088943", "action started via WP Cron", "2024-05-29 21:55:53", "2024-05-29 21:55:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("723", "1088943", "action complete via WP Cron", "2024-05-29 21:55:53", "2024-05-29 21:55:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("724", "1088944", "action created", "2024-05-29 21:55:53", "2024-05-29 21:55:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("725", "1088944", "action started via WP Cron", "2024-05-29 21:58:52", "2024-05-29 21:58:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("726", "1088944", "action complete via WP Cron", "2024-05-29 21:58:53", "2024-05-29 21:58:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("727", "1088945", "action created", "2024-05-29 21:58:53", "2024-05-29 21:58:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("728", "1088945", "action started via WP Cron", "2024-05-29 22:11:32", "2024-05-29 22:11:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("729", "1088945", "action complete via WP Cron", "2024-05-29 22:11:33", "2024-05-29 22:11:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("730", "1088946", "action created", "2024-05-29 22:11:33", "2024-05-29 22:11:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("731", "1088946", "action started via WP Cron", "2024-05-29 22:14:31", "2024-05-29 22:14:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("732", "1088946", "action complete via WP Cron", "2024-05-29 22:14:31", "2024-05-29 22:14:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("733", "1088947", "action created", "2024-05-29 22:14:32", "2024-05-29 22:14:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("734", "1088947", "action started via WP Cron", "2024-05-29 22:26:59", "2024-05-29 22:26:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("735", "1088947", "action complete via WP Cron", "2024-05-29 22:27:00", "2024-05-29 22:27:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("736", "1088948", "action created", "2024-05-29 22:27:00", "2024-05-29 22:27:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("737", "1088948", "action started via WP Cron", "2024-05-29 22:30:05", "2024-05-29 22:30:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("738", "1088948", "action complete via WP Cron", "2024-05-29 22:30:05", "2024-05-29 22:30:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("739", "1088949", "action created", "2024-05-29 22:30:05", "2024-05-29 22:30:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("740", "1088949", "action started via WP Cron", "2024-05-29 22:42:34", "2024-05-29 22:42:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("741", "1088949", "action complete via WP Cron", "2024-05-29 22:42:34", "2024-05-29 22:42:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("742", "1088950", "action created", "2024-05-29 22:42:34", "2024-05-29 22:42:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("743", "1088950", "action started via WP Cron", "2024-05-29 22:46:10", "2024-05-29 22:46:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("744", "1088950", "action complete via WP Cron", "2024-05-29 22:46:12", "2024-05-29 22:46:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("745", "1088951", "action created", "2024-05-29 22:46:12", "2024-05-29 22:46:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("746", "1088951", "action started via WP Cron", "2024-05-29 22:57:58", "2024-05-29 22:57:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("747", "1088951", "action complete via WP Cron", "2024-05-29 22:57:58", "2024-05-29 22:57:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("748", "1088952", "action created", "2024-05-29 22:57:58", "2024-05-29 22:57:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("749", "1088952", "action started via WP Cron", "2024-05-29 23:00:56", "2024-05-29 23:00:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("750", "1088952", "action complete via WP Cron", "2024-05-29 23:00:56", "2024-05-29 23:00:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("751", "1088953", "action created", "2024-05-29 23:00:57", "2024-05-29 23:00:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("752", "1088953", "action started via WP Cron", "2024-05-29 23:13:26", "2024-05-29 23:13:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("753", "1088953", "action complete via WP Cron", "2024-05-29 23:13:26", "2024-05-29 23:13:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("754", "1088954", "action created", "2024-05-29 23:13:26", "2024-05-29 23:13:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("755", "1088954", "action started via WP Cron", "2024-05-29 23:16:23", "2024-05-29 23:16:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("756", "1088954", "action complete via WP Cron", "2024-05-29 23:16:23", "2024-05-29 23:16:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("757", "1088955", "action created", "2024-05-29 23:16:23", "2024-05-29 23:16:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("758", "1088955", "action started via WP Cron", "2024-05-29 23:28:58", "2024-05-29 23:28:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("759", "1088955", "action complete via WP Cron", "2024-05-29 23:29:00", "2024-05-29 23:29:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("760", "1088956", "action created", "2024-05-29 23:29:00", "2024-05-29 23:29:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("761", "1088956", "action started via WP Cron", "2024-05-29 23:31:57", "2024-05-29 23:31:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("762", "1088956", "action complete via WP Cron", "2024-05-29 23:31:57", "2024-05-29 23:31:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("763", "1088957", "action created", "2024-05-29 23:31:57", "2024-05-29 23:31:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("764", "1088957", "action started via WP Cron", "2024-05-29 23:44:29", "2024-05-29 23:44:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("765", "1088957", "action complete via WP Cron", "2024-05-29 23:44:29", "2024-05-29 23:44:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("766", "1088958", "action created", "2024-05-29 23:44:29", "2024-05-29 23:44:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("767", "1088958", "action started via WP Cron", "2024-05-29 23:47:31", "2024-05-29 23:47:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("768", "1088958", "action complete via WP Cron", "2024-05-29 23:47:31", "2024-05-29 23:47:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("769", "1088959", "action created", "2024-05-29 23:47:31", "2024-05-29 23:47:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("770", "1088959", "action started via WP Cron", "2024-05-30 00:00:08", "2024-05-30 00:00:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("771", "1088959", "action complete via WP Cron", "2024-05-30 00:00:08", "2024-05-30 00:00:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("772", "1088960", "action created", "2024-05-30 00:00:09", "2024-05-30 00:00:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("773", "1088960", "action started via WP Cron", "2024-05-30 00:03:11", "2024-05-30 00:03:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("774", "1088960", "action complete via WP Cron", "2024-05-30 00:03:11", "2024-05-30 00:03:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("775", "1088961", "action created", "2024-05-30 00:03:11", "2024-05-30 00:03:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("776", "1088961", "action started via WP Cron", "2024-05-30 00:15:52", "2024-05-30 00:15:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("777", "1088961", "action complete via WP Cron", "2024-05-30 00:15:53", "2024-05-30 00:15:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("778", "1088962", "action created", "2024-05-30 00:15:53", "2024-05-30 00:15:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("779", "1088962", "action started via WP Cron", "2024-05-30 00:18:54", "2024-05-30 00:18:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("780", "1088962", "action complete via WP Cron", "2024-05-30 00:18:54", "2024-05-30 00:18:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("781", "1088963", "action created", "2024-05-30 00:18:54", "2024-05-30 00:18:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("782", "1088963", "action started via WP Cron", "2024-05-30 00:31:37", "2024-05-30 00:31:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("783", "1088963", "action complete via WP Cron", "2024-05-30 00:31:38", "2024-05-30 00:31:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("784", "1088964", "action created", "2024-05-30 00:31:38", "2024-05-30 00:31:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("785", "1088964", "action started via WP Cron", "2024-05-30 00:34:44", "2024-05-30 00:34:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("786", "1088964", "action complete via WP Cron", "2024-05-30 00:34:44", "2024-05-30 00:34:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("787", "1088965", "action created", "2024-05-30 00:34:44", "2024-05-30 00:34:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("788", "1088965", "action started via WP Cron", "2024-05-30 00:47:34", "2024-05-30 00:47:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("789", "1088965", "action complete via WP Cron", "2024-05-30 00:47:34", "2024-05-30 00:47:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("790", "1088966", "action created", "2024-05-30 00:47:34", "2024-05-30 00:47:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("791", "1088966", "action started via WP Cron", "2024-05-30 00:50:33", "2024-05-30 00:50:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("792", "1088966", "action complete via WP Cron", "2024-05-30 00:50:34", "2024-05-30 00:50:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("793", "1088967", "action created", "2024-05-30 00:50:34", "2024-05-30 00:50:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("794", "1088967", "action started via WP Cron", "2024-05-30 01:03:26", "2024-05-30 01:03:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("795", "1088967", "action complete via WP Cron", "2024-05-30 01:03:27", "2024-05-30 01:03:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("796", "1088968", "action created", "2024-05-30 01:03:27", "2024-05-30 01:03:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("797", "1088968", "action started via WP Cron", "2024-05-30 01:06:30", "2024-05-30 01:06:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("798", "1088968", "action complete via WP Cron", "2024-05-30 01:06:30", "2024-05-30 01:06:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("799", "1088969", "action created", "2024-05-30 01:06:30", "2024-05-30 01:06:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("800", "1088969", "action started via WP Cron", "2024-05-30 01:19:21", "2024-05-30 01:19:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("801", "1088969", "action complete via WP Cron", "2024-05-30 01:19:21", "2024-05-30 01:19:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("802", "1088970", "action created", "2024-05-30 01:19:21", "2024-05-30 01:19:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("803", "1088970", "action started via WP Cron", "2024-05-30 01:22:27", "2024-05-30 01:22:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("804", "1088970", "action complete via WP Cron", "2024-05-30 01:22:27", "2024-05-30 01:22:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("805", "1088971", "action created", "2024-05-30 01:22:27", "2024-05-30 01:22:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("806", "1088971", "action started via WP Cron", "2024-05-30 01:35:20", "2024-05-30 01:35:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("807", "1088971", "action complete via WP Cron", "2024-05-30 01:35:20", "2024-05-30 01:35:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("808", "1088972", "action created", "2024-05-30 01:35:20", "2024-05-30 01:35:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("809", "1088972", "action started via WP Cron", "2024-05-30 01:38:26", "2024-05-30 01:38:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("810", "1088972", "action complete via WP Cron", "2024-05-30 01:38:26", "2024-05-30 01:38:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("811", "1088973", "action created", "2024-05-30 01:38:26", "2024-05-30 01:38:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("812", "1088973", "action started via WP Cron", "2024-05-30 01:51:19", "2024-05-30 01:51:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("813", "1088973", "action complete via WP Cron", "2024-05-30 01:51:19", "2024-05-30 01:51:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("814", "1088974", "action created", "2024-05-30 01:51:19", "2024-05-30 01:51:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("815", "1088974", "action started via WP Cron", "2024-05-30 01:54:23", "2024-05-30 01:54:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("816", "1088974", "action complete via WP Cron", "2024-05-30 01:54:24", "2024-05-30 01:54:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("817", "1088975", "action created", "2024-05-30 01:54:24", "2024-05-30 01:54:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("818", "1088975", "action started via WP Cron", "2024-05-30 02:07:28", "2024-05-30 02:07:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("819", "1088975", "action complete via WP Cron", "2024-05-30 02:07:28", "2024-05-30 02:07:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("820", "1088976", "action created", "2024-05-30 02:07:29", "2024-05-30 02:07:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("821", "1088976", "action started via WP Cron", "2024-05-30 02:10:40", "2024-05-30 02:10:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("822", "1088976", "action complete via WP Cron", "2024-05-30 02:10:40", "2024-05-30 02:10:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("823", "1088977", "action created", "2024-05-30 02:10:40", "2024-05-30 02:10:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("824", "1088977", "action started via WP Cron", "2024-05-30 02:21:11", "2024-05-30 02:21:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("825", "1088977", "action complete via WP Cron", "2024-05-30 02:21:11", "2024-05-30 02:21:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("826", "1088978", "action created", "2024-05-30 02:21:11", "2024-05-30 02:21:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("827", "1088978", "action started via WP Cron", "2024-05-30 02:23:12", "2024-05-30 02:23:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("828", "1088978", "action complete via WP Cron", "2024-05-30 02:23:13", "2024-05-30 02:23:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("829", "1088979", "action created", "2024-05-30 02:23:13", "2024-05-30 02:23:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("830", "1088979", "action started via WP Cron", "2024-05-30 02:26:59", "2024-05-30 02:26:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("831", "1088979", "action complete via WP Cron", "2024-05-30 02:26:59", "2024-05-30 02:26:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("832", "1088980", "action created", "2024-05-30 02:26:59", "2024-05-30 02:26:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("833", "1088980", "action started via WP Cron", "2024-05-30 02:28:16", "2024-05-30 02:28:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("834", "1088980", "action complete via WP Cron", "2024-05-30 02:28:16", "2024-05-30 02:28:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("835", "1088981", "action created", "2024-05-30 02:28:16", "2024-05-30 02:28:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("836", "1088981", "action started via WP Cron", "2024-05-30 02:32:22", "2024-05-30 02:32:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("837", "1088981", "action complete via WP Cron", "2024-05-30 02:32:22", "2024-05-30 02:32:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("838", "1088982", "action created", "2024-05-30 02:32:22", "2024-05-30 02:32:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("839", "1088982", "action started via WP Cron", "2024-05-30 02:39:59", "2024-05-30 02:39:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("840", "1088982", "action complete via WP Cron", "2024-05-30 02:39:59", "2024-05-30 02:39:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("841", "1088983", "action created", "2024-05-30 02:39:59", "2024-05-30 02:39:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("842", "1088983", "action started via WP Cron", "2024-05-30 02:43:08", "2024-05-30 02:43:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("843", "1088983", "action complete via WP Cron", "2024-05-30 02:43:08", "2024-05-30 02:43:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("844", "1088984", "action created", "2024-05-30 02:43:08", "2024-05-30 02:43:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("845", "1088984", "action started via WP Cron", "2024-05-30 02:56:08", "2024-05-30 02:56:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("846", "1088984", "action complete via WP Cron", "2024-05-30 02:56:08", "2024-05-30 02:56:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("847", "1088985", "action created", "2024-05-30 02:56:08", "2024-05-30 02:56:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("848", "1088985", "action started via WP Cron", "2024-05-30 02:59:16", "2024-05-30 02:59:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("849", "1088985", "action complete via WP Cron", "2024-05-30 02:59:16", "2024-05-30 02:59:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("850", "1088986", "action created", "2024-05-30 02:59:16", "2024-05-30 02:59:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("851", "1088986", "action started via WP Cron", "2024-05-30 03:12:25", "2024-05-30 03:12:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("852", "1088986", "action complete via WP Cron", "2024-05-30 03:12:25", "2024-05-30 03:12:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("853", "1088987", "action created", "2024-05-30 03:12:25", "2024-05-30 03:12:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("854", "1088987", "action started via WP Cron", "2024-05-30 03:15:35", "2024-05-30 03:15:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("855", "1088987", "action complete via WP Cron", "2024-05-30 03:15:35", "2024-05-30 03:15:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("856", "1088988", "action created", "2024-05-30 03:15:35", "2024-05-30 03:15:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("857", "1088988", "action started via WP Cron", "2024-05-30 03:28:37", "2024-05-30 03:28:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("858", "1088988", "action complete via WP Cron", "2024-05-30 03:28:37", "2024-05-30 03:28:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("859", "1088989", "action created", "2024-05-30 03:28:37", "2024-05-30 03:28:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("860", "1088989", "action started via WP Cron", "2024-05-30 03:31:46", "2024-05-30 03:31:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("861", "1088989", "action complete via WP Cron", "2024-05-30 03:31:46", "2024-05-30 03:31:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("862", "1088990", "action created", "2024-05-30 03:31:46", "2024-05-30 03:31:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("863", "1088990", "action started via WP Cron", "2024-05-30 03:44:57", "2024-05-30 03:44:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("864", "1088990", "action complete via WP Cron", "2024-05-30 03:44:59", "2024-05-30 03:44:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("865", "1088991", "action created", "2024-05-30 03:44:59", "2024-05-30 03:44:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("866", "1088991", "action started via WP Cron", "2024-05-30 03:48:00", "2024-05-30 03:48:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("867", "1088991", "action complete via WP Cron", "2024-05-30 03:48:00", "2024-05-30 03:48:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("868", "1088992", "action created", "2024-05-30 03:48:00", "2024-05-30 03:48:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("869", "1088992", "action started via WP Cron", "2024-05-30 04:01:00", "2024-05-30 04:01:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("870", "1088992", "action complete via WP Cron", "2024-05-30 04:01:01", "2024-05-30 04:01:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("871", "1088993", "action created", "2024-05-30 04:01:01", "2024-05-30 04:01:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("872", "1088993", "action started via WP Cron", "2024-05-30 04:04:10", "2024-05-30 04:04:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("873", "1088993", "action complete via WP Cron", "2024-05-30 04:04:10", "2024-05-30 04:04:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("874", "1088994", "action created", "2024-05-30 04:04:10", "2024-05-30 04:04:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("875", "1088994", "action started via WP Cron", "2024-05-30 04:17:19", "2024-05-30 04:17:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("876", "1088994", "action complete via WP Cron", "2024-05-30 04:17:20", "2024-05-30 04:17:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("877", "1088995", "action created", "2024-05-30 04:17:20", "2024-05-30 04:17:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("878", "1088995", "action started via WP Cron", "2024-05-30 04:20:30", "2024-05-30 04:20:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("879", "1088995", "action complete via WP Cron", "2024-05-30 04:20:30", "2024-05-30 04:20:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("880", "1088996", "action created", "2024-05-30 04:20:30", "2024-05-30 04:20:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("881", "1088996", "action started via WP Cron", "2024-05-30 04:33:34", "2024-05-30 04:33:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("882", "1088996", "action complete via WP Cron", "2024-05-30 04:33:34", "2024-05-30 04:33:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("883", "1088997", "action created", "2024-05-30 04:33:34", "2024-05-30 04:33:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("884", "1088997", "action started via WP Cron", "2024-05-30 04:36:52", "2024-05-30 04:36:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("885", "1088997", "action complete via WP Cron", "2024-05-30 04:36:52", "2024-05-30 04:36:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("886", "1088998", "action created", "2024-05-30 04:36:52", "2024-05-30 04:36:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("887", "1088998", "action started via WP Cron", "2024-05-30 04:49:44", "2024-05-30 04:49:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("888", "1088998", "action complete via WP Cron", "2024-05-30 04:49:44", "2024-05-30 04:49:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("889", "1088999", "action created", "2024-05-30 04:49:44", "2024-05-30 04:49:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("890", "1088999", "action started via WP Cron", "2024-05-30 04:52:54", "2024-05-30 04:52:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("891", "1088999", "action complete via WP Cron", "2024-05-30 04:52:54", "2024-05-30 04:52:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("892", "1089000", "action created", "2024-05-30 04:52:54", "2024-05-30 04:52:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("893", "1089000", "action started via WP Cron", "2024-05-30 05:05:57", "2024-05-30 05:05:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("894", "1089000", "action complete via WP Cron", "2024-05-30 05:05:57", "2024-05-30 05:05:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("895", "1089001", "action created", "2024-05-30 05:05:57", "2024-05-30 05:05:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("896", "1089001", "action started via WP Cron", "2024-05-30 05:09:06", "2024-05-30 05:09:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("897", "1089001", "action complete via WP Cron", "2024-05-30 05:09:06", "2024-05-30 05:09:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("898", "1089002", "action created", "2024-05-30 05:09:06", "2024-05-30 05:09:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("899", "1089002", "action started via WP Cron", "2024-05-30 05:22:05", "2024-05-30 05:22:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("900", "1089002", "action complete via WP Cron", "2024-05-30 05:22:05", "2024-05-30 05:22:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("901", "1089003", "action created", "2024-05-30 05:22:05", "2024-05-30 05:22:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("902", "1089003", "action started via WP Cron", "2024-05-30 05:25:16", "2024-05-30 05:25:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("903", "1089003", "action complete via WP Cron", "2024-05-30 05:25:16", "2024-05-30 05:25:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("904", "1089004", "action created", "2024-05-30 05:25:16", "2024-05-30 05:25:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("905", "1089004", "action started via WP Cron", "2024-05-30 05:38:19", "2024-05-30 05:38:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("906", "1089004", "action complete via WP Cron", "2024-05-30 05:38:19", "2024-05-30 05:38:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("907", "1089005", "action created", "2024-05-30 05:38:19", "2024-05-30 05:38:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("908", "1089005", "action started via WP Cron", "2024-05-30 05:41:34", "2024-05-30 05:41:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("909", "1089005", "action complete via WP Cron", "2024-05-30 05:41:34", "2024-05-30 05:41:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("910", "1089006", "action created", "2024-05-30 05:41:34", "2024-05-30 05:41:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("911", "1089006", "action started via WP Cron", "2024-05-30 05:54:35", "2024-05-30 05:54:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("912", "1089006", "action complete via WP Cron", "2024-05-30 05:54:35", "2024-05-30 05:54:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("913", "1089007", "action created", "2024-05-30 05:54:36", "2024-05-30 05:54:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("914", "1089007", "action started via WP Cron", "2024-05-30 05:57:43", "2024-05-30 05:57:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("915", "1089007", "action complete via WP Cron", "2024-05-30 05:57:44", "2024-05-30 05:57:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("916", "1089008", "action created", "2024-05-30 05:57:45", "2024-05-30 05:57:45");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("917", "1089008", "action started via WP Cron", "2024-05-30 06:11:00", "2024-05-30 06:11:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("918", "1089008", "action complete via WP Cron", "2024-05-30 06:11:01", "2024-05-30 06:11:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("919", "1089009", "action created", "2024-05-30 06:11:01", "2024-05-30 06:11:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("920", "1089009", "action started via WP Cron", "2024-05-30 06:14:15", "2024-05-30 06:14:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("921", "1089009", "action complete via WP Cron", "2024-05-30 06:14:15", "2024-05-30 06:14:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("922", "1089010", "action created", "2024-05-30 06:14:15", "2024-05-30 06:14:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("923", "1089010", "action started via WP Cron", "2024-05-30 06:27:37", "2024-05-30 06:27:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("924", "1089010", "action complete via WP Cron", "2024-05-30 06:27:37", "2024-05-30 06:27:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("925", "1089011", "action created", "2024-05-30 06:27:37", "2024-05-30 06:27:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("926", "1089011", "action started via WP Cron", "2024-05-30 06:30:48", "2024-05-30 06:30:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("927", "1089011", "action complete via WP Cron", "2024-05-30 06:30:48", "2024-05-30 06:30:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("928", "1089012", "action created", "2024-05-30 06:30:48", "2024-05-30 06:30:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("929", "1089012", "action started via WP Cron", "2024-05-30 06:42:15", "2024-05-30 06:42:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("930", "1089012", "action complete via WP Cron", "2024-05-30 06:42:15", "2024-05-30 06:42:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("931", "1089013", "action created", "2024-05-30 06:42:15", "2024-05-30 06:42:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("932", "1089013", "action started via WP Cron", "2024-05-30 06:44:02", "2024-05-30 06:44:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("933", "1089013", "action complete via WP Cron", "2024-05-30 06:44:02", "2024-05-30 06:44:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("934", "1089014", "action created", "2024-05-30 06:44:02", "2024-05-30 06:44:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("935", "1089014", "action started via WP Cron", "2024-05-30 06:47:12", "2024-05-30 06:47:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("936", "1089014", "action complete via WP Cron", "2024-05-30 06:47:13", "2024-05-30 06:47:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("937", "1089015", "action created", "2024-05-30 06:47:13", "2024-05-30 06:47:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("938", "1089015", "action started via WP Cron", "2024-05-30 07:00:27", "2024-05-30 07:00:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("939", "1089015", "action complete via WP Cron", "2024-05-30 07:00:27", "2024-05-30 07:00:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("940", "1089016", "action created", "2024-05-30 07:00:27", "2024-05-30 07:00:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("941", "1089016", "action started via WP Cron", "2024-05-30 07:03:40", "2024-05-30 07:03:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("942", "1089016", "action complete via WP Cron", "2024-05-30 07:03:40", "2024-05-30 07:03:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("943", "1089017", "action created", "2024-05-30 07:03:40", "2024-05-30 07:03:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("944", "1089017", "action started via WP Cron", "2024-05-30 07:06:59", "2024-05-30 07:06:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("945", "1089017", "action complete via WP Cron", "2024-05-30 07:07:00", "2024-05-30 07:07:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("946", "1089018", "action created", "2024-05-30 07:07:00", "2024-05-30 07:07:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("947", "1089018", "action started via WP Cron", "2024-05-30 08:37:31", "2024-05-30 08:37:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("948", "1089018", "action complete via WP Cron", "2024-05-30 08:37:31", "2024-05-30 08:37:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("949", "1089019", "action created", "2024-05-30 08:37:31", "2024-05-30 08:37:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("950", "1089019", "action started via WP Cron", "2024-05-30 11:08:29", "2024-05-30 11:08:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("951", "1089019", "action complete via WP Cron", "2024-05-30 11:08:29", "2024-05-30 11:08:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("952", "1089020", "action created", "2024-05-30 11:08:29", "2024-05-30 11:08:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("953", "1089020", "action started via WP Cron", "2024-05-30 11:10:53", "2024-05-30 11:10:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("954", "1089020", "action complete via WP Cron", "2024-05-30 11:10:54", "2024-05-30 11:10:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("955", "1089021", "action created", "2024-05-30 11:10:54", "2024-05-30 11:10:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("956", "1089021", "action started via WP Cron", "2024-05-30 11:14:09", "2024-05-30 11:14:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("957", "1089021", "action complete via WP Cron", "2024-05-30 11:14:09", "2024-05-30 11:14:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("958", "1089022", "action created", "2024-05-30 11:14:09", "2024-05-30 11:14:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("959", "1089022", "action started via WP Cron", "2024-05-30 11:27:25", "2024-05-30 11:27:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("960", "1089022", "action complete via WP Cron", "2024-05-30 11:27:25", "2024-05-30 11:27:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("961", "1089023", "action created", "2024-05-30 11:27:25", "2024-05-30 11:27:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("962", "1089023", "action started via WP Cron", "2024-05-30 11:30:27", "2024-05-30 11:30:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("963", "1089023", "action complete via WP Cron", "2024-05-30 11:30:27", "2024-05-30 11:30:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("964", "1089024", "action created", "2024-05-30 11:30:27", "2024-05-30 11:30:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("965", "1089024", "action started via WP Cron", "2024-05-30 11:43:42", "2024-05-30 11:43:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("966", "1089024", "action complete via WP Cron", "2024-05-30 11:43:43", "2024-05-30 11:43:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("967", "1089025", "action created", "2024-05-30 11:43:43", "2024-05-30 11:43:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("968", "1089025", "action started via WP Cron", "2024-05-30 11:46:57", "2024-05-30 11:46:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("969", "1089025", "action complete via WP Cron", "2024-05-30 11:46:57", "2024-05-30 11:46:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("970", "1089026", "action created", "2024-05-30 11:46:57", "2024-05-30 11:46:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("971", "1089026", "action started via WP Cron", "2024-05-30 12:03:20", "2024-05-30 12:03:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("972", "1089026", "action complete via WP Cron", "2024-05-30 12:03:20", "2024-05-30 12:03:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("973", "1089027", "action created", "2024-05-30 12:03:20", "2024-05-30 12:03:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("974", "1089027", "action started via WP Cron", "2024-05-30 12:16:22", "2024-05-30 12:16:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("975", "1089027", "action complete via WP Cron", "2024-05-30 12:16:22", "2024-05-30 12:16:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("976", "1089028", "action created", "2024-05-30 12:16:22", "2024-05-30 12:16:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("977", "1089028", "action started via WP Cron", "2024-05-30 12:19:32", "2024-05-30 12:19:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("978", "1089028", "action complete via WP Cron", "2024-05-30 12:19:32", "2024-05-30 12:19:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("979", "1089029", "action created", "2024-05-30 12:19:32", "2024-05-30 12:19:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("980", "1089029", "action started via WP Cron", "2024-05-30 12:32:35", "2024-05-30 12:32:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("981", "1089029", "action complete via WP Cron", "2024-05-30 12:32:35", "2024-05-30 12:32:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("982", "1089030", "action created", "2024-05-30 12:32:35", "2024-05-30 12:32:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("983", "1089030", "action started via WP Cron", "2024-05-30 12:35:44", "2024-05-30 12:35:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("984", "1089030", "action complete via WP Cron", "2024-05-30 12:35:44", "2024-05-30 12:35:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("985", "1089031", "action created", "2024-05-30 12:35:44", "2024-05-30 12:35:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("986", "1089031", "action started via WP Cron", "2024-05-30 12:48:45", "2024-05-30 12:48:45");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("987", "1089031", "action complete via WP Cron", "2024-05-30 12:48:45", "2024-05-30 12:48:45");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("988", "1089032", "action created", "2024-05-30 12:48:45", "2024-05-30 12:48:45");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("989", "1089032", "action started via WP Cron", "2024-05-30 12:52:39", "2024-05-30 12:52:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("990", "1089032", "action complete via WP Cron", "2024-05-30 12:52:39", "2024-05-30 12:52:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("991", "1089033", "action created", "2024-05-30 12:52:39", "2024-05-30 12:52:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("992", "1089033", "action started via WP Cron", "2024-05-30 13:04:53", "2024-05-30 13:04:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("993", "1089033", "action complete via WP Cron", "2024-05-30 13:04:53", "2024-05-30 13:04:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("994", "1089034", "action created", "2024-05-30 13:04:53", "2024-05-30 13:04:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("995", "1089034", "action started via WP Cron", "2024-05-30 13:08:03", "2024-05-30 13:08:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("996", "1089034", "action complete via WP Cron", "2024-05-30 13:08:04", "2024-05-30 13:08:04");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("997", "1089035", "action created", "2024-05-30 13:08:04", "2024-05-30 13:08:04");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("998", "1089035", "action started via WP Cron", "2024-05-30 13:21:18", "2024-05-30 13:21:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("999", "1089035", "action complete via WP Cron", "2024-05-30 13:21:18", "2024-05-30 13:21:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1000", "1089036", "action created", "2024-05-30 13:21:18", "2024-05-30 13:21:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1001", "1089036", "action started via WP Cron", "2024-05-30 13:24:26", "2024-05-30 13:24:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1002", "1089036", "action complete via WP Cron", "2024-05-30 13:24:26", "2024-05-30 13:24:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1003", "1089037", "action created", "2024-05-30 13:24:26", "2024-05-30 13:24:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1004", "1089037", "action started via WP Cron", "2024-05-30 13:37:29", "2024-05-30 13:37:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1005", "1089037", "action complete via WP Cron", "2024-05-30 13:37:29", "2024-05-30 13:37:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1006", "1089038", "action created", "2024-05-30 13:37:29", "2024-05-30 13:37:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1007", "1089038", "action started via WP Cron", "2024-05-30 13:40:36", "2024-05-30 13:40:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1008", "1089038", "action complete via WP Cron", "2024-05-30 13:40:37", "2024-05-30 13:40:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1009", "1089039", "action created", "2024-05-30 13:40:37", "2024-05-30 13:40:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1010", "1089039", "action started via WP Cron", "2024-05-30 13:53:42", "2024-05-30 13:53:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1011", "1089039", "action complete via WP Cron", "2024-05-30 13:53:42", "2024-05-30 13:53:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1012", "1089040", "action created", "2024-05-30 13:53:42", "2024-05-30 13:53:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1013", "1089040", "action started via WP Cron", "2024-05-30 13:56:51", "2024-05-30 13:56:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1014", "1089040", "action complete via WP Cron", "2024-05-30 13:56:51", "2024-05-30 13:56:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1015", "1089041", "action created", "2024-05-30 13:56:51", "2024-05-30 13:56:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1016", "1089041", "action started via WP Cron", "2024-05-30 14:08:12", "2024-05-30 14:08:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1017", "1089041", "action complete via WP Cron", "2024-05-30 14:08:12", "2024-05-30 14:08:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1018", "1089042", "action created", "2024-05-30 14:08:12", "2024-05-30 14:08:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1019", "1089042", "action started via WP Cron", "2024-05-30 14:11:34", "2024-05-30 14:11:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1020", "1089042", "action complete via WP Cron", "2024-05-30 14:11:34", "2024-05-30 14:11:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1021", "1089043", "action created", "2024-05-30 14:11:34", "2024-05-30 14:11:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1022", "1089043", "action started via WP Cron", "2024-05-30 14:28:12", "2024-05-30 14:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1023", "1089043", "action complete via WP Cron", "2024-05-30 14:28:12", "2024-05-30 14:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1024", "1089044", "action created", "2024-05-30 14:28:12", "2024-05-30 14:28:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1025", "1089044", "action started via WP Cron", "2024-05-30 14:56:44", "2024-05-30 14:56:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1026", "1089044", "action complete via WP Cron", "2024-05-30 14:56:45", "2024-05-30 14:56:45");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1027", "1089045", "action created", "2024-05-30 14:56:45", "2024-05-30 14:56:45");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1028", "1089045", "action started via WP Cron", "2024-05-30 15:09:59", "2024-05-30 15:09:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1029", "1089045", "action complete via WP Cron", "2024-05-30 15:09:59", "2024-05-30 15:09:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1030", "1089046", "action created", "2024-05-30 15:09:59", "2024-05-30 15:09:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1031", "1089046", "action started via WP Cron", "2024-05-30 15:13:13", "2024-05-30 15:13:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1032", "1089046", "action complete via WP Cron", "2024-05-30 15:13:13", "2024-05-30 15:13:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1033", "1089047", "action created", "2024-05-30 15:13:13", "2024-05-30 15:13:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1034", "1089047", "action started via WP Cron", "2024-05-30 15:26:30", "2024-05-30 15:26:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1035", "1089047", "action complete via WP Cron", "2024-05-30 15:26:30", "2024-05-30 15:26:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1036", "1089048", "action created", "2024-05-30 15:26:30", "2024-05-30 15:26:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1037", "1089048", "action started via WP Cron", "2024-05-30 15:30:29", "2024-05-30 15:30:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1038", "1089048", "action complete via WP Cron", "2024-05-30 15:30:29", "2024-05-30 15:30:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1039", "1089049", "action created", "2024-05-30 15:30:29", "2024-05-30 15:30:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1040", "1089049", "action started via WP Cron", "2024-05-30 15:42:57", "2024-05-30 15:42:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1041", "1089049", "action complete via WP Cron", "2024-05-30 15:42:57", "2024-05-30 15:42:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1042", "1089050", "action created", "2024-05-30 15:42:57", "2024-05-30 15:42:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1043", "1089050", "action started via WP Cron", "2024-05-30 15:46:09", "2024-05-30 15:46:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1044", "1089050", "action complete via WP Cron", "2024-05-30 15:46:09", "2024-05-30 15:46:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1045", "1089051", "action created", "2024-05-30 15:46:09", "2024-05-30 15:46:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1046", "1089051", "action started via WP Cron", "2024-05-30 15:59:23", "2024-05-30 15:59:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1047", "1089051", "action complete via WP Cron", "2024-05-30 15:59:23", "2024-05-30 15:59:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1048", "1089052", "action created", "2024-05-30 15:59:23", "2024-05-30 15:59:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1049", "1089052", "action started via WP Cron", "2024-05-30 16:02:39", "2024-05-30 16:02:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1050", "1089052", "action complete via WP Cron", "2024-05-30 16:02:39", "2024-05-30 16:02:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1051", "1089053", "action created", "2024-05-30 16:02:39", "2024-05-30 16:02:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1052", "1089053", "action started via WP Cron", "2024-05-30 16:15:59", "2024-05-30 16:15:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1053", "1089053", "action complete via WP Cron", "2024-05-30 16:15:59", "2024-05-30 16:15:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1054", "1089054", "action created", "2024-05-30 16:15:59", "2024-05-30 16:15:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1055", "1089054", "action started via WP Cron", "2024-05-30 16:19:11", "2024-05-30 16:19:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1056", "1089054", "action complete via WP Cron", "2024-05-30 16:19:11", "2024-05-30 16:19:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1057", "1089055", "action created", "2024-05-30 16:19:11", "2024-05-30 16:19:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1058", "1089055", "action started via WP Cron", "2024-05-30 16:32:38", "2024-05-30 16:32:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1059", "1089055", "action complete via WP Cron", "2024-05-30 16:32:38", "2024-05-30 16:32:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1060", "1089056", "action created", "2024-05-30 16:32:38", "2024-05-30 16:32:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1061", "1089056", "action started via WP Cron", "2024-05-30 16:35:55", "2024-05-30 16:35:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1062", "1089056", "action complete via WP Cron", "2024-05-30 16:35:55", "2024-05-30 16:35:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1063", "1089057", "action created", "2024-05-30 16:35:55", "2024-05-30 16:35:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1064", "1089057", "action started via WP Cron", "2024-05-30 16:49:14", "2024-05-30 16:49:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1065", "1089057", "action complete via WP Cron", "2024-05-30 16:49:14", "2024-05-30 16:49:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1066", "1089058", "action created", "2024-05-30 16:49:14", "2024-05-30 16:49:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1067", "1089058", "action started via WP Cron", "2024-05-30 16:52:24", "2024-05-30 16:52:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1068", "1089058", "action complete via WP Cron", "2024-05-30 16:52:24", "2024-05-30 16:52:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1069", "1089059", "action created", "2024-05-30 16:52:24", "2024-05-30 16:52:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1070", "1089059", "action started via WP Cron", "2024-05-30 17:05:46", "2024-05-30 17:05:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1071", "1089059", "action complete via WP Cron", "2024-05-30 17:05:46", "2024-05-30 17:05:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1072", "1089060", "action created", "2024-05-30 17:05:46", "2024-05-30 17:05:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1073", "1089060", "action started via WP Cron", "2024-05-30 17:09:00", "2024-05-30 17:09:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1074", "1089060", "action complete via WP Cron", "2024-05-30 17:09:00", "2024-05-30 17:09:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1075", "1089061", "action created", "2024-05-30 17:09:00", "2024-05-30 17:09:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1076", "1089061", "action started via WP Cron", "2024-05-30 17:22:14", "2024-05-30 17:22:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1077", "1089061", "action complete via WP Cron", "2024-05-30 17:22:14", "2024-05-30 17:22:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1078", "1089062", "action created", "2024-05-30 17:22:14", "2024-05-30 17:22:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1079", "1089062", "action started via WP Cron", "2024-05-30 17:25:31", "2024-05-30 17:25:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1080", "1089062", "action complete via WP Cron", "2024-05-30 17:25:31", "2024-05-30 17:25:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1081", "1089063", "action created", "2024-05-30 17:25:31", "2024-05-30 17:25:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1082", "1089063", "action started via WP Cron", "2024-05-30 17:38:42", "2024-05-30 17:38:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1083", "1089063", "action complete via WP Cron", "2024-05-30 17:38:42", "2024-05-30 17:38:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1084", "1089064", "action created", "2024-05-30 17:38:42", "2024-05-30 17:38:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1085", "1089064", "action started via WP Cron", "2024-05-30 17:41:53", "2024-05-30 17:41:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1086", "1089064", "action complete via WP Cron", "2024-05-30 17:41:53", "2024-05-30 17:41:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1087", "1089065", "action created", "2024-05-30 17:41:53", "2024-05-30 17:41:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1088", "1089065", "action started via WP Cron", "2024-05-30 17:42:54", "2024-05-30 17:42:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1089", "1089065", "action complete via WP Cron", "2024-05-30 17:42:54", "2024-05-30 17:42:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1090", "1089066", "action created", "2024-05-30 17:42:54", "2024-05-30 17:42:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1091", "1089066", "action started via WP Cron", "2024-05-30 17:55:10", "2024-05-30 17:55:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1092", "1089066", "action complete via WP Cron", "2024-05-30 17:55:10", "2024-05-30 17:55:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1093", "1089067", "action created", "2024-05-30 17:55:10", "2024-05-30 17:55:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1094", "1089067", "action started via WP Cron", "2024-05-30 17:58:22", "2024-05-30 17:58:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1095", "1089067", "action complete via WP Cron", "2024-05-30 17:58:22", "2024-05-30 17:58:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1096", "1089068", "action created", "2024-05-30 17:58:22", "2024-05-30 17:58:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1097", "1089068", "action started via WP Cron", "2024-05-30 18:11:21", "2024-05-30 18:11:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1098", "1089068", "action complete via WP Cron", "2024-05-30 18:11:22", "2024-05-30 18:11:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1099", "1089069", "action created", "2024-05-30 18:11:22", "2024-05-30 18:11:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1100", "1089069", "action started via WP Cron", "2024-05-30 18:14:31", "2024-05-30 18:14:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1101", "1089069", "action complete via WP Cron", "2024-05-30 18:14:31", "2024-05-30 18:14:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1102", "1089070", "action created", "2024-05-30 18:14:31", "2024-05-30 18:14:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1103", "1089070", "action started via WP Cron", "2024-05-30 18:27:20", "2024-05-30 18:27:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1104", "1089070", "action complete via WP Cron", "2024-05-30 18:27:20", "2024-05-30 18:27:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1105", "1089071", "action created", "2024-05-30 18:27:20", "2024-05-30 18:27:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1106", "1089071", "action started via WP Cron", "2024-05-30 18:30:28", "2024-05-30 18:30:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1107", "1089071", "action complete via WP Cron", "2024-05-30 18:30:28", "2024-05-30 18:30:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1108", "1089072", "action created", "2024-05-30 18:30:28", "2024-05-30 18:30:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1109", "1089072", "action started via WP Cron", "2024-05-30 18:46:26", "2024-05-30 18:46:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1110", "1089072", "action complete via WP Cron", "2024-05-30 18:46:26", "2024-05-30 18:46:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1111", "1089073", "action created", "2024-05-30 18:46:26", "2024-05-30 18:46:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1112", "1089073", "action started via WP Cron", "2024-05-30 18:59:22", "2024-05-30 18:59:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1113", "1089073", "action complete via WP Cron", "2024-05-30 18:59:22", "2024-05-30 18:59:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1114", "1089074", "action created", "2024-05-30 18:59:22", "2024-05-30 18:59:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1115", "1089074", "action started via WP Cron", "2024-05-30 19:02:24", "2024-05-30 19:02:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1116", "1089074", "action complete via WP Cron", "2024-05-30 19:02:24", "2024-05-30 19:02:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1117", "1089075", "action created", "2024-05-30 19:02:24", "2024-05-30 19:02:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1118", "1089075", "action started via WP Cron", "2024-05-30 19:18:19", "2024-05-30 19:18:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1119", "1089075", "action complete via WP Cron", "2024-05-30 19:18:19", "2024-05-30 19:18:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1120", "1089076", "action created", "2024-05-30 19:18:19", "2024-05-30 19:18:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1121", "1089076", "action started via WP Cron", "2024-05-30 19:31:03", "2024-05-30 19:31:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1122", "1089076", "action complete via WP Cron", "2024-05-30 19:31:03", "2024-05-30 19:31:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1123", "1089077", "action created", "2024-05-30 19:31:03", "2024-05-30 19:31:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1124", "1089077", "action started via WP Cron", "2024-05-30 19:34:08", "2024-05-30 19:34:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1125", "1089077", "action complete via WP Cron", "2024-05-30 19:34:08", "2024-05-30 19:34:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1126", "1089078", "action created", "2024-05-30 19:34:08", "2024-05-30 19:34:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1127", "1089078", "action started via WP Cron", "2024-05-30 19:46:49", "2024-05-30 19:46:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1128", "1089078", "action complete via WP Cron", "2024-05-30 19:46:49", "2024-05-30 19:46:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1129", "1089079", "action created", "2024-05-30 19:46:49", "2024-05-30 19:46:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1130", "1089079", "action started via WP Cron", "2024-05-30 19:49:53", "2024-05-30 19:49:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1131", "1089079", "action complete via WP Cron", "2024-05-30 19:49:53", "2024-05-30 19:49:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1132", "1089080", "action created", "2024-05-30 19:49:53", "2024-05-30 19:49:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1133", "1089080", "action started via WP Cron", "2024-05-30 19:51:43", "2024-05-30 19:51:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1134", "1089080", "action complete via WP Cron", "2024-05-30 19:51:43", "2024-05-30 19:51:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1135", "1089081", "action created", "2024-05-30 19:51:43", "2024-05-30 19:51:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1136", "1089081", "action started via WP Cron", "2024-05-30 20:02:32", "2024-05-30 20:02:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1137", "1089081", "action complete via WP Cron", "2024-05-30 20:02:32", "2024-05-30 20:02:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1138", "1089082", "action created", "2024-05-30 20:02:32", "2024-05-30 20:02:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1139", "1089082", "action started via WP Cron", "2024-05-30 20:05:33", "2024-05-30 20:05:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1140", "1089082", "action complete via WP Cron", "2024-05-30 20:05:33", "2024-05-30 20:05:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1141", "1089083", "action created", "2024-05-30 20:05:33", "2024-05-30 20:05:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1142", "1089083", "action started via WP Cron", "2024-05-30 20:18:13", "2024-05-30 20:18:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1143", "1089083", "action complete via WP Cron", "2024-05-30 20:18:13", "2024-05-30 20:18:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1144", "1089084", "action created", "2024-05-30 20:18:13", "2024-05-30 20:18:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1145", "1089084", "action started via WP Cron", "2024-05-30 20:21:19", "2024-05-30 20:21:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1146", "1089084", "action complete via WP Cron", "2024-05-30 20:21:19", "2024-05-30 20:21:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1147", "1089085", "action created", "2024-05-30 20:21:19", "2024-05-30 20:21:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1148", "1089085", "action started via WP Cron", "2024-05-30 20:33:57", "2024-05-30 20:33:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1149", "1089085", "action complete via WP Cron", "2024-05-30 20:33:57", "2024-05-30 20:33:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1150", "1089086", "action created", "2024-05-30 20:33:57", "2024-05-30 20:33:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1151", "1089086", "action started via WP Cron", "2024-05-30 20:36:57", "2024-05-30 20:36:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1152", "1089086", "action complete via WP Cron", "2024-05-30 20:36:58", "2024-05-30 20:36:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1153", "1089087", "action created", "2024-05-30 20:36:58", "2024-05-30 20:36:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1154", "1089087", "action started via WP Cron", "2024-05-30 20:49:27", "2024-05-30 20:49:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1155", "1089087", "action complete via WP Cron", "2024-05-30 20:49:27", "2024-05-30 20:49:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1156", "1089088", "action created", "2024-05-30 20:49:28", "2024-05-30 20:49:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1157", "1089088", "action started via WP Cron", "2024-05-30 20:52:42", "2024-05-30 20:52:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1158", "1089088", "action complete via WP Cron", "2024-05-30 20:52:42", "2024-05-30 20:52:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1159", "1089089", "action created", "2024-05-30 20:52:42", "2024-05-30 20:52:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1160", "1089089", "action started via WP Cron", "2024-05-30 21:04:55", "2024-05-30 21:04:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1161", "1089089", "action complete via WP Cron", "2024-05-30 21:04:55", "2024-05-30 21:04:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1162", "1089090", "action created", "2024-05-30 21:04:55", "2024-05-30 21:04:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1163", "1089090", "action started via WP Cron", "2024-05-30 21:07:59", "2024-05-30 21:07:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1164", "1089090", "action complete via WP Cron", "2024-05-30 21:07:59", "2024-05-30 21:07:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1165", "1089091", "action created", "2024-05-30 21:07:59", "2024-05-30 21:07:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1166", "1089091", "action started via WP Cron", "2024-05-30 21:11:55", "2024-05-30 21:11:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1167", "1089091", "action complete via WP Cron", "2024-05-30 21:11:55", "2024-05-30 21:11:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1168", "1089092", "action created", "2024-05-30 21:11:55", "2024-05-30 21:11:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1169", "1089092", "action started via WP Cron", "2024-05-30 21:20:23", "2024-05-30 21:20:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1170", "1089092", "action complete via WP Cron", "2024-05-30 21:20:23", "2024-05-30 21:20:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1171", "1089093", "action created", "2024-05-30 21:20:23", "2024-05-30 21:20:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1172", "1089093", "action started via WP Cron", "2024-05-30 21:23:24", "2024-05-30 21:23:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1173", "1089093", "action complete via WP Cron", "2024-05-30 21:23:24", "2024-05-30 21:23:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1174", "1089094", "action created", "2024-05-30 21:23:24", "2024-05-30 21:23:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1175", "1089094", "action started via WP Cron", "2024-05-30 21:35:56", "2024-05-30 21:35:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1176", "1089094", "action complete via WP Cron", "2024-05-30 21:35:56", "2024-05-30 21:35:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1177", "1089095", "action created", "2024-05-30 21:35:56", "2024-05-30 21:35:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1178", "1089095", "action started via WP Cron", "2024-05-30 21:38:58", "2024-05-30 21:38:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1179", "1089095", "action complete via WP Cron", "2024-05-30 21:38:58", "2024-05-30 21:38:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1180", "1089096", "action created", "2024-05-30 21:38:58", "2024-05-30 21:38:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1181", "1089096", "action started via WP Cron", "2024-05-30 21:47:23", "2024-05-30 21:47:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1182", "1089096", "action complete via WP Cron", "2024-05-30 21:47:25", "2024-05-30 21:47:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1183", "1089097", "action created", "2024-05-30 21:47:25", "2024-05-30 21:47:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1184", "1089097", "action started via WP Cron", "2024-05-30 21:51:26", "2024-05-30 21:51:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1185", "1089097", "action complete via WP Cron", "2024-05-30 21:51:26", "2024-05-30 21:51:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1186", "1089098", "action created", "2024-05-30 21:51:26", "2024-05-30 21:51:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1187", "1089098", "action started via WP Cron", "2024-05-30 21:54:27", "2024-05-30 21:54:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1188", "1089098", "action complete via WP Cron", "2024-05-30 21:54:27", "2024-05-30 21:54:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1189", "1089099", "action created", "2024-05-30 21:54:27", "2024-05-30 21:54:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1190", "1089099", "action started via WP Cron", "2024-05-30 22:03:19", "2024-05-30 22:03:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1191", "1089099", "action complete via WP Cron", "2024-05-30 22:03:19", "2024-05-30 22:03:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1192", "1089100", "action created", "2024-05-30 22:03:20", "2024-05-30 22:03:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1193", "1089100", "action started via WP Cron", "2024-05-30 22:06:55", "2024-05-30 22:06:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1194", "1089100", "action complete via WP Cron", "2024-05-30 22:06:57", "2024-05-30 22:06:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1195", "1089101", "action created", "2024-05-30 22:06:57", "2024-05-30 22:06:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1196", "1089101", "action started via WP Cron", "2024-05-30 22:10:18", "2024-05-30 22:10:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1197", "1089101", "action complete via WP Cron", "2024-05-30 22:10:18", "2024-05-30 22:10:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1198", "1089102", "action created", "2024-05-30 22:10:19", "2024-05-30 22:10:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1199", "1089102", "action started via WP Cron", "2024-05-30 22:22:34", "2024-05-30 22:22:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1200", "1089102", "action complete via WP Cron", "2024-05-30 22:22:34", "2024-05-30 22:22:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1201", "1089103", "action created", "2024-05-30 22:22:34", "2024-05-30 22:22:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1202", "1089103", "action started via WP Cron", "2024-05-30 22:25:38", "2024-05-30 22:25:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1203", "1089103", "action complete via WP Cron", "2024-05-30 22:25:39", "2024-05-30 22:25:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1204", "1089104", "action created", "2024-05-30 22:25:39", "2024-05-30 22:25:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1205", "1089104", "action started via WP Cron", "2024-05-30 22:28:54", "2024-05-30 22:28:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1206", "1089104", "action complete via WP Cron", "2024-05-30 22:28:54", "2024-05-30 22:28:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1207", "1089105", "action created", "2024-05-30 22:28:54", "2024-05-30 22:28:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1208", "1089105", "action started via WP Cron", "2024-05-30 22:38:19", "2024-05-30 22:38:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1209", "1089105", "action complete via WP Cron", "2024-05-30 22:38:23", "2024-05-30 22:38:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1210", "1089106", "action created", "2024-05-30 22:38:23", "2024-05-30 22:38:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1211", "1089106", "action started via WP Cron", "2024-05-30 22:41:18", "2024-05-30 22:41:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1212", "1089106", "action complete via WP Cron", "2024-05-30 22:41:18", "2024-05-30 22:41:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1213", "1089107", "action created", "2024-05-30 22:41:18", "2024-05-30 22:41:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1214", "1089107", "action started via WP Cron", "2024-05-30 22:54:00", "2024-05-30 22:54:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1215", "1089107", "action complete via WP Cron", "2024-05-30 22:54:00", "2024-05-30 22:54:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1216", "1089108", "action created", "2024-05-30 22:54:00", "2024-05-30 22:54:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1217", "1089108", "action started via WP Cron", "2024-05-30 22:57:50", "2024-05-30 22:57:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1218", "1089108", "action complete via WP Cron", "2024-05-30 22:57:50", "2024-05-30 22:57:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1219", "1089109", "action created", "2024-05-30 22:57:50", "2024-05-30 22:57:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1220", "1089109", "action started via WP Cron", "2024-05-30 23:09:47", "2024-05-30 23:09:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1221", "1089109", "action complete via WP Cron", "2024-05-30 23:09:48", "2024-05-30 23:09:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1222", "1089110", "action created", "2024-05-30 23:09:48", "2024-05-30 23:09:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1223", "1089110", "action started via WP Cron", "2024-05-30 23:12:46", "2024-05-30 23:12:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1224", "1089110", "action complete via WP Cron", "2024-05-30 23:12:46", "2024-05-30 23:12:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1225", "1089111", "action created", "2024-05-30 23:12:46", "2024-05-30 23:12:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1226", "1089111", "action started via WP Cron", "2024-05-30 23:25:26", "2024-05-30 23:25:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1227", "1089111", "action complete via WP Cron", "2024-05-30 23:25:26", "2024-05-30 23:25:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1228", "1089112", "action created", "2024-05-30 23:25:26", "2024-05-30 23:25:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1229", "1089112", "action started via WP Cron", "2024-05-30 23:28:35", "2024-05-30 23:28:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1230", "1089112", "action complete via WP Cron", "2024-05-30 23:28:35", "2024-05-30 23:28:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1231", "1089113", "action created", "2024-05-30 23:28:35", "2024-05-30 23:28:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1232", "1089113", "action started via WP Cron", "2024-05-30 23:41:11", "2024-05-30 23:41:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1233", "1089113", "action complete via WP Cron", "2024-05-30 23:41:11", "2024-05-30 23:41:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1234", "1089114", "action created", "2024-05-30 23:41:11", "2024-05-30 23:41:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1235", "1089114", "action started via WP Cron", "2024-05-30 23:44:18", "2024-05-30 23:44:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1236", "1089114", "action complete via WP Cron", "2024-05-30 23:44:18", "2024-05-30 23:44:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1237", "1089115", "action created", "2024-05-30 23:44:18", "2024-05-30 23:44:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1238", "1089115", "action started via WP Cron", "2024-05-30 23:56:46", "2024-05-30 23:56:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1239", "1089115", "action complete via WP Cron", "2024-05-30 23:56:46", "2024-05-30 23:56:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1240", "1089116", "action created", "2024-05-30 23:56:46", "2024-05-30 23:56:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1241", "1089116", "action started via WP Cron", "2024-05-30 23:59:46", "2024-05-30 23:59:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1242", "1089116", "action complete via WP Cron", "2024-05-30 23:59:46", "2024-05-30 23:59:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1243", "1089117", "action created", "2024-05-30 23:59:46", "2024-05-30 23:59:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1244", "1089117", "action started via WP Cron", "2024-05-31 00:12:27", "2024-05-31 00:12:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1245", "1089117", "action complete via WP Cron", "2024-05-31 00:12:28", "2024-05-31 00:12:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1246", "1089118", "action created", "2024-05-31 00:12:28", "2024-05-31 00:12:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1247", "1089118", "action started via WP Cron", "2024-05-31 00:15:32", "2024-05-31 00:15:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1248", "1089118", "action complete via WP Cron", "2024-05-31 00:15:32", "2024-05-31 00:15:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1249", "1089119", "action created", "2024-05-31 00:15:32", "2024-05-31 00:15:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1250", "1089119", "action started via WP Cron", "2024-05-31 00:28:16", "2024-05-31 00:28:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1251", "1089119", "action complete via WP Cron", "2024-05-31 00:28:16", "2024-05-31 00:28:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1252", "1089120", "action created", "2024-05-31 00:28:16", "2024-05-31 00:28:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1253", "1089120", "action started via WP Cron", "2024-05-31 00:31:22", "2024-05-31 00:31:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1254", "1089120", "action complete via WP Cron", "2024-05-31 00:31:22", "2024-05-31 00:31:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1255", "1089121", "action created", "2024-05-31 00:31:22", "2024-05-31 00:31:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1256", "1089121", "action started via WP Cron", "2024-05-31 00:44:08", "2024-05-31 00:44:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1257", "1089121", "action complete via WP Cron", "2024-05-31 00:44:08", "2024-05-31 00:44:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1258", "1089122", "action created", "2024-05-31 00:44:08", "2024-05-31 00:44:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1259", "1089122", "action started via WP Cron", "2024-05-31 00:47:10", "2024-05-31 00:47:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1260", "1089122", "action complete via WP Cron", "2024-05-31 00:47:11", "2024-05-31 00:47:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1261", "1089123", "action created", "2024-05-31 00:47:11", "2024-05-31 00:47:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1262", "1089123", "action started via WP Cron", "2024-05-31 00:59:58", "2024-05-31 00:59:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1263", "1089123", "action complete via WP Cron", "2024-05-31 00:59:58", "2024-05-31 00:59:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1264", "1089124", "action created", "2024-05-31 00:59:58", "2024-05-31 00:59:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1265", "1089124", "action started via WP Cron", "2024-05-31 01:03:06", "2024-05-31 01:03:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1266", "1089124", "action complete via WP Cron", "2024-05-31 01:03:06", "2024-05-31 01:03:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1267", "1089125", "action created", "2024-05-31 01:03:06", "2024-05-31 01:03:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1268", "1089125", "action started via WP Cron", "2024-05-31 01:19:18", "2024-05-31 01:19:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1269", "1089125", "action complete via WP Cron", "2024-05-31 01:19:18", "2024-05-31 01:19:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1270", "1089126", "action created", "2024-05-31 01:19:18", "2024-05-31 01:19:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1271", "1089126", "action started via WP Cron", "2024-05-31 01:32:22", "2024-05-31 01:32:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1272", "1089126", "action complete via WP Cron", "2024-05-31 01:32:22", "2024-05-31 01:32:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1273", "1089127", "action created", "2024-05-31 01:32:22", "2024-05-31 01:32:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1274", "1089127", "action started via WP Cron", "2024-05-31 01:35:30", "2024-05-31 01:35:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1275", "1089127", "action complete via WP Cron", "2024-05-31 01:35:30", "2024-05-31 01:35:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1276", "1089128", "action created", "2024-05-31 01:35:30", "2024-05-31 01:35:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1277", "1089128", "action started via WP Cron", "2024-05-31 01:48:32", "2024-05-31 01:48:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1278", "1089128", "action complete via WP Cron", "2024-05-31 01:48:32", "2024-05-31 01:48:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1279", "1089129", "action created", "2024-05-31 01:48:33", "2024-05-31 01:48:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1280", "1089129", "action started via WP Cron", "2024-05-31 01:51:37", "2024-05-31 01:51:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1281", "1089129", "action complete via WP Cron", "2024-05-31 01:51:38", "2024-05-31 01:51:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1282", "1089130", "action created", "2024-05-31 01:51:38", "2024-05-31 01:51:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1283", "1089130", "action started via WP Cron", "2024-05-31 02:05:00", "2024-05-31 02:05:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1284", "1089130", "action complete via WP Cron", "2024-05-31 02:05:00", "2024-05-31 02:05:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1285", "1089131", "action created", "2024-05-31 02:05:00", "2024-05-31 02:05:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1286", "1089131", "action started via WP Cron", "2024-05-31 02:08:14", "2024-05-31 02:08:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1287", "1089131", "action complete via WP Cron", "2024-05-31 02:08:14", "2024-05-31 02:08:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1288", "1089132", "action created", "2024-05-31 02:08:14", "2024-05-31 02:08:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1289", "1089132", "action started via WP Cron", "2024-05-31 02:21:22", "2024-05-31 02:21:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1290", "1089132", "action complete via WP Cron", "2024-05-31 02:21:22", "2024-05-31 02:21:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1291", "1089133", "action created", "2024-05-31 02:21:22", "2024-05-31 02:21:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1292", "1089133", "action started via WP Cron", "2024-05-31 02:24:56", "2024-05-31 02:24:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1293", "1089133", "action complete via WP Cron", "2024-05-31 02:24:56", "2024-05-31 02:24:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1294", "1089134", "action created", "2024-05-31 02:24:56", "2024-05-31 02:24:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1295", "1089134", "action started via WP Cron", "2024-05-31 02:38:17", "2024-05-31 02:38:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1296", "1089134", "action complete via WP Cron", "2024-05-31 02:38:17", "2024-05-31 02:38:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1297", "1089135", "action created", "2024-05-31 02:38:17", "2024-05-31 02:38:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1298", "1089135", "action started via WP Cron", "2024-05-31 02:41:31", "2024-05-31 02:41:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1299", "1089135", "action complete via WP Cron", "2024-05-31 02:41:32", "2024-05-31 02:41:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1300", "1089136", "action created", "2024-05-31 02:41:32", "2024-05-31 02:41:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1301", "1089136", "action started via WP Cron", "2024-05-31 02:54:50", "2024-05-31 02:54:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1302", "1089136", "action complete via WP Cron", "2024-05-31 02:54:50", "2024-05-31 02:54:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1303", "1089137", "action created", "2024-05-31 02:54:50", "2024-05-31 02:54:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1304", "1089137", "action started via WP Cron", "2024-05-31 02:58:05", "2024-05-31 02:58:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1305", "1089137", "action complete via WP Cron", "2024-05-31 02:58:05", "2024-05-31 02:58:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1306", "1089138", "action created", "2024-05-31 02:58:05", "2024-05-31 02:58:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1307", "1089138", "action started via WP Cron", "2024-05-31 03:11:30", "2024-05-31 03:11:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1308", "1089138", "action complete via WP Cron", "2024-05-31 03:11:30", "2024-05-31 03:11:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1309", "1089139", "action created", "2024-05-31 03:11:30", "2024-05-31 03:11:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1310", "1089139", "action started via WP Cron", "2024-05-31 03:14:16", "2024-05-31 03:14:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1311", "1089139", "action complete via WP Cron", "2024-05-31 03:14:16", "2024-05-31 03:14:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1312", "1089140", "action created", "2024-05-31 03:14:16", "2024-05-31 03:14:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1313", "1089140", "action started via WP Cron", "2024-05-31 03:15:41", "2024-05-31 03:15:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1314", "1089140", "action complete via WP Cron", "2024-05-31 03:15:42", "2024-05-31 03:15:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1315", "1089141", "action created", "2024-05-31 03:15:42", "2024-05-31 03:15:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1316", "1089141", "action started via WP Cron", "2024-05-31 03:28:14", "2024-05-31 03:28:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1317", "1089141", "action complete via WP Cron", "2024-05-31 03:28:14", "2024-05-31 03:28:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1318", "1089142", "action created", "2024-05-31 03:28:14", "2024-05-31 03:28:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1319", "1089142", "action started via WP Cron", "2024-05-31 03:31:30", "2024-05-31 03:31:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1320", "1089142", "action complete via WP Cron", "2024-05-31 03:31:30", "2024-05-31 03:31:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1321", "1089143", "action created", "2024-05-31 03:31:30", "2024-05-31 03:31:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1322", "1089143", "action started via WP Cron", "2024-05-31 03:44:52", "2024-05-31 03:44:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1323", "1089143", "action complete via WP Cron", "2024-05-31 03:44:52", "2024-05-31 03:44:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1324", "1089144", "action created", "2024-05-31 03:44:52", "2024-05-31 03:44:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1325", "1089144", "action started via WP Cron", "2024-05-31 03:48:04", "2024-05-31 03:48:04");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1326", "1089144", "action complete via WP Cron", "2024-05-31 03:48:05", "2024-05-31 03:48:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1327", "1089145", "action created", "2024-05-31 03:48:05", "2024-05-31 03:48:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1328", "1089145", "action started via WP Cron", "2024-05-31 04:01:28", "2024-05-31 04:01:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1329", "1089145", "action complete via WP Cron", "2024-05-31 04:01:28", "2024-05-31 04:01:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1330", "1089146", "action created", "2024-05-31 04:01:28", "2024-05-31 04:01:28");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1331", "1089146", "action started via WP Cron", "2024-05-31 04:04:43", "2024-05-31 04:04:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1332", "1089146", "action complete via WP Cron", "2024-05-31 04:04:43", "2024-05-31 04:04:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1333", "1089147", "action created", "2024-05-31 04:04:43", "2024-05-31 04:04:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1334", "1089147", "action started via WP Cron", "2024-05-31 04:16:55", "2024-05-31 04:16:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1335", "1089147", "action complete via WP Cron", "2024-05-31 04:16:55", "2024-05-31 04:16:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1336", "1089148", "action created", "2024-05-31 04:16:55", "2024-05-31 04:16:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1337", "1089148", "action started via WP Cron", "2024-05-31 04:18:17", "2024-05-31 04:18:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1338", "1089148", "action complete via WP Cron", "2024-05-31 04:18:17", "2024-05-31 04:18:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1339", "1089149", "action created", "2024-05-31 04:18:17", "2024-05-31 04:18:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1340", "1089149", "action started via WP Cron", "2024-05-31 04:22:24", "2024-05-31 04:22:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1341", "1089149", "action complete via WP Cron", "2024-05-31 04:22:24", "2024-05-31 04:22:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1342", "1089150", "action created", "2024-05-31 04:22:24", "2024-05-31 04:22:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1343", "1089150", "action started via WP Cron", "2024-05-31 04:35:03", "2024-05-31 04:35:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1344", "1089150", "action complete via WP Cron", "2024-05-31 04:35:03", "2024-05-31 04:35:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1345", "1089151", "action created", "2024-05-31 04:35:03", "2024-05-31 04:35:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1346", "1089151", "action started via WP Cron", "2024-05-31 04:39:11", "2024-05-31 04:39:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1347", "1089151", "action complete via WP Cron", "2024-05-31 04:39:11", "2024-05-31 04:39:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1348", "1089152", "action created", "2024-05-31 04:39:11", "2024-05-31 04:39:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1349", "1089152", "action started via WP Cron", "2024-05-31 04:51:48", "2024-05-31 04:51:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1350", "1089152", "action complete via WP Cron", "2024-05-31 04:51:48", "2024-05-31 04:51:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1351", "1089153", "action created", "2024-05-31 04:51:49", "2024-05-31 04:51:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1352", "1089153", "action started via WP Cron", "2024-05-31 04:55:06", "2024-05-31 04:55:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1353", "1089153", "action complete via WP Cron", "2024-05-31 04:55:06", "2024-05-31 04:55:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1354", "1089154", "action created", "2024-05-31 04:55:06", "2024-05-31 04:55:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1355", "1089154", "action started via WP Cron", "2024-05-31 05:01:33", "2024-05-31 05:01:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1356", "1089154", "action complete via WP Cron", "2024-05-31 05:01:33", "2024-05-31 05:01:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1357", "1089155", "action created", "2024-05-31 05:01:33", "2024-05-31 05:01:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1358", "1089155", "action started via WP Cron", "2024-05-31 05:08:38", "2024-05-31 05:08:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1359", "1089155", "action complete via WP Cron", "2024-05-31 05:08:38", "2024-05-31 05:08:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1360", "1089156", "action created", "2024-05-31 05:08:38", "2024-05-31 05:08:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1361", "1089156", "action started via WP Cron", "2024-05-31 05:11:53", "2024-05-31 05:11:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1362", "1089156", "action complete via WP Cron", "2024-05-31 05:11:53", "2024-05-31 05:11:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1363", "1089157", "action created", "2024-05-31 05:11:53", "2024-05-31 05:11:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1364", "1089157", "action started via WP Cron", "2024-05-31 05:25:22", "2024-05-31 05:25:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1365", "1089157", "action complete via WP Cron", "2024-05-31 05:25:22", "2024-05-31 05:25:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1366", "1089158", "action created", "2024-05-31 05:25:22", "2024-05-31 05:25:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1367", "1089158", "action started via WP Cron", "2024-05-31 05:28:35", "2024-05-31 05:28:35");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1368", "1089158", "action complete via WP Cron", "2024-05-31 05:28:36", "2024-05-31 05:28:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1369", "1089159", "action created", "2024-05-31 05:28:36", "2024-05-31 05:28:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1370", "1089159", "action started via WP Cron", "2024-05-31 05:42:01", "2024-05-31 05:42:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1371", "1089159", "action complete via WP Cron", "2024-05-31 05:42:01", "2024-05-31 05:42:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1372", "1089160", "action created", "2024-05-31 05:42:01", "2024-05-31 05:42:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1373", "1089160", "action started via WP Cron", "2024-05-31 05:45:12", "2024-05-31 05:45:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1374", "1089160", "action complete via WP Cron", "2024-05-31 05:45:12", "2024-05-31 05:45:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1375", "1089161", "action created", "2024-05-31 05:45:12", "2024-05-31 05:45:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1376", "1089161", "action started via WP Cron", "2024-05-31 05:58:36", "2024-05-31 05:58:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1377", "1089161", "action complete via WP Cron", "2024-05-31 05:58:36", "2024-05-31 05:58:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1378", "1089162", "action created", "2024-05-31 05:58:36", "2024-05-31 05:58:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1379", "1089162", "action started via WP Cron", "2024-05-31 06:01:56", "2024-05-31 06:01:56");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1380", "1089162", "action complete via WP Cron", "2024-05-31 06:01:57", "2024-05-31 06:01:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1381", "1089163", "action created", "2024-05-31 06:01:57", "2024-05-31 06:01:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1382", "1089163", "action started via WP Cron", "2024-05-31 06:15:19", "2024-05-31 06:15:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1383", "1089163", "action complete via WP Cron", "2024-05-31 06:15:20", "2024-05-31 06:15:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1384", "1089164", "action created", "2024-05-31 06:15:20", "2024-05-31 06:15:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1385", "1089164", "action started via WP Cron", "2024-05-31 06:18:34", "2024-05-31 06:18:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1386", "1089164", "action complete via WP Cron", "2024-05-31 06:18:34", "2024-05-31 06:18:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1387", "1089165", "action created", "2024-05-31 06:18:34", "2024-05-31 06:18:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1388", "1089165", "action started via WP Cron", "2024-05-31 06:32:04", "2024-05-31 06:32:04");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1389", "1089165", "action complete via WP Cron", "2024-05-31 06:32:04", "2024-05-31 06:32:04");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1390", "1089166", "action created", "2024-05-31 06:32:04", "2024-05-31 06:32:04");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1391", "1089166", "action started via WP Cron", "2024-05-31 06:35:23", "2024-05-31 06:35:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1392", "1089166", "action complete via WP Cron", "2024-05-31 06:35:23", "2024-05-31 06:35:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1393", "1089167", "action created", "2024-05-31 06:35:23", "2024-05-31 06:35:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1394", "1089167", "action started via WP Cron", "2024-05-31 06:49:09", "2024-05-31 06:49:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1395", "1089167", "action complete via WP Cron", "2024-05-31 06:49:09", "2024-05-31 06:49:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1396", "1089168", "action created", "2024-05-31 06:49:09", "2024-05-31 06:49:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1397", "1089168", "action started via WP Cron", "2024-05-31 06:52:26", "2024-05-31 06:52:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1398", "1089168", "action complete via WP Cron", "2024-05-31 06:52:26", "2024-05-31 06:52:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1399", "1089169", "action created", "2024-05-31 06:52:26", "2024-05-31 06:52:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1400", "1089169", "action started via WP Cron", "2024-05-31 07:06:02", "2024-05-31 07:06:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1401", "1089169", "action complete via WP Cron", "2024-05-31 07:06:02", "2024-05-31 07:06:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1402", "1089170", "action created", "2024-05-31 07:06:02", "2024-05-31 07:06:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1403", "1089170", "action started via WP Cron", "2024-05-31 07:09:21", "2024-05-31 07:09:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1404", "1089170", "action complete via WP Cron", "2024-05-31 07:09:21", "2024-05-31 07:09:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1405", "1089171", "action created", "2024-05-31 07:09:21", "2024-05-31 07:09:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1406", "1089171", "action started via WP Cron", "2024-05-31 07:23:03", "2024-05-31 07:23:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1407", "1089171", "action complete via WP Cron", "2024-05-31 07:23:03", "2024-05-31 07:23:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1408", "1089172", "action created", "2024-05-31 07:23:03", "2024-05-31 07:23:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1409", "1089172", "action started via WP Cron", "2024-05-31 07:26:21", "2024-05-31 07:26:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1410", "1089172", "action complete via WP Cron", "2024-05-31 07:26:21", "2024-05-31 07:26:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1411", "1089173", "action created", "2024-05-31 07:26:21", "2024-05-31 07:26:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1412", "1089173", "action started via WP Cron", "2024-05-31 07:40:01", "2024-05-31 07:40:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1413", "1089173", "action complete via WP Cron", "2024-05-31 07:40:01", "2024-05-31 07:40:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1414", "1089174", "action created", "2024-05-31 07:40:02", "2024-05-31 07:40:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1415", "1089174", "action started via WP Cron", "2024-05-31 07:43:19", "2024-05-31 07:43:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1416", "1089174", "action complete via WP Cron", "2024-05-31 07:43:20", "2024-05-31 07:43:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1417", "1089175", "action created", "2024-05-31 07:43:20", "2024-05-31 07:43:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1418", "1089175", "action started via WP Cron", "2024-05-31 07:56:46", "2024-05-31 07:56:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1419", "1089175", "action complete via WP Cron", "2024-05-31 07:56:46", "2024-05-31 07:56:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1420", "1089176", "action created", "2024-05-31 07:56:46", "2024-05-31 07:56:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1421", "1089176", "action started via WP Cron", "2024-05-31 08:00:12", "2024-05-31 08:00:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1422", "1089176", "action complete via WP Cron", "2024-05-31 08:00:13", "2024-05-31 08:00:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1423", "1089177", "action created", "2024-05-31 08:00:13", "2024-05-31 08:00:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1424", "1089177", "action started via WP Cron", "2024-05-31 08:13:29", "2024-05-31 08:13:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1425", "1089177", "action complete via WP Cron", "2024-05-31 08:13:29", "2024-05-31 08:13:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1426", "1089178", "action created", "2024-05-31 08:13:29", "2024-05-31 08:13:29");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1427", "1089178", "action started via WP Cron", "2024-05-31 08:16:44", "2024-05-31 08:16:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1428", "1089178", "action complete via WP Cron", "2024-05-31 08:16:44", "2024-05-31 08:16:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1429", "1089179", "action created", "2024-05-31 08:16:44", "2024-05-31 08:16:44");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1430", "1089179", "action started via WP Cron", "2024-05-31 08:30:01", "2024-05-31 08:30:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1431", "1089179", "action complete via WP Cron", "2024-05-31 08:30:01", "2024-05-31 08:30:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1432", "1089180", "action created", "2024-05-31 08:30:01", "2024-05-31 08:30:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1433", "1089180", "action started via WP Cron", "2024-05-31 08:33:15", "2024-05-31 08:33:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1434", "1089180", "action complete via WP Cron", "2024-05-31 08:33:15", "2024-05-31 08:33:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1435", "1089181", "action created", "2024-05-31 08:33:15", "2024-05-31 08:33:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1436", "1089181", "action started via WP Cron", "2024-05-31 08:46:48", "2024-05-31 08:46:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1437", "1089181", "action complete via WP Cron", "2024-05-31 08:46:48", "2024-05-31 08:46:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1438", "1089182", "action created", "2024-05-31 08:46:48", "2024-05-31 08:46:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1439", "1089182", "action started via WP Cron", "2024-05-31 08:50:03", "2024-05-31 08:50:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1440", "1089182", "action complete via WP Cron", "2024-05-31 08:50:03", "2024-05-31 08:50:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1441", "1089183", "action created", "2024-05-31 08:50:03", "2024-05-31 08:50:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1442", "1089183", "action started via WP Cron", "2024-05-31 09:06:41", "2024-05-31 09:06:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1443", "1089183", "action complete via WP Cron", "2024-05-31 09:06:41", "2024-05-31 09:06:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1444", "1089184", "action created", "2024-05-31 09:06:41", "2024-05-31 09:06:41");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1445", "1089184", "action started via WP Cron", "2024-05-31 09:20:09", "2024-05-31 09:20:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1446", "1089184", "action complete via WP Cron", "2024-05-31 09:20:09", "2024-05-31 09:20:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1447", "1089185", "action created", "2024-05-31 09:20:10", "2024-05-31 09:20:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1448", "1089185", "action started via WP Cron", "2024-05-31 09:23:25", "2024-05-31 09:23:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1449", "1089185", "action complete via WP Cron", "2024-05-31 09:23:25", "2024-05-31 09:23:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1450", "1089186", "action created", "2024-05-31 09:23:25", "2024-05-31 09:23:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1451", "1089186", "action started via WP Cron", "2024-05-31 09:28:14", "2024-05-31 09:28:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1452", "1089186", "action complete via WP Cron", "2024-05-31 09:28:14", "2024-05-31 09:28:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1453", "1089187", "action created", "2024-05-31 09:28:14", "2024-05-31 09:28:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1454", "1089187", "action started via WP Cron", "2024-05-31 09:36:53", "2024-05-31 09:36:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1455", "1089187", "action complete via WP Cron", "2024-05-31 09:36:53", "2024-05-31 09:36:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1456", "1089188", "action created", "2024-05-31 09:36:53", "2024-05-31 09:36:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1457", "1089188", "action started via WP Cron", "2024-05-31 09:40:14", "2024-05-31 09:40:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1458", "1089188", "action complete via WP Cron", "2024-05-31 09:40:14", "2024-05-31 09:40:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1459", "1089189", "action created", "2024-05-31 09:40:14", "2024-05-31 09:40:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1460", "1089189", "action started via WP Cron", "2024-05-31 09:45:30", "2024-05-31 09:45:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1461", "1089189", "action complete via WP Cron", "2024-05-31 09:45:31", "2024-05-31 09:45:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1462", "1089190", "action created", "2024-05-31 09:45:31", "2024-05-31 09:45:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1463", "1089190", "action started via WP Cron", "2024-05-31 09:53:30", "2024-05-31 09:53:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1464", "1089190", "action complete via WP Cron", "2024-05-31 09:53:30", "2024-05-31 09:53:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1465", "1089191", "action created", "2024-05-31 09:53:30", "2024-05-31 09:53:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1466", "1089191", "action started via WP Cron", "2024-05-31 09:55:39", "2024-05-31 09:55:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1467", "1089191", "action complete via WP Cron", "2024-05-31 09:55:39", "2024-05-31 09:55:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1468", "1089192", "action created", "2024-05-31 09:55:39", "2024-05-31 09:55:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1469", "1089192", "action started via WP Cron", "2024-05-31 10:04:11", "2024-05-31 10:04:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1470", "1089192", "action complete via WP Cron", "2024-05-31 10:04:11", "2024-05-31 10:04:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1471", "1089193", "action created", "2024-05-31 10:04:11", "2024-05-31 10:04:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1472", "1089193", "action started via WP Cron", "2024-05-31 10:07:25", "2024-05-31 10:07:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1473", "1089193", "action complete via WP Cron", "2024-05-31 10:07:25", "2024-05-31 10:07:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1474", "1089194", "action created", "2024-05-31 10:07:25", "2024-05-31 10:07:25");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1475", "1089194", "action started via WP Cron", "2024-05-31 10:20:54", "2024-05-31 10:20:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1476", "1089194", "action complete via WP Cron", "2024-05-31 10:20:54", "2024-05-31 10:20:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1477", "1089195", "action created", "2024-05-31 10:20:54", "2024-05-31 10:20:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1478", "1089195", "action started via WP Cron", "2024-05-31 10:24:09", "2024-05-31 10:24:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1479", "1089195", "action complete via WP Cron", "2024-05-31 10:24:09", "2024-05-31 10:24:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1480", "1089196", "action created", "2024-05-31 10:24:09", "2024-05-31 10:24:09");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1481", "1089196", "action started via WP Cron", "2024-05-31 10:37:37", "2024-05-31 10:37:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1482", "1089196", "action complete via WP Cron", "2024-05-31 10:37:37", "2024-05-31 10:37:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1483", "1089197", "action created", "2024-05-31 10:37:37", "2024-05-31 10:37:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1484", "1089197", "action started via WP Cron", "2024-05-31 10:40:54", "2024-05-31 10:40:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1485", "1089197", "action complete via WP Cron", "2024-05-31 10:40:54", "2024-05-31 10:40:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1486", "1089198", "action created", "2024-05-31 10:40:54", "2024-05-31 10:40:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1487", "1089198", "action started via WP Cron", "2024-05-31 10:54:14", "2024-05-31 10:54:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1488", "1089198", "action complete via WP Cron", "2024-05-31 10:54:14", "2024-05-31 10:54:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1489", "1089199", "action created", "2024-05-31 10:54:14", "2024-05-31 10:54:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1490", "1089199", "action started via WP Cron", "2024-05-31 10:57:27", "2024-05-31 10:57:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1491", "1089199", "action complete via WP Cron", "2024-05-31 10:57:27", "2024-05-31 10:57:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1492", "1089200", "action created", "2024-05-31 10:57:27", "2024-05-31 10:57:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1493", "1089200", "action started via WP Cron", "2024-05-31 11:10:54", "2024-05-31 11:10:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1494", "1089200", "action complete via WP Cron", "2024-05-31 11:10:54", "2024-05-31 11:10:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1495", "1089201", "action created", "2024-05-31 11:10:54", "2024-05-31 11:10:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1496", "1089201", "action started via WP Cron", "2024-05-31 11:14:14", "2024-05-31 11:14:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1497", "1089201", "action complete via WP Cron", "2024-05-31 11:14:14", "2024-05-31 11:14:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1498", "1089202", "action created", "2024-05-31 11:14:14", "2024-05-31 11:14:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1499", "1089202", "action started via WP Cron", "2024-05-31 11:27:31", "2024-05-31 11:27:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1500", "1089202", "action complete via WP Cron", "2024-05-31 11:27:31", "2024-05-31 11:27:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1501", "1089203", "action created", "2024-05-31 11:27:31", "2024-05-31 11:27:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1502", "1089203", "action started via WP Cron", "2024-05-31 11:30:47", "2024-05-31 11:30:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1503", "1089203", "action complete via WP Cron", "2024-05-31 11:30:47", "2024-05-31 11:30:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1504", "1089204", "action created", "2024-05-31 11:30:47", "2024-05-31 11:30:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1505", "1089204", "action started via WP Cron", "2024-05-31 11:41:11", "2024-05-31 11:41:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1506", "1089204", "action complete via WP Cron", "2024-05-31 11:41:11", "2024-05-31 11:41:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1507", "1089205", "action created", "2024-05-31 11:41:11", "2024-05-31 11:41:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1508", "1089205", "action started via WP Cron", "2024-05-31 11:42:15", "2024-05-31 11:42:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1509", "1089205", "action complete via WP Cron", "2024-05-31 11:42:15", "2024-05-31 11:42:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1510", "1089206", "action created", "2024-05-31 11:42:15", "2024-05-31 11:42:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1511", "1089206", "action started via WP Cron", "2024-05-31 11:47:05", "2024-05-31 11:47:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1512", "1089206", "action complete via WP Cron", "2024-05-31 11:47:05", "2024-05-31 11:47:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1513", "1089207", "action created", "2024-05-31 11:47:05", "2024-05-31 11:47:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1514", "1089207", "action started via WP Cron", "2024-05-31 12:03:30", "2024-05-31 12:03:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1515", "1089207", "action complete via WP Cron", "2024-05-31 12:03:30", "2024-05-31 12:03:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1516", "1089208", "action created", "2024-05-31 12:03:30", "2024-05-31 12:03:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1517", "1089208", "action started via WP Cron", "2024-05-31 12:20:10", "2024-05-31 12:20:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1518", "1089208", "action complete via WP Cron", "2024-05-31 12:20:10", "2024-05-31 12:20:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1519", "1089209", "action created", "2024-05-31 12:20:10", "2024-05-31 12:20:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1520", "1089209", "action started via WP Cron", "2024-05-31 12:33:26", "2024-05-31 12:33:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1521", "1089209", "action complete via WP Cron", "2024-05-31 12:33:26", "2024-05-31 12:33:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1522", "1089210", "action created", "2024-05-31 12:33:26", "2024-05-31 12:33:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1523", "1089210", "action started via WP Cron", "2024-05-31 12:36:40", "2024-05-31 12:36:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1524", "1089210", "action complete via WP Cron", "2024-05-31 12:36:40", "2024-05-31 12:36:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1525", "1089211", "action created", "2024-05-31 12:36:40", "2024-05-31 12:36:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1526", "1089211", "action started via WP Cron", "2024-05-31 12:50:00", "2024-05-31 12:50:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1527", "1089211", "action complete via WP Cron", "2024-05-31 12:50:00", "2024-05-31 12:50:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1528", "1089212", "action created", "2024-05-31 12:50:00", "2024-05-31 12:50:00");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1529", "1089212", "action started via WP Cron", "2024-05-31 12:53:15", "2024-05-31 12:53:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1530", "1089212", "action complete via WP Cron", "2024-05-31 12:53:15", "2024-05-31 12:53:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1531", "1089213", "action created", "2024-05-31 12:53:15", "2024-05-31 12:53:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1532", "1089213", "action started via WP Cron", "2024-05-31 13:06:47", "2024-05-31 13:06:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1533", "1089213", "action complete via WP Cron", "2024-05-31 13:06:47", "2024-05-31 13:06:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1534", "1089214", "action created", "2024-05-31 13:06:48", "2024-05-31 13:06:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1535", "1089214", "action started via WP Cron", "2024-05-31 13:10:03", "2024-05-31 13:10:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1536", "1089214", "action complete via WP Cron", "2024-05-31 13:10:03", "2024-05-31 13:10:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1537", "1089215", "action created", "2024-05-31 13:10:03", "2024-05-31 13:10:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1538", "1089215", "action started via WP Cron", "2024-05-31 13:23:27", "2024-05-31 13:23:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1539", "1089215", "action complete via WP Cron", "2024-05-31 13:23:27", "2024-05-31 13:23:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1540", "1089216", "action created", "2024-05-31 13:23:27", "2024-05-31 13:23:27");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1541", "1089216", "action started via WP Cron", "2024-05-31 13:26:55", "2024-05-31 13:26:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1542", "1089216", "action complete via WP Cron", "2024-05-31 13:26:55", "2024-05-31 13:26:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1543", "1089217", "action created", "2024-05-31 13:26:55", "2024-05-31 13:26:55");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1544", "1089217", "action started via WP Cron", "2024-05-31 13:40:30", "2024-05-31 13:40:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1545", "1089217", "action complete via WP Cron", "2024-05-31 13:40:30", "2024-05-31 13:40:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1546", "1089218", "action created", "2024-05-31 13:40:30", "2024-05-31 13:40:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1547", "1089218", "action started via WP Cron", "2024-05-31 13:43:46", "2024-05-31 13:43:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1548", "1089218", "action complete via WP Cron", "2024-05-31 13:43:46", "2024-05-31 13:43:46");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1549", "1089219", "action created", "2024-05-31 13:43:47", "2024-05-31 13:43:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1550", "1089219", "action started via WP Cron", "2024-05-31 13:57:22", "2024-05-31 13:57:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1551", "1089219", "action complete via WP Cron", "2024-05-31 13:57:22", "2024-05-31 13:57:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1552", "1089220", "action created", "2024-05-31 13:57:22", "2024-05-31 13:57:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1553", "1089220", "action started via WP Cron", "2024-05-31 14:00:40", "2024-05-31 14:00:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1554", "1089220", "action complete via WP Cron", "2024-05-31 14:00:40", "2024-05-31 14:00:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1555", "1089221", "action created", "2024-05-31 14:00:40", "2024-05-31 14:00:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1556", "1089221", "action started via WP Cron", "2024-05-31 14:14:20", "2024-05-31 14:14:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1557", "1089221", "action complete via WP Cron", "2024-05-31 14:14:20", "2024-05-31 14:14:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1558", "1089222", "action created", "2024-05-31 14:14:20", "2024-05-31 14:14:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1559", "1089222", "action started via WP Cron", "2024-05-31 14:17:40", "2024-05-31 14:17:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1560", "1089222", "action complete via WP Cron", "2024-05-31 14:17:40", "2024-05-31 14:17:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1561", "1089223", "action created", "2024-05-31 14:17:40", "2024-05-31 14:17:40");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1562", "1089223", "action started via WP Cron", "2024-05-31 14:31:14", "2024-05-31 14:31:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1563", "1089223", "action complete via WP Cron", "2024-05-31 14:31:14", "2024-05-31 14:31:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1564", "1089224", "action created", "2024-05-31 14:31:14", "2024-05-31 14:31:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1565", "1089224", "action started via WP Cron", "2024-05-31 14:34:30", "2024-05-31 14:34:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1566", "1089224", "action complete via WP Cron", "2024-05-31 14:34:30", "2024-05-31 14:34:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1567", "1089225", "action created", "2024-05-31 14:34:30", "2024-05-31 14:34:30");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1568", "1089225", "action started via WP Cron", "2024-05-31 14:45:37", "2024-05-31 14:45:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1569", "1089225", "action complete via WP Cron", "2024-05-31 14:45:37", "2024-05-31 14:45:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1570", "1089226", "action created", "2024-05-31 14:45:37", "2024-05-31 14:45:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1571", "1089226", "action started via WP Cron", "2024-05-31 14:48:05", "2024-05-31 14:48:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1572", "1089226", "action complete via WP Cron", "2024-05-31 14:48:05", "2024-05-31 14:48:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1573", "1089227", "action created", "2024-05-31 14:48:05", "2024-05-31 14:48:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1574", "1089227", "action started via WP Cron", "2024-05-31 14:51:22", "2024-05-31 14:51:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1575", "1089227", "action complete via WP Cron", "2024-05-31 14:51:22", "2024-05-31 14:51:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1576", "1089228", "action created", "2024-05-31 14:51:22", "2024-05-31 14:51:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1577", "1089228", "action started via WP Cron", "2024-05-31 15:04:59", "2024-05-31 15:04:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1578", "1089228", "action complete via WP Cron", "2024-05-31 15:04:59", "2024-05-31 15:04:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1579", "1089229", "action created", "2024-05-31 15:04:59", "2024-05-31 15:04:59");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1580", "1089229", "action started via WP Cron", "2024-05-31 15:08:19", "2024-05-31 15:08:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1581", "1089229", "action complete via WP Cron", "2024-05-31 15:08:19", "2024-05-31 15:08:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1582", "1089230", "action created", "2024-05-31 15:08:19", "2024-05-31 15:08:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1583", "1089230", "action started via WP Cron", "2024-05-31 15:22:05", "2024-05-31 15:22:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1584", "1089230", "action complete via WP Cron", "2024-05-31 15:22:06", "2024-05-31 15:22:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1585", "1089231", "action created", "2024-05-31 15:22:06", "2024-05-31 15:22:06");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1586", "1089231", "action started via WP Cron", "2024-05-31 15:25:22", "2024-05-31 15:25:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1587", "1089231", "action complete via WP Cron", "2024-05-31 15:25:22", "2024-05-31 15:25:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1588", "1089232", "action created", "2024-05-31 15:25:22", "2024-05-31 15:25:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1589", "1089232", "action started via WP Cron", "2024-05-31 15:39:10", "2024-05-31 15:39:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1590", "1089232", "action complete via WP Cron", "2024-05-31 15:39:10", "2024-05-31 15:39:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1591", "1089233", "action created", "2024-05-31 15:39:10", "2024-05-31 15:39:10");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1592", "1089233", "action started via WP Cron", "2024-05-31 15:42:32", "2024-05-31 15:42:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1593", "1089233", "action complete via WP Cron", "2024-05-31 15:42:32", "2024-05-31 15:42:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1594", "1089234", "action created", "2024-05-31 15:42:32", "2024-05-31 15:42:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1595", "1089234", "action started via WP Cron", "2024-05-31 15:56:13", "2024-05-31 15:56:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1596", "1089234", "action complete via WP Cron", "2024-05-31 15:56:13", "2024-05-31 15:56:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1597", "1089235", "action created", "2024-05-31 15:56:13", "2024-05-31 15:56:13");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1598", "1089235", "action started via WP Cron", "2024-05-31 15:59:57", "2024-05-31 15:59:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1599", "1089235", "action complete via WP Cron", "2024-05-31 15:59:58", "2024-05-31 15:59:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1600", "1089236", "action created", "2024-05-31 15:59:58", "2024-05-31 15:59:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1601", "1089236", "action started via WP Cron", "2024-05-31 16:13:52", "2024-05-31 16:13:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1602", "1089236", "action complete via WP Cron", "2024-05-31 16:13:52", "2024-05-31 16:13:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1603", "1089237", "action created", "2024-05-31 16:13:52", "2024-05-31 16:13:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1604", "1089237", "action started via WP Cron", "2024-05-31 16:17:18", "2024-05-31 16:17:18");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1605", "1089237", "action complete via WP Cron", "2024-05-31 16:17:19", "2024-05-31 16:17:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1606", "1089238", "action created", "2024-05-31 16:17:19", "2024-05-31 16:17:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1607", "1089238", "action started via WP Cron", "2024-05-31 16:31:19", "2024-05-31 16:31:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1608", "1089238", "action complete via WP Cron", "2024-05-31 16:31:19", "2024-05-31 16:31:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1609", "1089239", "action created", "2024-05-31 16:31:19", "2024-05-31 16:31:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1610", "1089239", "action started via WP Cron", "2024-05-31 16:34:43", "2024-05-31 16:34:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1611", "1089239", "action complete via WP Cron", "2024-05-31 16:34:43", "2024-05-31 16:34:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1612", "1089240", "action created", "2024-05-31 16:34:43", "2024-05-31 16:34:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1613", "1089240", "action started via WP Cron", "2024-05-31 16:48:38", "2024-05-31 16:48:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1614", "1089240", "action complete via WP Cron", "2024-05-31 16:48:38", "2024-05-31 16:48:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1615", "1089241", "action created", "2024-05-31 16:48:38", "2024-05-31 16:48:38");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1616", "1089241", "action started via WP Cron", "2024-05-31 16:52:03", "2024-05-31 16:52:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1617", "1089241", "action complete via WP Cron", "2024-05-31 16:52:03", "2024-05-31 16:52:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1618", "1089242", "action created", "2024-05-31 16:52:03", "2024-05-31 16:52:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1619", "1089242", "action started via WP Cron", "2024-05-31 17:06:03", "2024-05-31 17:06:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1620", "1089242", "action complete via WP Cron", "2024-05-31 17:06:03", "2024-05-31 17:06:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1621", "1089243", "action created", "2024-05-31 17:06:03", "2024-05-31 17:06:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1622", "1089243", "action started via WP Cron", "2024-05-31 17:09:24", "2024-05-31 17:09:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1623", "1089243", "action complete via WP Cron", "2024-05-31 17:09:24", "2024-05-31 17:09:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1624", "1089244", "action created", "2024-05-31 17:09:24", "2024-05-31 17:09:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1625", "1089244", "action started via WP Cron", "2024-05-31 17:23:23", "2024-05-31 17:23:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1626", "1089244", "action complete via WP Cron", "2024-05-31 17:23:23", "2024-05-31 17:23:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1627", "1089245", "action created", "2024-05-31 17:23:23", "2024-05-31 17:23:23");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1628", "1089245", "action started via WP Cron", "2024-05-31 17:26:47", "2024-05-31 17:26:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1629", "1089245", "action complete via WP Cron", "2024-05-31 17:26:47", "2024-05-31 17:26:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1630", "1089246", "action created", "2024-05-31 17:26:47", "2024-05-31 17:26:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1631", "1089246", "action started via WP Cron", "2024-05-31 17:40:52", "2024-05-31 17:40:52");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1632", "1089246", "action complete via WP Cron", "2024-05-31 17:40:53", "2024-05-31 17:40:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1633", "1089247", "action created", "2024-05-31 17:40:53", "2024-05-31 17:40:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1634", "1089247", "action started via WP Cron", "2024-05-31 17:44:14", "2024-05-31 17:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1635", "1089247", "action complete via WP Cron", "2024-05-31 17:44:14", "2024-05-31 17:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1636", "1089248", "action created", "2024-05-31 17:44:14", "2024-05-31 17:44:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1637", "1089248", "action started via WP Cron", "2024-05-31 17:45:50", "2024-05-31 17:45:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1638", "1089248", "action complete via WP Cron", "2024-05-31 17:45:51", "2024-05-31 17:45:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1639", "1089249", "action created", "2024-05-31 17:45:51", "2024-05-31 17:45:51");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1640", "1089249", "action started via WP Cron", "2024-05-31 17:58:15", "2024-05-31 17:58:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1641", "1089249", "action complete via WP Cron", "2024-05-31 17:58:15", "2024-05-31 17:58:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1642", "1089250", "action created", "2024-05-31 17:58:15", "2024-05-31 17:58:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1643", "1089250", "action started via WP Cron", "2024-05-31 18:01:39", "2024-05-31 18:01:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1644", "1089250", "action complete via WP Cron", "2024-05-31 18:01:39", "2024-05-31 18:01:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1645", "1089251", "action created", "2024-05-31 18:01:39", "2024-05-31 18:01:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1646", "1089251", "action started via WP Cron", "2024-05-31 18:15:37", "2024-05-31 18:15:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1647", "1089251", "action complete via WP Cron", "2024-05-31 18:15:37", "2024-05-31 18:15:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1648", "1089252", "action created", "2024-05-31 18:15:37", "2024-05-31 18:15:37");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1649", "1089252", "action started via WP Cron", "2024-05-31 18:19:01", "2024-05-31 18:19:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1650", "1089252", "action complete via WP Cron", "2024-05-31 18:19:01", "2024-05-31 18:19:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1651", "1089253", "action created", "2024-05-31 18:19:01", "2024-05-31 18:19:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1652", "1089253", "action started via WP Cron", "2024-05-31 18:33:02", "2024-05-31 18:33:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1653", "1089253", "action complete via WP Cron", "2024-05-31 18:33:03", "2024-05-31 18:33:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1654", "1089254", "action created", "2024-05-31 18:33:03", "2024-05-31 18:33:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1655", "1089254", "action started via WP Cron", "2024-05-31 18:36:21", "2024-05-31 18:36:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1656", "1089254", "action complete via WP Cron", "2024-05-31 18:36:21", "2024-05-31 18:36:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1657", "1089255", "action created", "2024-05-31 18:36:21", "2024-05-31 18:36:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1658", "1089255", "action started via WP Cron", "2024-05-31 18:44:57", "2024-05-31 18:44:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1659", "1089255", "action complete via WP Cron", "2024-05-31 18:44:57", "2024-05-31 18:44:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1660", "1089256", "action created", "2024-05-31 18:44:57", "2024-05-31 18:44:57");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1661", "1089256", "action started via WP Cron", "2024-05-31 18:50:01", "2024-05-31 18:50:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1662", "1089256", "action complete via WP Cron", "2024-05-31 18:50:01", "2024-05-31 18:50:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1663", "1089257", "action created", "2024-05-31 18:50:01", "2024-05-31 18:50:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1664", "1089257", "action started via WP Cron", "2024-05-31 18:53:19", "2024-05-31 18:53:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1665", "1089257", "action complete via WP Cron", "2024-05-31 18:53:19", "2024-05-31 18:53:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1666", "1089258", "action created", "2024-05-31 18:53:19", "2024-05-31 18:53:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1667", "1089258", "action started via WP Cron", "2024-05-31 19:06:54", "2024-05-31 19:06:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1668", "1089258", "action complete via WP Cron", "2024-05-31 19:06:54", "2024-05-31 19:06:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1669", "1089259", "action created", "2024-05-31 19:06:54", "2024-05-31 19:06:54");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1670", "1089259", "action started via WP Cron", "2024-05-31 19:10:11", "2024-05-31 19:10:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1671", "1089259", "action complete via WP Cron", "2024-05-31 19:10:11", "2024-05-31 19:10:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1672", "1089260", "action created", "2024-05-31 19:10:11", "2024-05-31 19:10:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1673", "1089260", "action started via WP Cron", "2024-05-31 19:23:42", "2024-05-31 19:23:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1674", "1089260", "action complete via WP Cron", "2024-05-31 19:23:42", "2024-05-31 19:23:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1675", "1089261", "action created", "2024-05-31 19:23:42", "2024-05-31 19:23:42");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1676", "1089261", "action started via WP Cron", "2024-05-31 19:26:20", "2024-05-31 19:26:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1677", "1089261", "action complete via WP Cron", "2024-05-31 19:26:20", "2024-05-31 19:26:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1678", "1089262", "action created", "2024-05-31 19:26:20", "2024-05-31 19:26:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1679", "1089262", "action started via WP Cron", "2024-05-31 19:27:49", "2024-05-31 19:27:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1680", "1089262", "action complete via WP Cron", "2024-05-31 19:27:49", "2024-05-31 19:27:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1681", "1089263", "action created", "2024-05-31 19:27:49", "2024-05-31 19:27:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1682", "1089263", "action started via WP Cron", "2024-05-31 19:40:19", "2024-05-31 19:40:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1683", "1089263", "action complete via WP Cron", "2024-05-31 19:40:19", "2024-05-31 19:40:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1684", "1089264", "action created", "2024-05-31 19:40:19", "2024-05-31 19:40:19");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1685", "1089264", "action started via WP Cron", "2024-05-31 19:43:34", "2024-05-31 19:43:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1686", "1089264", "action complete via WP Cron", "2024-05-31 19:43:34", "2024-05-31 19:43:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1687", "1089265", "action created", "2024-05-31 19:43:34", "2024-05-31 19:43:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1688", "1089265", "action started via WP Cron", "2024-05-31 19:57:01", "2024-05-31 19:57:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1689", "1089265", "action complete via WP Cron", "2024-05-31 19:57:02", "2024-05-31 19:57:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1690", "1089266", "action created", "2024-05-31 19:57:02", "2024-05-31 19:57:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1691", "1089266", "action started via WP Cron", "2024-05-31 20:00:17", "2024-05-31 20:00:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1692", "1089266", "action complete via WP Cron", "2024-05-31 20:00:17", "2024-05-31 20:00:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1693", "1089267", "action created", "2024-05-31 20:00:17", "2024-05-31 20:00:17");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1694", "1089267", "action started via WP Cron", "2024-05-31 20:13:53", "2024-05-31 20:13:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1695", "1089267", "action complete via WP Cron", "2024-05-31 20:13:53", "2024-05-31 20:13:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1696", "1089268", "action created", "2024-05-31 20:13:53", "2024-05-31 20:13:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1697", "1089268", "action started via WP Cron", "2024-05-31 20:17:14", "2024-05-31 20:17:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1698", "1089268", "action complete via WP Cron", "2024-05-31 20:17:14", "2024-05-31 20:17:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1699", "1089269", "action created", "2024-05-31 20:17:14", "2024-05-31 20:17:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1700", "1089269", "action started via WP Cron", "2024-05-31 20:30:58", "2024-05-31 20:30:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1701", "1089269", "action complete via WP Cron", "2024-05-31 20:30:58", "2024-05-31 20:30:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1702", "1089270", "action created", "2024-05-31 20:30:58", "2024-05-31 20:30:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1703", "1089270", "action started via WP Cron", "2024-05-31 20:34:11", "2024-05-31 20:34:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1704", "1089270", "action complete via WP Cron", "2024-05-31 20:34:11", "2024-05-31 20:34:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1705", "1089271", "action created", "2024-05-31 20:34:11", "2024-05-31 20:34:11");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1706", "1089271", "action started via WP Cron", "2024-05-31 20:47:24", "2024-05-31 20:47:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1707", "1089271", "action complete via WP Cron", "2024-05-31 20:47:24", "2024-05-31 20:47:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1708", "1089272", "action created", "2024-05-31 20:47:24", "2024-05-31 20:47:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1709", "1089272", "action started via WP Cron", "2024-05-31 20:50:36", "2024-05-31 20:50:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1710", "1089272", "action complete via WP Cron", "2024-05-31 20:50:36", "2024-05-31 20:50:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1711", "1089273", "action created", "2024-05-31 20:50:36", "2024-05-31 20:50:36");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1712", "1089273", "action started via WP Cron", "2024-05-31 21:03:49", "2024-05-31 21:03:49");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1713", "1089273", "action complete via WP Cron", "2024-05-31 21:03:50", "2024-05-31 21:03:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1714", "1089274", "action created", "2024-05-31 21:03:50", "2024-05-31 21:03:50");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1715", "1089274", "action started via WP Cron", "2024-05-31 21:07:08", "2024-05-31 21:07:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1716", "1089274", "action complete via WP Cron", "2024-05-31 21:07:08", "2024-05-31 21:07:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1717", "1089275", "action created", "2024-05-31 21:07:08", "2024-05-31 21:07:08");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1718", "1089275", "action started via WP Cron", "2024-05-31 21:20:20", "2024-05-31 21:20:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1719", "1089275", "action complete via WP Cron", "2024-05-31 21:20:20", "2024-05-31 21:20:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1720", "1089276", "action created", "2024-05-31 21:20:20", "2024-05-31 21:20:20");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1721", "1089276", "action started via WP Cron", "2024-05-31 21:23:31", "2024-05-31 21:23:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1722", "1089276", "action complete via WP Cron", "2024-05-31 21:23:31", "2024-05-31 21:23:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1723", "1089277", "action created", "2024-05-31 21:23:31", "2024-05-31 21:23:31");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1724", "1089277", "action started via WP Cron", "2024-05-31 21:36:47", "2024-05-31 21:36:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1725", "1089277", "action complete via WP Cron", "2024-05-31 21:36:47", "2024-05-31 21:36:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1726", "1089278", "action created", "2024-05-31 21:36:47", "2024-05-31 21:36:47");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1727", "1089278", "action started via WP Cron", "2024-05-31 21:39:58", "2024-05-31 21:39:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1728", "1089278", "action complete via WP Cron", "2024-05-31 21:39:58", "2024-05-31 21:39:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1729", "1089279", "action created", "2024-05-31 21:39:58", "2024-05-31 21:39:58");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1730", "1089279", "action started via WP Cron", "2024-05-31 21:53:07", "2024-05-31 21:53:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1731", "1089279", "action complete via WP Cron", "2024-05-31 21:53:07", "2024-05-31 21:53:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1732", "1089280", "action created", "2024-05-31 21:53:07", "2024-05-31 21:53:07");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1733", "1089280", "action started via WP Cron", "2024-05-31 21:56:21", "2024-05-31 21:56:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1734", "1089280", "action complete via WP Cron", "2024-05-31 21:56:21", "2024-05-31 21:56:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1735", "1089281", "action created", "2024-05-31 21:56:21", "2024-05-31 21:56:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1736", "1089281", "action started via WP Cron", "2024-05-31 22:09:34", "2024-05-31 22:09:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1737", "1089281", "action complete via WP Cron", "2024-05-31 22:09:34", "2024-05-31 22:09:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1738", "1089282", "action created", "2024-05-31 22:09:34", "2024-05-31 22:09:34");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1739", "1089282", "action started via WP Cron", "2024-05-31 22:12:48", "2024-05-31 22:12:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1740", "1089282", "action complete via WP Cron", "2024-05-31 22:12:48", "2024-05-31 22:12:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1741", "1089283", "action created", "2024-05-31 22:12:48", "2024-05-31 22:12:48");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1742", "1089283", "action started via WP Cron", "2024-05-31 22:26:03", "2024-05-31 22:26:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1743", "1089283", "action complete via WP Cron", "2024-05-31 22:26:03", "2024-05-31 22:26:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1744", "1089284", "action created", "2024-05-31 22:26:03", "2024-05-31 22:26:03");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1745", "1089284", "action started via WP Cron", "2024-05-31 22:29:15", "2024-05-31 22:29:15");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1746", "1089284", "action complete via WP Cron", "2024-05-31 22:29:16", "2024-05-31 22:29:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1747", "1089285", "action created", "2024-05-31 22:29:16", "2024-05-31 22:29:16");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1748", "1089285", "action started via WP Cron", "2024-05-31 22:42:26", "2024-05-31 22:42:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1749", "1089285", "action complete via WP Cron", "2024-05-31 22:42:26", "2024-05-31 22:42:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1750", "1089286", "action created", "2024-05-31 22:42:26", "2024-05-31 22:42:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1751", "1089286", "action started via WP Cron", "2024-05-31 22:45:39", "2024-05-31 22:45:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1752", "1089286", "action complete via WP Cron", "2024-05-31 22:45:39", "2024-05-31 22:45:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1753", "1089287", "action created", "2024-05-31 22:45:39", "2024-05-31 22:45:39");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1754", "1089287", "action started via WP Cron", "2024-05-31 22:54:32", "2024-05-31 22:54:32");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1755", "1089287", "action complete via WP Cron", "2024-05-31 22:54:33", "2024-05-31 22:54:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1756", "1089288", "action created", "2024-05-31 22:54:33", "2024-05-31 22:54:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1757", "1089288", "action started via WP Cron", "2024-05-31 22:58:43", "2024-05-31 22:58:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1758", "1089288", "action complete via WP Cron", "2024-05-31 22:58:43", "2024-05-31 22:58:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1759", "1089289", "action created", "2024-05-31 22:58:43", "2024-05-31 22:58:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1760", "1089289", "action started via WP Cron", "2024-05-31 23:02:43", "2024-05-31 23:02:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1761", "1089289", "action complete via WP Cron", "2024-05-31 23:02:43", "2024-05-31 23:02:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1762", "1089290", "action created", "2024-05-31 23:02:43", "2024-05-31 23:02:43");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1763", "1089290", "action started via WP Cron", "2024-05-31 23:06:26", "2024-05-31 23:06:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1764", "1089290", "action complete via WP Cron", "2024-05-31 23:06:26", "2024-05-31 23:06:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1765", "1089291", "action created", "2024-05-31 23:06:26", "2024-05-31 23:06:26");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1766", "1089291", "action started via WP Cron", "2024-05-31 23:14:53", "2024-05-31 23:14:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1767", "1089291", "action complete via WP Cron", "2024-05-31 23:14:53", "2024-05-31 23:14:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1768", "1089292", "action created", "2024-05-31 23:14:53", "2024-05-31 23:14:53");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1769", "1089292", "action started via WP Cron", "2024-05-31 23:18:01", "2024-05-31 23:18:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1770", "1089292", "action complete via WP Cron", "2024-05-31 23:18:01", "2024-05-31 23:18:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1771", "1089293", "action created", "2024-05-31 23:18:01", "2024-05-31 23:18:01");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1772", "1089293", "action started via WP Cron", "2024-05-31 23:31:02", "2024-05-31 23:31:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1773", "1089293", "action complete via WP Cron", "2024-05-31 23:31:02", "2024-05-31 23:31:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1774", "1089294", "action created", "2024-05-31 23:31:02", "2024-05-31 23:31:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1775", "1089294", "action started via WP Cron", "2024-05-31 23:34:14", "2024-05-31 23:34:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1776", "1089294", "action complete via WP Cron", "2024-05-31 23:34:14", "2024-05-31 23:34:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1777", "1089295", "action created", "2024-05-31 23:34:14", "2024-05-31 23:34:14");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1778", "1089295", "action started via WP Cron", "2024-05-31 23:50:21", "2024-05-31 23:50:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1779", "1089295", "action complete via WP Cron", "2024-05-31 23:50:21", "2024-05-31 23:50:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1780", "1089296", "action created", "2024-05-31 23:50:21", "2024-05-31 23:50:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1781", "1089296", "action started via WP Cron", "2024-06-01 00:00:05", "2024-06-01 00:00:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1782", "1089296", "action complete via WP Cron", "2024-06-01 00:00:05", "2024-06-01 00:00:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1783", "1089297", "action created", "2024-06-01 00:00:05", "2024-06-01 00:00:05");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1784", "1089297", "action started via WP Cron", "2024-06-01 00:03:21", "2024-06-01 00:03:21");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1785", "1089297", "action complete via WP Cron", "2024-06-01 00:03:22", "2024-06-01 00:03:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1786", "1089298", "action created", "2024-06-01 00:03:22", "2024-06-01 00:03:22");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1787", "1089298", "action started via WP Cron", "2024-06-01 00:06:33", "2024-06-01 00:06:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1788", "1089298", "action complete via WP Cron", "2024-06-01 00:06:33", "2024-06-01 00:06:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1789", "1089299", "action created", "2024-06-01 00:06:33", "2024-06-01 00:06:33");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1790", "1089299", "action started via WP Cron", "2024-06-01 00:23:02", "2024-06-01 00:23:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1791", "1089299", "action complete via WP Cron", "2024-06-01 00:23:02", "2024-06-01 00:23:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1792", "1089300", "action created", "2024-06-01 00:23:02", "2024-06-01 00:23:02");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1793", "1089300", "action started via WP Cron", "2024-06-01 00:36:12", "2024-06-01 00:36:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1794", "1089300", "action complete via WP Cron", "2024-06-01 00:36:12", "2024-06-01 00:36:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1795", "1089301", "action created", "2024-06-01 00:36:12", "2024-06-01 00:36:12");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1796", "1089301", "action started via WP Cron", "2024-06-01 00:39:24", "2024-06-01 00:39:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1797", "1089301", "action complete via WP Cron", "2024-06-01 00:39:24", "2024-06-01 00:39:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1798", "1089302", "action created", "2024-06-01 00:39:24", "2024-06-01 00:39:24");
INSERT INTO `wp8s_actionscheduler_logs` VALUES("1799", "1089302", "action started via WP Cron", "2024-06-01 